/*
 * Decompiled with CFR 0.152.
 */
package water.parser;

import java.util.Arrays;
import water.MemoryManager;
import water.parser.BufferedString;

class CharSkippingBufferedString {
    private int[] _skipped = new int[0];
    private int _skippedWriteIndex = 0;
    private final BufferedString _bufferedString = new BufferedString();

    CharSkippingBufferedString() {
    }

    protected void addChar() {
        this._bufferedString.addChar();
    }

    protected void removeChar() {
        this._bufferedString.removeChar();
    }

    protected byte[] getBuffer() {
        return this._bufferedString.getBuffer();
    }

    protected boolean isOverflown() {
        return this._bufferedString._off + this._bufferedString._len > this._bufferedString.getBuffer().length;
    }

    protected void addBuff(byte[] bits) {
        this._bufferedString.addBuff(bits);
        this._skipped = new int[0];
        this._skippedWriteIndex = 0;
    }

    protected final void skipIndex(int skippedCharIndex) {
        this._bufferedString.addChar();
        if (this._skipped.length == 0 || this._skipped[this._skipped.length - 1] != -1) {
            this._skipped = Arrays.copyOf(this._skipped, Math.max(this._skipped.length + 1, 1));
        }
        this._skipped[this._skippedWriteIndex] = skippedCharIndex;
        ++this._skippedWriteIndex;
    }

    protected void set(byte[] buf, int off, int len) {
        this._skipped = new int[0];
        this._skippedWriteIndex = 0;
        this._bufferedString.set(buf, off, len);
    }

    public BufferedString toBufferedString() {
        if (this._skipped.length == 0) {
            return this._bufferedString;
        }
        byte[] buf = MemoryManager.malloc1(this._bufferedString._len - this._skipped.length);
        int copyStart = this._bufferedString._off;
        int target = 0;
        for (int skippedIndex : this._skipped) {
            for (int i = copyStart; i < skippedIndex; ++i) {
                buf[target++] = this._bufferedString._buf[i];
            }
            copyStart = skippedIndex + 1;
        }
        int windowEnd = this._bufferedString._off + this._bufferedString._len;
        for (int i = copyStart; i < windowEnd; ++i) {
            buf[target++] = this._bufferedString._buf[i];
        }
        assert (target == buf.length);
        return new BufferedString(buf, 0, buf.length);
    }

    public String toString() {
        return this.toBufferedString().toString();
    }
}

