/*
 * Decompiled with CFR 0.152.
 */
package water.fvec.persist;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import water.AutoBuffer;
import water.H2O;
import water.persist.Persist;

public class PersistUtils {
    public static String sanitizeUri(String uri) {
        if (uri.endsWith("/")) {
            return uri.substring(0, uri.length() - 1);
        }
        return uri;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T read(URI uri, Reader<T> r) {
        Persist persist = H2O.getPM().getPersistForURI(uri);
        try (InputStream inputStream = persist.open(uri.toString());){
            AutoBuffer autoBuffer = new AutoBuffer(inputStream);
            T res = r.read(autoBuffer);
            autoBuffer.close();
            T t = res;
            return t;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write to " + uri, e);
        }
    }

    /*
     * Exception decompiling
     */
    public static <T> T readStream(URI uri, StreamReader<T> r) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void write(URI uri, Writer w) {
        Persist persist = H2O.getPM().getPersistForURI(uri);
        try (OutputStream outputStream = persist.create(uri.toString(), true);){
            AutoBuffer autoBuffer = new AutoBuffer(outputStream, true);
            w.write(autoBuffer);
            autoBuffer.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write to " + uri, e);
        }
    }

    public static void writeStream(URI uri, StreamWriter w) {
        Persist persist = H2O.getPM().getPersistForURI(uri);
        try (OutputStream outputStream = persist.create(uri.toString(), true);
             OutputStreamWriter writer = new OutputStreamWriter(outputStream);){
            w.write(writer);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write to " + uri, e);
        }
    }

    public static boolean exists(URI uri) {
        Persist persist = H2O.getPM().getPersistForURI(uri);
        return persist.exists(uri.toString());
    }

    public static interface StreamReader<T> {
        public T read(InputStreamReader var1) throws IOException;
    }

    public static interface StreamWriter {
        public void write(OutputStreamWriter var1) throws IOException;
    }

    public static interface Writer {
        public void write(AutoBuffer var1);
    }

    public static interface Reader<T> {
        public T read(AutoBuffer var1);
    }
}

