/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import water.H2O;
import water.fvec.Chunk;
import water.fvec.ChunkVisitor;
import water.util.UnsafeUtils;

public class CXIChunk
extends Chunk {
    private static long[] _NAS = new long[]{-1L, -1L, -32768L, -1L, Integer.MIN_VALUE, -1L, -1L, -1L, Long.MIN_VALUE};
    transient boolean _isNA;
    transient int _val_sz;
    transient int _elem_sz;
    static final int _OFF = 8;
    private transient int _previousOffset = 8;

    public static long NA(int val_sz) {
        return _NAS[val_sz];
    }

    protected CXIChunk(byte[] mem) {
        this._mem = mem;
        this.initFromBytes();
    }

    @Override
    public int sparseLenZero() {
        return this.isSparseZero() ? this.sparseLen() : this._len;
    }

    @Override
    public int sparseLenNA() {
        return this.isSparseNA() ? this.sparseLen() : this._len;
    }

    protected final int getId(int x) {
        if (x == this._mem.length) {
            return this._len;
        }
        int id_sz = this._elem_sz - this._val_sz;
        return id_sz == 4 ? UnsafeUtils.get4(this._mem, x) : 0xFFFF & UnsafeUtils.get2(this._mem, x);
    }

    private long getVal(int x) {
        switch (this._val_sz) {
            case 0: {
                return 1L;
            }
            case 2: {
                return UnsafeUtils.get2(this._mem, x + 2);
            }
            case 4: {
                return UnsafeUtils.get4(this._mem, x + 4);
            }
            case 8: {
                return UnsafeUtils.get8(this._mem, x + 4);
            }
        }
        throw H2O.unimpl();
    }

    private double getFVal(int x) {
        long ival = this.getVal(x);
        return ival == _NAS[this._val_sz] ? Double.NaN : (double)ival;
    }

    @Override
    public final boolean isSparseNA() {
        return this._isNA;
    }

    @Override
    public final boolean isSparseZero() {
        return !this._isNA;
    }

    @Override
    protected final void initFromBytes() {
        this._start = -1L;
        this._cidx = -1;
        this._len = UnsafeUtils.get4(this._mem, 0);
        int id_sz = this._mem[4] & 0xFF;
        this._val_sz = this._mem[5] & 0xFF;
        this._elem_sz = this._val_sz + id_sz;
        this._isNA = (0xFF & this._mem[6]) == 1;
        this._previousOffset = 8;
    }

    protected final int sparseLen() {
        return (this._mem.length - 8) / this._elem_sz;
    }

    protected final int getOff(int id) {
        return 8 + this._elem_sz * id;
    }

    protected final int getIdx(int off) {
        return (off - 8) / this._elem_sz;
    }

    protected final int findOffset(int i) {
        int ub;
        int off = this._previousOffset;
        int id = this.getId(off);
        if (id == i) {
            return off;
        }
        if (id < i && (id = this.getId(off += this._elem_sz)) == i) {
            this._previousOffset = off;
            return off;
        }
        int lb = id < i ? this.getIdx(off) : 0;
        int n = ub = id > i ? this.getIdx(off) : this.sparseLen();
        while (lb < ub) {
            int mid = lb + (ub - lb >> 1);
            off = this.getOff(mid);
            int x = this.getId(off);
            if (x == i) {
                this._previousOffset = off;
                return off;
            }
            if (x < i) {
                lb = mid + 1;
                continue;
            }
            ub = mid;
        }
        return -this.getOff(ub) - 1;
    }

    @Override
    public long at8_impl(int idx) {
        int x = this.findOffset(idx);
        if (x < 0) {
            if (this._isNA) {
                throw new RuntimeException("at8 but the value is missing!");
            }
            return 0L;
        }
        long val = this.getVal(x);
        if (val == _NAS[this._val_sz]) {
            throw new RuntimeException("at4 but the value is missing!");
        }
        return val;
    }

    @Override
    public double atd_impl(int idx) {
        int x = this.findOffset(idx);
        if (x < 0) {
            return this._isNA ? Double.NaN : 0.0;
        }
        return this.getFVal(x);
    }

    @Override
    public final boolean isNA_impl(int i) {
        return Double.isNaN(this.atd(i));
    }

    @Override
    boolean set_impl(int idx, long l) {
        return false;
    }

    @Override
    boolean set_impl(int idx, double d) {
        return false;
    }

    @Override
    boolean set_impl(int idx, float f) {
        return false;
    }

    @Override
    boolean setNA_impl(int idx) {
        return false;
    }

    @Override
    public boolean hasNA() {
        return true;
    }

    @Override
    public Chunk deepCopy() {
        return new CXIChunk((byte[])this._mem.clone());
    }

    @Override
    public final int len() {
        return this._len;
    }

    @Override
    public final int nextNZ(int i) {
        int x = this.findOffset(i);
        if (x < 0) {
            x = -x - 1 - this._elem_sz;
        }
        this._previousOffset = x += this._elem_sz;
        return this.getId(x);
    }

    @Override
    public final int nextNZ(int rid, boolean onlyTrueZero) {
        return onlyTrueZero && this._isNA ? rid + 1 : this.nextNZ(rid);
    }

    @Override
    public <T extends ChunkVisitor> T processRows(T v, int from, int to) {
        int id;
        int x;
        int prevId = from - 1;
        int n = x = from == 0 ? 8 : this.findOffset(from);
        if (x < 0) {
            x = -x - 1;
        }
        while (x < this._mem.length && (id = this.getId(x)) < to) {
            if (this._isNA) {
                v.addNAs(id - prevId - 1);
            } else {
                v.addZeros(id - prevId - 1);
            }
            long val = this.getVal(x);
            if (val == _NAS[this._val_sz]) {
                v.addNAs(1);
            } else {
                v.addValue(val);
            }
            prevId = id;
            x += this._elem_sz;
        }
        if (this._isNA) {
            v.addNAs(to - prevId - 1);
        } else {
            v.addZeros(to - prevId - 1);
        }
        return v;
    }

    @Override
    public <T extends ChunkVisitor> T processRows(T v, int[] ids) {
        int x = 8;
        int zeros = 0;
        for (int k = 0; k < ids.length; ++k) {
            int idk = ids[k];
            assert (ids[k] >= 0 && (k == 0 || ids[k] > ids[k - 1]));
            int idx = ids[ids.length - 1] + 1;
            while (x < this._mem.length && (idx = this.getId(x)) < idk) {
                x += this._elem_sz;
            }
            if (x == this._mem.length) {
                zeros += ids.length - k;
                break;
            }
            if (idx == idk) {
                if (this._isNA) {
                    v.addNAs(zeros);
                } else {
                    v.addZeros(zeros);
                }
                long val = this.getVal(x);
                if (val == _NAS[this._val_sz]) {
                    v.addNAs(1);
                } else {
                    v.addValue(val);
                }
                zeros = 0;
                x += this._elem_sz;
                continue;
            }
            ++zeros;
        }
        if (zeros > 0) {
            if (this._isNA) {
                v.addNAs(zeros);
            } else {
                v.addZeros(zeros);
            }
        }
        return v;
    }

    @Override
    public boolean hasFloat() {
        return false;
    }
}

