/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import water.MemoryManager;
import water.fvec.Chunk;
import water.fvec.ChunkVisitor;

public class CBSChunk
extends Chunk {
    protected static final byte _NA = 2;
    protected static final int _OFF = 2;
    private transient byte _bpv;
    private transient byte _gap;

    public byte bpv() {
        return this._bpv;
    }

    public byte gap() {
        return this._gap;
    }

    public CBSChunk(boolean[] vals) {
        this._len = vals.length;
        this._bpv = 1;
        int memlen = this._len >> 3 + (this._len & 7) == 0 ? 0 : 1;
        this._mem = MemoryManager.malloc1(memlen);
        this._mem[0] = this._gap = (byte)(vals.length & 7);
        this._mem[1] = this._bpv;
        for (int i = 0; i < vals.length; ++i) {
            if (!vals[i]) continue;
            this.write(i, (byte)1);
        }
    }

    public CBSChunk(byte[] bs) {
        this._mem = bs;
        this.initFromBytes();
    }

    public CBSChunk(int len, int bpv) {
        this._gap = (byte)(8 - (len * bpv & 7) & 7);
        int clen = 2 + (len >> 3 - bpv + 1) + (this._gap == 0 ? 0 : 1);
        byte[] bs = MemoryManager.malloc1(clen);
        bs[0] = this._gap;
        bs[1] = this._bpv = (byte)bpv;
        assert (clen - 2 - (this._gap == 0 ? 0 : 1) == len >> 3 - bpv + 1);
        this._mem = bs;
        this._start = -1L;
        this._len = len;
    }

    @Override
    protected long at8_impl(int idx) {
        byte b = this.read(idx);
        if (b == 2) {
            throw new IllegalArgumentException("at8_abs but value is missing");
        }
        return b;
    }

    @Override
    protected double atd_impl(int idx) {
        byte b = this.read(idx);
        return b == 2 ? Double.NaN : (double)b;
    }

    @Override
    protected final boolean isNA_impl(int i) {
        return this.read(i) == 2;
    }

    private void set_byte(int idx, byte val) {
        int bix = 2 + (idx * this._bpv >> 3);
        int off = this._bpv * idx & 7;
        int mask = ~((1 | this._bpv) << off);
        this._mem[bix] = (byte)(this._mem[bix] & mask | val << off);
    }

    void write(int idx, byte val) {
        int bix = 2 + (idx * this._bpv >> 3);
        int off = this._bpv * idx & 7;
        this.write(bix, off, val);
    }

    protected byte read(int idx) {
        int bix = 2 + (idx * this._bpv >> 3);
        int off = this._bpv * idx & 7;
        int mask = 1 | this._bpv;
        return this.read(this._mem[bix], off, mask);
    }

    @Override
    boolean set_impl(int idx, long l) {
        if (l == 1L || l == 0L) {
            this.set_byte(idx, (byte)l);
            return true;
        }
        return false;
    }

    @Override
    boolean set_impl(int idx, double d) {
        if (Double.isNaN(d)) {
            return this.setNA_impl(idx);
        }
        if (d == 0.0 || d == 1.0) {
            this.set_byte(idx, (byte)d);
            return true;
        }
        return false;
    }

    @Override
    boolean set_impl(int idx, float f) {
        if (Float.isNaN(f)) {
            return this.setNA_impl(idx);
        }
        if (f == 0.0f || f == 1.0f) {
            this.set_byte(idx, (byte)f);
            return true;
        }
        return false;
    }

    @Override
    boolean setNA_impl(int idx) {
        if (this._bpv == 2) {
            this.set_byte(idx, (byte)2);
            return true;
        }
        return false;
    }

    private void processRow(int r, ChunkVisitor v) {
        byte i = this.read(r);
        if (i == 2) {
            v.addNAs(1);
        } else {
            v.addValue(i);
        }
    }

    public ChunkVisitor processRows(ChunkVisitor v, int from, int to) {
        for (int i = from; i < to; ++i) {
            this.processRow(i, v);
        }
        return v;
    }

    public ChunkVisitor processRows(ChunkVisitor v, int ... rows) {
        for (int i : rows) {
            this.processRow(i, v);
        }
        return v;
    }

    private byte read(int b, int off, int mask) {
        return (byte)(b >> off & mask);
    }

    private byte write(int bix, int off, int val) {
        int n = bix;
        byte by = (byte)(this._mem[n] | val << off);
        this._mem[n] = by;
        return by;
    }

    public static int clen(int values, int bpv) {
        int len = values * bpv >> 3;
        return values * bpv % 8 == 0 ? len : len + 1;
    }

    @Override
    double min() {
        return 0.0;
    }

    @Override
    double max() {
        return 1.0;
    }

    @Override
    protected final void initFromBytes() {
        this._start = -1L;
        this._cidx = -1;
        this._gap = this._mem[0];
        this._bpv = this._mem[1];
        this.set_len(((this._mem.length - 2) * 8 - this._gap) / this._bpv);
    }

    @Override
    public boolean hasFloat() {
        return false;
    }
}

