/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import water.fvec.CSChunk;
import water.fvec.ChunkVisitor;
import water.util.PrettyPrint;
import water.util.UnsafeUtils;

public class C2SChunk
extends CSChunk {
    C2SChunk(byte[] bs, long bias, int scale) {
        super(bs, bias, scale, 1);
        if (scale < 0) {
            double div = PrettyPrint.pow10(1L, -scale);
            for (int i = 0; i < this._len; ++i) {
                int x = this.getMantissa(i);
                if (x == Short.MIN_VALUE || this.getD(x, Short.MIN_VALUE, Double.NaN) == (double)((long)x + bias) / div) continue;
                this.setDecimal();
                break;
            }
        }
    }

    @Override
    protected final long at8_impl(int i) {
        int x = this.getMantissa(i);
        if (x == Short.MIN_VALUE) {
            throw new IllegalArgumentException("at8_abs but value is missing");
        }
        return this.get8(x);
    }

    private int getMantissa(int i) {
        return UnsafeUtils.get2(this._mem, 16 + 2 * i);
    }

    private void setMantissa(int i, short s) {
        UnsafeUtils.set2(this._mem, i * 2 + 16, s);
    }

    @Override
    protected final double atd_impl(int i) {
        return this.getD(this.getMantissa(i), Short.MIN_VALUE);
    }

    @Override
    protected final boolean isNA_impl(int i) {
        return this.getMantissa(i) == Short.MIN_VALUE;
    }

    @Override
    boolean set_impl(int i, double x) {
        if (Double.isNaN(x)) {
            return this.setNA_impl(i);
        }
        int y = this.getScaledValue(x, Short.MIN_VALUE);
        short s = (short)y;
        if (this.getD(s, Short.MIN_VALUE, Double.NaN) != x) {
            return false;
        }
        this.setMantissa(i, s);
        assert (!this.isNA_impl(i));
        return true;
    }

    @Override
    boolean setNA_impl(int idx) {
        this.setMantissa(idx, (short)Short.MIN_VALUE);
        return true;
    }

    @Override
    public double[] getDoubles(double[] vals, int from, int to, double NA) {
        for (int i = from; i < to; ++i) {
            vals[i - from] = this.getD(this.getMantissa(i), Short.MIN_VALUE, NA);
        }
        return vals;
    }

    @Override
    public double[] getDoubles(double[] vals, int[] ids) {
        int k = 0;
        for (int i : ids) {
            vals[k++] = this.getD(this.getMantissa(i), Short.MIN_VALUE);
        }
        return vals;
    }

    private <T extends ChunkVisitor> void processRow(T v, int i, long bias, int exp) {
        long x = this.getMantissa(i);
        if (x == -32768L) {
            v.addNAs(1);
        } else {
            v.addValue(x + bias, exp);
        }
    }

    @Override
    protected <T extends ChunkVisitor> T processRows2(T v, int from, int to, long bias, int exp) {
        for (int i = from; i < to; ++i) {
            this.processRow(v, i, bias, exp);
        }
        return v;
    }

    @Override
    protected <T extends ChunkVisitor> T processRows2(T v, int from, int to) {
        for (int i = from; i < to; ++i) {
            v.addValue(this.getD(this.getMantissa(i), Short.MIN_VALUE));
        }
        return v;
    }

    @Override
    protected <T extends ChunkVisitor> T processRows2(T v, int[] ids, long bias, int exp) {
        for (int i : ids) {
            this.processRow(v, i, bias, exp);
        }
        return v;
    }

    @Override
    protected <T extends ChunkVisitor> T processRows2(T v, int[] ids) {
        for (int i : ids) {
            v.addValue(this.getD(this.getMantissa(i), Short.MIN_VALUE));
        }
        return v;
    }
}

