/*
 * Decompiled with CFR 0.152.
 */
package water.api.schemas3;

import hex.ModelMetricsHGLM;
import water.api.API;
import water.api.schemas3.ModelMetricsBaseV3;

public class ModelMetricsHGLMV3<I extends ModelMetricsHGLM, S extends ModelMetricsHGLMV3<I, S>>
extends ModelMetricsBaseV3<I, S> {
    @API(help="standard error of fixed predictors/effects", direction=API.Direction.OUTPUT)
    public double[] sefe;
    @API(help="standard error of random effects", direction=API.Direction.OUTPUT)
    public double[] sere;
    @API(help="dispersion parameter of the mean model (residual variance for LMM)", direction=API.Direction.OUTPUT)
    public double varfix;
    @API(help="dispersion parameter of the random effects (variance of random effects for GLMM", direction=API.Direction.OUTPUT)
    public double[] varranef;
    @API(help="fixed coefficient)", direction=API.Direction.OUTPUT)
    public double[] fixef;
    @API(help="random coefficients", direction=API.Direction.OUTPUT)
    public double[] ranef;
    @API(help="true if model has converged", direction=API.Direction.OUTPUT)
    public boolean converge;
    @API(help="number of random columns", direction=API.Direction.OUTPUT)
    public int[] randc;
    @API(help="deviance degrees of freedom for mean part of the model", direction=API.Direction.OUTPUT)
    public double dfrefe;
    @API(help="estimates, standard errors of the linear predictor in the dispersion model", direction=API.Direction.OUTPUT)
    public double[] summvc1;
    @API(help="estimates, standard errors of the linear predictor for dispersion parameter of random effects", direction=API.Direction.OUTPUT)
    public double[][] summvc2;
    @API(help="log h-likelihood", direction=API.Direction.OUTPUT)
    public double hlik;
    @API(help="adjusted profile log-likelihood profiled over random effects", direction=API.Direction.OUTPUT)
    public double pvh;
    @API(help="adjusted profile log-likelihood profiled over fixed and random effects", direction=API.Direction.OUTPUT)
    public double pbvh;
    @API(help="conditional AIC", direction=API.Direction.OUTPUT)
    public double caic;
    @API(help="index of the most influential observation", direction=API.Direction.OUTPUT)
    public long bad;
    @API(help="sum(etai-eta0)^2 where etai is current eta and eta0 is the previous one", direction=API.Direction.OUTPUT)
    public double sumetadiffsquare;
    @API(help="sum(etai-eta0)^2/sum(etai)^2 ", direction=API.Direction.OUTPUT)
    public double convergence;

    @Override
    public S fillFromImpl(ModelMetricsHGLM modelMetrics) {
        super.fillFromImpl(modelMetrics);
        this.hlik = modelMetrics._hlik;
        this.pvh = modelMetrics._pvh;
        this.pbvh = modelMetrics._pbvh;
        this.caic = modelMetrics._caic;
        this.bad = modelMetrics._bad;
        this.sumetadiffsquare = modelMetrics._sumetadiffsquare;
        this.convergence = modelMetrics._convergence;
        this.randc = modelMetrics._randc;
        this.fixef = modelMetrics._fixef;
        this.ranef = modelMetrics._ranef;
        this.varfix = modelMetrics._varfix;
        this.varranef = modelMetrics._varranef;
        this.converge = modelMetrics._converge;
        this.dfrefe = modelMetrics._dfrefe;
        this.sefe = new double[modelMetrics._sefe.length];
        System.arraycopy(modelMetrics._sefe, 0, this.sefe, 0, this.sefe.length);
        this.sere = new double[modelMetrics._sere.length];
        System.arraycopy(modelMetrics._sere, 0, this.sere, 0, this.sere.length);
        this.varranef = new double[modelMetrics._varranef.length];
        System.arraycopy(modelMetrics._varranef, 0, this.varranef, 0, this.varranef.length);
        this.summvc1 = new double[modelMetrics._summvc1.length];
        System.arraycopy(modelMetrics._summvc1, 0, this.summvc1, 0, this.summvc1.length);
        int numRandCol = this.randc.length;
        this.summvc2 = new double[numRandCol][];
        for (int index = 0; index < numRandCol; ++index) {
            int l = modelMetrics._summvc2[index].length;
            this.summvc2[index] = new double[l];
            System.arraycopy(modelMetrics._summvc2[index], 0, this.summvc2[index], 0, l);
        }
        return (S)this;
    }
}

