/*
 * Decompiled with CFR 0.152.
 */
package water;

import java.net.InetAddress;
import java.net.UnknownHostException;
import sun.misc.Unsafe;
import water.AutoBuffer;
import water.H2O;
import water.H2ONode;
import water.UDP;
import water.nbhm.UtilUnsafe;
import water.util.Log;

public class TimeLine
extends UDP {
    private static final Unsafe _unsafe = UtilUnsafe.getUnsafe();
    public static final int MAX_EVENTS = 2048;
    static final int WORDS_PER_EVENT = 4;
    static final long[] TIMELINE = new long[8193];
    static long JVM_BOOT_MSEC = System.currentTimeMillis();
    private static final int _Lbase = _unsafe.arrayBaseOffset(long[].class);
    private static final int _Lscale = _unsafe.arrayIndexScale(long[].class);
    static long[][] SNAPSHOT;
    static long TIME_LAST_SNAPSHOT;
    private static H2O CLOUD;

    private static long[] snapshot() {
        return (long[])TIMELINE.clone();
    }

    private static long rawIndex(long[] ary, int i) {
        assert (i >= 0 && i < ary.length);
        return _Lbase + i * _Lscale;
    }

    private static boolean CAS(long[] A, int idx, long old, long nnn) {
        return _unsafe.compareAndSwapLong(A, TimeLine.rawIndex(A, idx), old, nnn);
    }

    private static int next_idx(long[] tl) {
        int newidx;
        int oldidx;
        while (!TimeLine.CAS(tl, 0, oldidx = (int)tl[0], newidx = oldidx + 1 & 0x7FF)) {
        }
        return oldidx;
    }

    private static void record2(H2ONode h2o, long ns, boolean tcp, int sr, int drop, long b0, long b8) {
        long ms = System.currentTimeMillis();
        long deltams = ms - JVM_BOOT_MSEC;
        assert (deltams < 0xFFFFFFFFL);
        long[] tl = TIMELINE;
        int idx = TimeLine.next_idx(tl);
        tl[idx * 4 + 0 + 1] = deltams << 32 | (long)h2o.ip4() & 0xFFFFFFFFL;
        tl[idx * 4 + 1 + 1] = ns & 0xFFFFFFFFFFFFFFF8L | (long)(tcp ? 4 : 0) | (long)sr | (long)drop;
        if (sr == 0) {
            b0 = b0 & 0xFFFFFFFFFF0000FFL | (long)(h2o._key.getInternalPort() << 8);
        }
        tl[idx * 4 + 2 + 1] = b0;
        tl[idx * 4 + 3 + 1] = b8;
    }

    private static void record1(AutoBuffer b, boolean tcp, int sr, int drop) {
        try {
            int lim = b._bb.limit();
            int pos = b._bb.position();
            b._bb.limit(16);
            long lo = b.get8(0);
            long hi = b.get8(8);
            long ns = System.nanoTime();
            TimeLine.record2(b._h2o, ns, tcp, sr, drop, lo, hi);
            b._bb.limit(lim);
            b._bb.position(pos);
        }
        catch (Throwable t) {
            Log.err("Timeline record failed, " + t.toString(), t);
        }
    }

    static void record_send(AutoBuffer b, boolean tcp) {
        TimeLine.record1(b, tcp, 0, 0);
    }

    static void record_recv(AutoBuffer b, boolean tcp, int drop) {
        TimeLine.record1(b, tcp, 1, drop);
    }

    public static int length() {
        return 2048;
    }

    private static int idx(long[] tl, int i) {
        return ((int)tl[0] + i & 0x7FF) * 4 + 1;
    }

    private static long x0(long[] tl, int idx) {
        return tl[TimeLine.idx(tl, idx)];
    }

    public static long ms(long[] tl, int idx) {
        return TimeLine.x0(tl, idx) >>> 32;
    }

    public static InetAddress inet(long[] tl, int idx) {
        int adr = (int)TimeLine.x0(tl, idx);
        byte[] ip4 = new byte[]{(byte)adr, (byte)(adr >> 8), (byte)(adr >> 16), (byte)(adr >> 24)};
        try {
            return InetAddress.getByAddress(ip4);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public static long ns(long[] tl, int idx) {
        return tl[TimeLine.idx(tl, idx) + 1];
    }

    public static int send_recv(long[] tl, int idx) {
        return (int)(TimeLine.ns(tl, idx) & 1L);
    }

    public static int dropped(long[] tl, int idx) {
        return (int)(TimeLine.ns(tl, idx) & 2L);
    }

    public static long l0(long[] tl, int idx) {
        return tl[TimeLine.idx(tl, idx) + 2];
    }

    public static long l8(long[] tl, int idx) {
        return tl[TimeLine.idx(tl, idx) + 3];
    }

    public static boolean isEmpty(long[] tl, int idx) {
        return tl[TimeLine.idx(tl, idx)] == 0L;
    }

    public static H2O getCLOUD() {
        return CLOUD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long[][] system_snapshot() {
        Class<TimeLine> clazz = TimeLine.class;
        synchronized (TimeLine.class) {
            long now = System.currentTimeMillis();
            if (now - TIME_LAST_SNAPSHOT < 3000L) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return SNAPSHOT;
            }
            if (TIME_LAST_SNAPSHOT != 0L) {
                TIME_LAST_SNAPSHOT = 0L;
                CLOUD = H2O.CLOUD;
                SNAPSHOT = new long[CLOUD.size()][];
                new AutoBuffer(H2O.SELF, UDP.udp.timeline._prior).putUdp(UDP.udp.timeline).close();
            }
            while (true) {
                boolean done = true;
                for (int i = 0; i < TimeLine.CLOUD._memary.length; ++i) {
                    if (SNAPSHOT[i] != null) continue;
                    done = false;
                }
                if (done) break;
                try {
                    TimeLine.class.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            TIME_LAST_SNAPSHOT = System.currentTimeMillis();
            // ** MonitorExit[var0] (shouldn't be in output)
            return SNAPSHOT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    AutoBuffer call(AutoBuffer ab) {
        long[] a = TimeLine.snapshot();
        if (ab._h2o == H2O.SELF) {
            Class<TimeLine> clazz = TimeLine.class;
            synchronized (TimeLine.class) {
                if (CLOUD != null) {
                    for (int i = 0; i < TimeLine.CLOUD._memary.length; ++i) {
                        if (TimeLine.CLOUD._memary[i] != H2O.SELF) continue;
                        TimeLine.SNAPSHOT[i] = a;
                    }
                }
                TimeLine.class.notify();
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        } else {
            new AutoBuffer(ab._h2o, UDP.udp.timeline._prior).putUdp(UDP.udp.timeline).putA8(a).close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void tcp_call(AutoBuffer ab) {
        int idx;
        ab.getPort();
        long[] snap = ab.getA8();
        if (CLOUD != null && (idx = CLOUD.nidx(ab._h2o)) >= 0 && idx < SNAPSHOT.length) {
            TimeLine.SNAPSHOT[idx] = snap;
        }
        ab.close();
        Class<TimeLine> clazz = TimeLine.class;
        synchronized (TimeLine.class) {
            TimeLine.class.notify();
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return;
        }
    }

    @Override
    String print16(AutoBuffer ab) {
        return "";
    }

    static void printMyTimeLine() {
        long[] s = TimeLine.snapshot();
        System.err.println("===================================<TIMELINE>==============================================");
        for (int i = 0; i < TimeLine.length(); ++i) {
            String op;
            long lo = TimeLine.l0(s, i);
            long hi = TimeLine.l8(s, i);
            int port = (int)(lo >> 8 & 0xFFFFL);
            String string = op = TimeLine.send_recv(s, i) == 0 ? "SEND" : "RECV";
            if (TimeLine.isEmpty(s, i) || (lo & 0xFFL) != (long)UDP.udp.exec.ordinal()) continue;
            System.err.println(TimeLine.ms(s, i) + ": " + op + " " + ((TimeLine.ns(s, i) & 4L) != 0L ? "TCP" : "UDP") + TimeLine.inet(s, i) + ":" + port + " | " + UDP.printx16(lo, hi));
        }
        System.err.println("===========================================================================================");
    }

    static {
        TIME_LAST_SNAPSHOT = 1L;
    }
}

