/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.FeatureInteraction;
import hex.genmodel.algos.tree.SharedTreeNode;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import org.apache.commons.lang.mutable.MutableInt;
import water.util.TwoDimTable;

public class FeatureInteractions {
    private final HashMap<String, FeatureInteraction> map = new HashMap();

    public void mergeWith(FeatureInteractions featureInteractions) {
        for (Map.Entry<String, FeatureInteraction> currEntry : featureInteractions.entrySet()) {
            if (this.map.containsKey(currEntry.getKey())) {
                FeatureInteraction leftFeatureInteraction = this.get(currEntry.getKey());
                FeatureInteraction rightFeatureInteraction = currEntry.getValue();
                leftFeatureInteraction.gain += rightFeatureInteraction.gain;
                leftFeatureInteraction.cover += rightFeatureInteraction.cover;
                leftFeatureInteraction.fScore += rightFeatureInteraction.fScore;
                leftFeatureInteraction.fScoreWeighted += rightFeatureInteraction.fScoreWeighted;
                leftFeatureInteraction.averageFScoreWeighted = leftFeatureInteraction.fScoreWeighted / leftFeatureInteraction.fScore;
                leftFeatureInteraction.averageGain = leftFeatureInteraction.gain / leftFeatureInteraction.fScore;
                leftFeatureInteraction.expectedGain += rightFeatureInteraction.expectedGain;
                leftFeatureInteraction.treeIndex += rightFeatureInteraction.treeIndex;
                leftFeatureInteraction.averageTreeIndex = leftFeatureInteraction.treeIndex / leftFeatureInteraction.fScore;
                leftFeatureInteraction.treeDepth += rightFeatureInteraction.treeDepth;
                leftFeatureInteraction.averageTreeDepth = leftFeatureInteraction.treeDepth / leftFeatureInteraction.fScore;
                leftFeatureInteraction.sumLeafCoversRight += rightFeatureInteraction.sumLeafCoversRight;
                leftFeatureInteraction.sumLeafCoversLeft += rightFeatureInteraction.sumLeafCoversLeft;
                leftFeatureInteraction.sumLeafValuesRight += rightFeatureInteraction.sumLeafValuesRight;
                leftFeatureInteraction.sumLeafValuesLeft += rightFeatureInteraction.sumLeafValuesLeft;
                leftFeatureInteraction.splitValueHistogram.merge(rightFeatureInteraction.splitValueHistogram);
                continue;
            }
            this.put(currEntry.getKey(), currEntry.getValue());
        }
    }

    public int maxDepth() {
        return ((FeatureInteraction)Collections.max(this.entrySet(), Comparator.comparingInt((ToIntFunction<Map.Entry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)I, lambda$maxDepth$0(java.util.Map$Entry ), (Ljava/util/Map$Entry;)I)())).getValue()).depth;
    }

    public TwoDimTable[] getAsTable() {
        int maxDepth = this.maxDepth();
        TwoDimTable[] twoDimTables = new TwoDimTable[maxDepth + 1];
        for (int depth = 0; depth < maxDepth + 1; ++depth) {
            twoDimTables[depth] = this.constructFeatureInteractionsTable(depth);
        }
        return twoDimTables;
    }

    List<FeatureInteraction> getFeatureInteractionsOfDepth(int depthRequired) {
        return this.entrySet().stream().filter(entry -> ((FeatureInteraction)entry.getValue()).depth == depthRequired).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    List<FeatureInteraction> getFeatureInteractionsWithLeafStatistics() {
        return this.entrySet().stream().filter(entry -> ((FeatureInteraction)entry.getValue()).hasLeafStatistics).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    TwoDimTable constructFeatureInteractionsTable(int depth) {
        String[] colHeaders = new String[]{"Interaction", "Gain", "FScore", "wFScore", "Average wFScore", "Average Gain", "Expected Gain", "Gain Rank", "FScore Rank", "wFScore Rank", "Avg wFScore Rank", "Avg Gain Rank", "Expected Gain Rank", "Average Rank", "Average Tree Index", "Average Tree Depth"};
        String[] colTypes = new String[]{"string", "double", "double", "double", "double", "double", "double", "int", "int", "int", "int", "int", "int", "double", "double", "double"};
        String[] colFormat = new String[]{"%s", "%.5f", "%.5f", "%.5f", "%.5f", "%.5f", "%.5f", "%d", "%d", "%d", "%d", "%d", "%d", "%.5f", "%.5f", "%.5f"};
        List<FeatureInteraction> featureInteractions = this.getFeatureInteractionsOfDepth(depth);
        int numRows = featureInteractions.size();
        ArrayList<FeatureInteraction> gainSorted = new ArrayList<FeatureInteraction>(featureInteractions);
        gainSorted.sort(Comparator.comparing(entry -> -entry.gain));
        ArrayList<FeatureInteraction> fScoreSorted = new ArrayList<FeatureInteraction>(featureInteractions);
        fScoreSorted.sort(Comparator.comparing(entry -> -entry.fScore));
        ArrayList<FeatureInteraction> fScoreWeightedSorted = new ArrayList<FeatureInteraction>(featureInteractions);
        fScoreWeightedSorted.sort(Comparator.comparing(entry -> -entry.fScoreWeighted));
        ArrayList<FeatureInteraction> averagefScoreWeightedSorted = new ArrayList<FeatureInteraction>(featureInteractions);
        averagefScoreWeightedSorted.sort(Comparator.comparing(entry -> -entry.averageFScoreWeighted));
        ArrayList<FeatureInteraction> averageGainSorted = new ArrayList<FeatureInteraction>(featureInteractions);
        averageGainSorted.sort(Comparator.comparing(entry -> -entry.averageGain));
        ArrayList<FeatureInteraction> expectedGainSorted = new ArrayList<FeatureInteraction>(featureInteractions);
        expectedGainSorted.sort(Comparator.comparing(entry -> -entry.expectedGain));
        TwoDimTable table = new TwoDimTable("Interaction Depth " + depth, null, new String[numRows], colHeaders, colTypes, colFormat, "");
        for (int i = 0; i < numRows; ++i) {
            String name = featureInteractions.get((int)i).name;
            table.set(i, 0, name);
            table.set(i, 1, featureInteractions.get((int)i).gain);
            table.set(i, 2, featureInteractions.get((int)i).fScore);
            table.set(i, 3, featureInteractions.get((int)i).fScoreWeighted);
            table.set(i, 4, featureInteractions.get((int)i).averageFScoreWeighted);
            table.set(i, 5, featureInteractions.get((int)i).averageGain);
            table.set(i, 6, featureInteractions.get((int)i).expectedGain);
            double gainRank = this.indexOfInteractionWithName(name, gainSorted) + 1;
            table.set(i, 7, gainRank);
            double FScoreRank = this.indexOfInteractionWithName(name, fScoreSorted) + 1;
            table.set(i, 8, FScoreRank);
            double FScoreWeightedRank = this.indexOfInteractionWithName(name, fScoreWeightedSorted) + 1;
            table.set(i, 9, FScoreWeightedRank);
            double avgFScoreWeightedRank = this.indexOfInteractionWithName(name, averagefScoreWeightedSorted) + 1;
            table.set(i, 10, avgFScoreWeightedRank);
            double averageGain = this.indexOfInteractionWithName(name, averageGainSorted) + 1;
            table.set(i, 11, averageGain);
            double expectedGain = this.indexOfInteractionWithName(name, expectedGainSorted) + 1;
            table.set(i, 12, expectedGain);
            table.set(i, 13, (gainRank + FScoreRank + FScoreWeightedRank + avgFScoreWeightedRank + averageGain + expectedGain) / 6.0);
            table.set(i, 14, featureInteractions.get((int)i).averageTreeIndex);
            table.set(i, 15, featureInteractions.get((int)i).averageTreeDepth);
        }
        return table;
    }

    int indexOfInteractionWithName(String name, List<FeatureInteraction> featureInteractions) {
        for (int i = 0; i < featureInteractions.size(); ++i) {
            if (featureInteractions.get((int)i).name != name) continue;
            return i;
        }
        return -1;
    }

    public TwoDimTable getLeafStatisticsTable() {
        String[] colHeaders = new String[]{"Interaction", "Sum Leaf Values Left", "Sum Leaf Values Right", "Sum Leaf Covers Left", "Sum Leaf Covers Right"};
        String[] colTypes = new String[]{"string", "double", "double", "double", "double"};
        String[] colFormat = new String[]{"%s", "%.5f", "%.5f", "%.5f", "%.5f"};
        List<FeatureInteraction> featureInteractions = this.getFeatureInteractionsWithLeafStatistics();
        int numRows = featureInteractions.size();
        TwoDimTable table = new TwoDimTable("Leaf Statistics", null, new String[numRows], colHeaders, colTypes, colFormat, "");
        for (int i = 0; i < numRows; ++i) {
            table.set(i, 0, featureInteractions.get((int)i).name);
            table.set(i, 1, featureInteractions.get((int)i).sumLeafValuesLeft);
            table.set(i, 2, featureInteractions.get((int)i).sumLeafValuesRight);
            table.set(i, 3, featureInteractions.get((int)i).sumLeafCoversLeft);
            table.set(i, 4, featureInteractions.get((int)i).sumLeafCoversRight);
        }
        return table;
    }

    public TwoDimTable[] getSplitValueHistograms() {
        List<FeatureInteraction> featureInteractions = this.getFeatureInteractionsOfDepth(0);
        int numHistograms = featureInteractions.size();
        TwoDimTable[] splitValueHistograms = new TwoDimTable[numHistograms];
        for (int i = 0; i < numHistograms; ++i) {
            splitValueHistograms[i] = this.constructHistogramForFeatureInteraction(featureInteractions.get(i));
        }
        return splitValueHistograms;
    }

    TwoDimTable constructHistogramForFeatureInteraction(FeatureInteraction featureInteraction) {
        String[] colHeaders = new String[]{"Split Value", "Count"};
        String[] colTypes = new String[]{"double", "int"};
        String[] colFormat = new String[]{"%.5f", "%d"};
        int N = featureInteraction.splitValueHistogram.entrySet().size();
        TwoDimTable table = new TwoDimTable(featureInteraction.name + " Split Value Histogram", null, new String[N], colHeaders, colTypes, colFormat, "");
        int i = 0;
        for (Map.Entry<Double, MutableInt> entry : featureInteraction.splitValueHistogram.entrySet()) {
            table.set(i, 0, entry.getKey());
            table.set(i, 1, entry.getValue().intValue());
            ++i;
        }
        return table;
    }

    public int size() {
        return this.map.size();
    }

    public FeatureInteraction get(String key) {
        return this.map.get(key);
    }

    public FeatureInteraction put(String key, FeatureInteraction value) {
        return this.map.put(key, value);
    }

    public Set<Map.Entry<String, FeatureInteraction>> entrySet() {
        return this.map.entrySet();
    }

    public static void collectFeatureInteractions(SharedTreeNode node, List<SharedTreeNode> interactionPath, double currentGain, double currentCover, double pathProba, int depth, int deepening, FeatureInteractions featureInteractions, Set<String> memo, int maxInteractionDepth, int maxTreeDepth, int maxDeepening, int treeIndex, boolean useSquaredErrorForGain) {
        SharedTreeNode rightChild;
        if (node.isLeaf() || depth == maxTreeDepth) {
            return;
        }
        interactionPath.add(node);
        double ppl = pathProba * (double)(node.getLeftChild().getWeight() / node.getWeight());
        double ppr = pathProba * (double)(node.getRightChild().getWeight() / node.getWeight());
        FeatureInteraction featureInteraction = new FeatureInteraction(interactionPath, currentGain += (double)node.getGain(useSquaredErrorForGain), currentCover += (double)node.getWeight(), pathProba, depth, 1.0, treeIndex);
        if (depth < maxDeepening || maxDeepening < 0) {
            FeatureInteractions.collectFeatureInteractions(node.getLeftChild(), new ArrayList<SharedTreeNode>(), 0.0, 0.0, ppl, depth + 1, deepening + 1, featureInteractions, memo, maxInteractionDepth, maxTreeDepth, maxDeepening, treeIndex, useSquaredErrorForGain);
            FeatureInteractions.collectFeatureInteractions(node.getRightChild(), new ArrayList<SharedTreeNode>(), 0.0, 0.0, ppr, depth + 1, deepening + 1, featureInteractions, memo, maxInteractionDepth, maxTreeDepth, maxDeepening, treeIndex, useSquaredErrorForGain);
        }
        String path = FeatureInteraction.interactionPathToStr(interactionPath, true, true);
        FeatureInteraction foundFI = featureInteractions.get(featureInteraction.name);
        if (foundFI == null) {
            featureInteractions.put(featureInteraction.name, featureInteraction);
            memo.add(path);
        } else {
            if (memo.contains(path)) {
                return;
            }
            memo.add(path);
            foundFI.gain += currentGain;
            foundFI.cover += currentCover;
            foundFI.fScore += 1.0;
            foundFI.fScoreWeighted += pathProba;
            foundFI.averageFScoreWeighted = foundFI.fScoreWeighted / foundFI.fScore;
            foundFI.averageGain = foundFI.gain / foundFI.fScore;
            foundFI.expectedGain += currentGain * pathProba;
            foundFI.treeDepth += (double)depth;
            foundFI.averageTreeDepth = foundFI.treeDepth / foundFI.fScore;
            foundFI.treeIndex += (double)treeIndex;
            foundFI.averageTreeIndex = foundFI.treeIndex / foundFI.fScore;
            foundFI.splitValueHistogram.merge(featureInteraction.splitValueHistogram);
        }
        if (interactionPath.size() - 1 == maxInteractionDepth) {
            return;
        }
        foundFI = featureInteractions.get(featureInteraction.name);
        SharedTreeNode leftChild = node.getLeftChild();
        if (leftChild.isLeaf() && deepening == 0) {
            foundFI.sumLeafValuesLeft += (double)leftChild.getLeafValue();
            foundFI.sumLeafCoversLeft += (double)leftChild.getWeight();
            foundFI.hasLeafStatistics = true;
        }
        if ((rightChild = node.getRightChild()).isLeaf() && deepening == 0) {
            foundFI.sumLeafValuesRight += (double)rightChild.getLeafValue();
            foundFI.sumLeafCoversRight += (double)rightChild.getWeight();
            foundFI.hasLeafStatistics = true;
        }
        FeatureInteractions.collectFeatureInteractions(leftChild, new ArrayList<SharedTreeNode>(interactionPath), currentGain, currentGain, ppl, depth + 1, deepening, featureInteractions, memo, maxInteractionDepth, maxTreeDepth, maxDeepening, treeIndex, useSquaredErrorForGain);
        FeatureInteractions.collectFeatureInteractions(node.getRightChild(), new ArrayList<SharedTreeNode>(interactionPath), currentGain, currentGain, ppr, depth + 1, deepening, featureInteractions, memo, maxInteractionDepth, maxTreeDepth, maxDeepening, treeIndex, useSquaredErrorForGain);
    }

    public static TwoDimTable[][] getFeatureInteractionsTable(FeatureInteractions featureInteractions) {
        TwoDimTable[][] table = new TwoDimTable[][]{featureInteractions.getAsTable(), {featureInteractions.getLeafStatisticsTable()}, featureInteractions.getSplitValueHistograms()};
        return table;
    }

    private static /* synthetic */ int lambda$maxDepth$0(Map.Entry entry) {
        return ((FeatureInteraction)entry.getValue()).depth;
    }
}

