/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.mxnet.zoo.cv.classification;

import ai.djl.Application;
import ai.djl.Device;
import ai.djl.MalformedModelException;
import ai.djl.modality.Classifications;
import ai.djl.modality.cv.ImageClassificationTranslator;
import ai.djl.modality.cv.transform.CenterCrop;
import ai.djl.modality.cv.transform.Resize;
import ai.djl.modality.cv.transform.ToTensor;
import ai.djl.modality.cv.util.NDImageUtils;
import ai.djl.repository.MRL;
import ai.djl.repository.Repository;
import ai.djl.repository.zoo.BaseModelLoader;
import ai.djl.repository.zoo.Criteria;
import ai.djl.repository.zoo.ModelNotFoundException;
import ai.djl.repository.zoo.ZooModel;
import ai.djl.translate.Pipeline;
import ai.djl.translate.Transform;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorFactory;
import ai.djl.util.Progress;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class ImageClassificationModelLoader
extends BaseModelLoader<BufferedImage, Classifications> {
    private static final Application APPLICATION = Application.CV.IMAGE_CLASSIFICATION;
    private static final String GROUP_ID = "ai.djl.mxnet";

    public ImageClassificationModelLoader(Repository repository, String artifactId, String version) {
        super(repository, MRL.model((Application)APPLICATION, (String)GROUP_ID, (String)artifactId), version);
        ConcurrentHashMap<Class<Classifications>, FactoryImpl> map = new ConcurrentHashMap<Class<Classifications>, FactoryImpl>();
        map.put(Classifications.class, new FactoryImpl());
        this.factories.put(BufferedImage.class, map);
    }

    public Application getApplication() {
        return APPLICATION;
    }

    public ZooModel<BufferedImage, Classifications> loadModel(Map<String, String> filters, Device device, Progress progress) throws IOException, ModelNotFoundException, MalformedModelException {
        Criteria criteria = Criteria.builder().setTypes(BufferedImage.class, Classifications.class).optFilters(filters).optDevice(device).optProgress(progress).build();
        return this.loadModel(criteria);
    }

    private static final class FactoryImpl
    implements TranslatorFactory<BufferedImage, Classifications> {
        private FactoryImpl() {
        }

        public Translator<BufferedImage, Classifications> newInstance(Map<String, Object> arguments) {
            int width = ((Double)arguments.getOrDefault("width", 224.0)).intValue();
            int height = ((Double)arguments.getOrDefault("height", 224.0)).intValue();
            String flag = (String)arguments.getOrDefault("flag", NDImageUtils.Flag.COLOR.name());
            Pipeline pipeline = new Pipeline();
            pipeline.add((Transform)new CenterCrop()).add((Transform)new Resize(width, height)).add((Transform)new ToTensor());
            return ((ImageClassificationTranslator.Builder)((ImageClassificationTranslator.Builder)ImageClassificationTranslator.builder().optFlag(NDImageUtils.Flag.valueOf((String)flag))).setPipeline(pipeline)).setSynsetArtifactName("synset.txt").build();
        }
    }
}

