/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.basicdataset.cv.classification;

import ai.djl.basicdataset.cv.ImageDataset;
import ai.djl.basicdataset.cv.classification.ImageClassificationDataset;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.ImageFactory;
import ai.djl.repository.MRL;
import ai.djl.repository.Repository;
import ai.djl.translate.TranslateException;
import ai.djl.util.Pair;
import ai.djl.util.PairList;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractImageFolder
extends ImageClassificationDataset {
    private static final Logger logger = LoggerFactory.getLogger(AbstractImageFolder.class);
    private static final Set<String> EXT = new HashSet<String>(Arrays.asList(".jpg", ".jpeg", ".png", ".bmp", ".wbmp", ".gif"));
    protected List<String> synset;
    protected PairList<String, Integer> items;
    protected MRL mrl;
    protected boolean prepared;
    private int maxDepth;
    private Integer imageWidth;
    private Integer imageHeight;

    protected AbstractImageFolder(ImageFolderBuilder<?> builder) {
        super(builder);
        this.maxDepth = builder.maxDepth;
        this.imageWidth = builder.imageWidth;
        this.imageHeight = builder.imageHeight;
        this.synset = new ArrayList<String>();
        this.items = new PairList();
        String path = builder.repository.getBaseUri().toString();
        this.mrl = MRL.undefined((Repository)builder.repository, (String)"ai.djl.localmodelzoo", (String)path);
    }

    @Override
    protected Image getImage(long index) throws IOException {
        ImageFactory imageFactory = ImageFactory.getInstance();
        Pair item = this.items.get(Math.toIntExact(index));
        Path imagePath = this.getImagePath((String)item.getKey());
        return imageFactory.fromFile(imagePath);
    }

    @Override
    protected long getClassNumber(long index) {
        Pair item = this.items.get(Math.toIntExact(index));
        return ((Integer)item.getValue()).intValue();
    }

    protected long availableSize() {
        return this.items.size();
    }

    public List<String> getSynset() throws IOException, TranslateException {
        this.prepare();
        return this.synset;
    }

    protected void listImages(Path root, List<String> classes) {
        int label = 0;
        for (String className : classes) {
            Path classFolder = root.resolve(className);
            if (!Files.isDirectory(classFolder, new LinkOption[0])) continue;
            try (Stream<Path> stream = Files.walk(classFolder, this.maxDepth, new FileVisitOption[0]);){
                int classLabel = label;
                stream.forEach(p -> {
                    if (this.isImage(p.toFile())) {
                        String path = p.toAbsolutePath().toString();
                        this.items.add(new Pair((Object)path, (Object)classLabel));
                    }
                });
            }
            catch (IOException e) {
                logger.warn("Failed to list images", (Throwable)e);
            }
            logger.debug("Loaded {} images in {}, class: {}", new Object[]{this.items.size(), classFolder, label});
            ++label;
        }
    }

    protected abstract Path getImagePath(String var1);

    private boolean isImage(File file) {
        String path = file.getName();
        if (!file.isFile() || file.isHidden() || path.startsWith(".")) {
            return false;
        }
        int extensionIndex = path.lastIndexOf(46);
        if (extensionIndex < 0) {
            return false;
        }
        return EXT.contains(path.substring(extensionIndex).toLowerCase());
    }

    @Override
    public Optional<Integer> getImageWidth() {
        return Optional.ofNullable(this.imageWidth);
    }

    @Override
    public Optional<Integer> getImageHeight() {
        return Optional.ofNullable(this.imageWidth);
    }

    @Override
    public List<String> getClasses() {
        return this.synset;
    }

    public static abstract class ImageFolderBuilder<T extends ImageFolderBuilder<T>>
    extends ImageDataset.BaseBuilder<T> {
        Repository repository;
        int maxDepth = 1;
        Integer imageWidth;
        Integer imageHeight;

        protected ImageFolderBuilder() {
        }

        public T setRepository(Repository repository) {
            this.repository = repository;
            return (T)((Object)((ImageFolderBuilder)this.self()));
        }

        public T setRepositoryPath(String path) {
            this.repository = Repository.newInstance((String)"images", (String)path);
            return (T)((Object)((ImageFolderBuilder)this.self()));
        }

        public T setRepositoryPath(Path path) {
            this.repository = Repository.newInstance((String)"images", (Path)path);
            return (T)((Object)((ImageFolderBuilder)this.self()));
        }

        public T optMaxDepth(int maxDepth) {
            this.maxDepth = maxDepth;
            return (T)((Object)((ImageFolderBuilder)this.self()));
        }

        public T optImageSize(int size) {
            this.imageWidth = size;
            this.imageHeight = size;
            return (T)((Object)((ImageFolderBuilder)this.self()));
        }

        public T optImageWidth(int width) {
            this.imageWidth = width;
            return (T)((Object)((ImageFolderBuilder)this.self()));
        }

        public T optImageHeight(int height) {
            this.imageHeight = height;
            return (T)((Object)((ImageFolderBuilder)this.self()));
        }
    }
}

