/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.http;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import javax.jms.JMSException;
import org.activemq.io.TextWireFormat;
import org.activemq.message.Packet;
import org.activemq.transport.http.HttpTransportChannelSupport;
import org.activemq.util.Callback;
import org.activemq.util.ExceptionTemplate;
import org.activemq.util.JMSExceptionHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpTransportChannel
extends HttpTransportChannelSupport {
    private static final Log log = LogFactory.getLog((Class)HttpTransportChannel.class);
    private URL url;
    private HttpURLConnection sendConnection;
    private HttpURLConnection receiveConnection;

    public HttpTransportChannel(TextWireFormat wireFormat, String remoteUrl) throws MalformedURLException {
        super(wireFormat, remoteUrl);
        this.url = new URL(remoteUrl);
    }

    public void asyncSend(Packet packet) throws JMSException {
        try {
            HttpURLConnection connection = this.getSendConnection();
            String text = this.getTextWireFormat().toString(packet);
            OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream());
            writer.write(text);
            ((Writer)writer).flush();
            int answer = connection.getResponseCode();
            if (answer != 200) {
                throw new JMSException("Failed to post packet: " + packet + " as response was: " + answer);
            }
        }
        catch (IOException e) {
            throw JMSExceptionHelper.newJMSException((String)("Could not post packet: " + packet + " due to: " + e), (Exception)e);
        }
    }

    public void stop() {
        ExceptionTemplate template = new ExceptionTemplate();
        if (this.sendConnection != null) {
            template.run(new Callback(){

                public void execute() throws Throwable {
                    HttpTransportChannel.this.sendConnection.disconnect();
                }
            });
        }
        if (this.receiveConnection != null) {
            template.run(new Callback(){

                public void execute() throws Throwable {
                    HttpTransportChannel.this.receiveConnection.disconnect();
                }
            });
        }
        super.stop();
        Throwable firstException = template.getFirstException();
        if (firstException != null) {
            log.warn((Object)("Failed to shut down cleanly: " + firstException), firstException);
        }
    }

    public boolean isMulticast() {
        return false;
    }

    public void run() {
        log.trace((Object)("HTTP GET consumer thread starting for clientID: " + this.getClientID()));
        String remoteUrl = this.getRemoteUrl();
        while (!this.getClosed().get()) {
            try {
                HttpURLConnection connection = this.getReceiveConnection();
                int answer = connection.getResponseCode();
                if (answer != 200) {
                    if (answer == 408) {
                        log.trace((Object)"GET timed out");
                        continue;
                    }
                    log.warn((Object)("Failed to perform GET on: " + remoteUrl + " as response was: " + answer));
                    continue;
                }
                Packet packet = this.getWireFormat().readPacket((DataInput)new DataInputStream(connection.getInputStream()));
                if (packet == null) {
                    log.warn((Object)("Received null packet from url: " + remoteUrl));
                    continue;
                }
                this.doConsumePacket(packet);
            }
            catch (Exception e) {
                if (!this.getClosed().get()) {
                    log.warn((Object)("Failed to perform GET on: " + remoteUrl + " due to: " + e), (Throwable)e);
                    continue;
                }
                log.trace((Object)("Caught error after closed: " + e), (Throwable)e);
            }
        }
    }

    protected HttpURLConnection createSendConnection() throws IOException {
        HttpURLConnection conn = (HttpURLConnection)this.getRemoteURL().openConnection();
        conn.setDoOutput(true);
        conn.setRequestMethod("POST");
        this.configureConnection(conn);
        conn.connect();
        return conn;
    }

    protected HttpURLConnection createReceiveConnection() throws IOException {
        HttpURLConnection conn = (HttpURLConnection)this.getRemoteURL().openConnection();
        conn.setDoOutput(false);
        conn.setDoInput(true);
        conn.setRequestMethod("GET");
        this.configureConnection(conn);
        conn.connect();
        return conn;
    }

    protected void configureConnection(HttpURLConnection connection) {
        String clientID = this.getClientID();
        if (clientID != null) {
            connection.setRequestProperty("clientID", clientID);
        }
    }

    protected URL getRemoteURL() {
        return this.url;
    }

    protected HttpURLConnection getSendConnection() throws IOException {
        this.setSendConnection(this.createSendConnection());
        return this.sendConnection;
    }

    protected HttpURLConnection getReceiveConnection() throws IOException {
        this.setReceiveConnection(this.createReceiveConnection());
        return this.receiveConnection;
    }

    protected void setSendConnection(HttpURLConnection conn) {
        if (this.sendConnection != null) {
            this.sendConnection.disconnect();
        }
        this.sendConnection = conn;
    }

    protected void setReceiveConnection(HttpURLConnection conn) {
        if (this.receiveConnection != null) {
            this.receiveConnection.disconnect();
        }
        this.receiveConnection = conn;
    }

    public void forceDisconnect() {
        throw new RuntimeException("Not yet Implemented.");
    }
}

