/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xdoclet;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.xdoclet.Config;
import org.xdoclet.JavaSourceProvider;

public class Maven2SourceProvider
implements JavaSourceProvider {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final String encoding;
    private final List compileSourceRoots;
    private final String[] includes;
    private final String[] excludes;

    public Maven2SourceProvider(Config config, List compileSourceRoots) {
        this.encoding = config.getEncoding();
        this.compileSourceRoots = compileSourceRoots;
        this.includes = this.toStringArray(config.getIncludes());
        this.excludes = this.toStringArray(config.getExcludes());
    }

    public Collection getURLs() throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        Iterator it = this.compileSourceRoots.iterator();
        while (it.hasNext()) {
            String baseDir = (String)it.next();
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(baseDir);
            scanner.setFollowSymlinks(true);
            scanner.setExcludes(this.excludes);
            scanner.setIncludes(this.includes);
            scanner.addDefaultExcludes();
            scanner.scan();
            String[] files = scanner.getIncludedFiles();
            for (int i = 0; i < files.length; ++i) {
                File file = new File(baseDir, files[i]);
                urls.add(file.toURL());
            }
        }
        return urls;
    }

    private String[] toStringArray(String commaSeparated) {
        if (commaSeparated == null || commaSeparated.length() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        return commaSeparated.split(",", 0);
    }

    public String getEncoding() {
        return this.encoding;
    }
}

