/*
 * Decompiled with CFR 0.152.
 */
package vip.mate.core.security.config;

import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.security.servlet.UserDetailsServiceAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableResourceServer;
import org.springframework.security.oauth2.config.annotation.web.configuration.ResourceServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configurers.ResourceServerSecurityConfigurer;
import org.springframework.security.oauth2.provider.token.store.redis.RedisTokenStore;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;
import vip.mate.core.security.config.IgnoreUrlPropsConfiguration;
import vip.mate.core.security.handle.MateAccessDeniedHandler;
import vip.mate.core.security.handle.MateAuthenticationEntryPoint;

@Order(value=5)
@EnableResourceServer
@EnableAutoConfiguration(exclude={UserDetailsServiceAutoConfiguration.class})
public class MateResourceServerConfig
extends ResourceServerConfigurerAdapter {
    private final IgnoreUrlPropsConfiguration ignoreUrlPropsConfig;
    private final RedisConnectionFactory redisConnectionFactory;

    @Bean
    public RedisTokenStore redisTokenStore() {
        return new RedisTokenStore(this.redisConnectionFactory);
    }

    public void configure(HttpSecurity http) throws Exception {
        ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry config = ((HttpSecurity.RequestMatcherConfigurer)http.requestMatchers().anyRequest()).and().authorizeRequests();
        this.ignoreUrlPropsConfig.getUrls().forEach(url -> ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)config.antMatchers(new String[]{url})).permitAll());
        this.ignoreUrlPropsConfig.getIgnoreSecurity().forEach(url -> ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)config.antMatchers(new String[]{url})).permitAll());
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)config.anyRequest()).authenticated().and()).csrf().disable();
    }

    public void configure(ResourceServerSecurityConfigurer resources) throws Exception {
        resources.authenticationEntryPoint((AuthenticationEntryPoint)new MateAuthenticationEntryPoint()).accessDeniedHandler((AccessDeniedHandler)new MateAccessDeniedHandler());
    }

    public MateResourceServerConfig(IgnoreUrlPropsConfiguration ignoreUrlPropsConfig, RedisConnectionFactory redisConnectionFactory) {
        this.ignoreUrlPropsConfig = ignoreUrlPropsConfig;
        this.redisConnectionFactory = redisConnectionFactory;
    }
}

