/*
 * Decompiled with CFR 0.152.
 */
package vip.mate.core.security.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

@RefreshScope
@ConfigurationProperties(prefix="mate.security.ignore")
@Component
public class IgnoreUrlPropsConfiguration {
    private static final String[] SECURITY_ENDPOINTS = new String[]{"/auth/**", "/oauth/token", "/login/*", "/actuator/**", "/v2/api-docs", "/doc.html", "/webjars/**", "**/favicon.ico", "/swagger-resources/**"};
    private List<String> urls = new ArrayList<String>();
    private List<String> client = new ArrayList<String>();
    private List<String> ignoreSecurity = new ArrayList<String>();

    @PostConstruct
    public void initIgnoreSecurity() {
        Collections.addAll(this.ignoreSecurity, SECURITY_ENDPOINTS);
    }

    public List<String> getUrls() {
        return this.urls;
    }

    public List<String> getClient() {
        return this.client;
    }

    public List<String> getIgnoreSecurity() {
        return this.ignoreSecurity;
    }

    public void setUrls(List<String> urls) {
        this.urls = urls;
    }

    public void setClient(List<String> client) {
        this.client = client;
    }

    public void setIgnoreSecurity(List<String> ignoreSecurity) {
        this.ignoreSecurity = ignoreSecurity;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IgnoreUrlPropsConfiguration)) {
            return false;
        }
        IgnoreUrlPropsConfiguration other = (IgnoreUrlPropsConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$urls = this.getUrls();
        List<String> other$urls = other.getUrls();
        if (this$urls == null ? other$urls != null : !((Object)this$urls).equals(other$urls)) {
            return false;
        }
        List<String> this$client = this.getClient();
        List<String> other$client = other.getClient();
        if (this$client == null ? other$client != null : !((Object)this$client).equals(other$client)) {
            return false;
        }
        List<String> this$ignoreSecurity = this.getIgnoreSecurity();
        List<String> other$ignoreSecurity = other.getIgnoreSecurity();
        return !(this$ignoreSecurity == null ? other$ignoreSecurity != null : !((Object)this$ignoreSecurity).equals(other$ignoreSecurity));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IgnoreUrlPropsConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $urls = this.getUrls();
        result = result * 59 + ($urls == null ? 43 : ((Object)$urls).hashCode());
        List<String> $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : ((Object)$client).hashCode());
        List<String> $ignoreSecurity = this.getIgnoreSecurity();
        result = result * 59 + ($ignoreSecurity == null ? 43 : ((Object)$ignoreSecurity).hashCode());
        return result;
    }

    public String toString() {
        return "IgnoreUrlPropsConfiguration(urls=" + this.getUrls() + ", client=" + this.getClient() + ", ignoreSecurity=" + this.getIgnoreSecurity() + ")";
    }
}

