/*
 * Decompiled with CFR 0.152.
 */
package vc.inreach.aws.request;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSSessionCredentials;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;

public class AWSSigner {
    private static final char[] BASE16MAP = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final String HMAC_SHA256 = "HmacSHA256";
    private static final String SLASH = "/";
    private static final String X_AMZ_DATE = "x-amz-date";
    private static final String RETURN = "\n";
    private static final String AWS4_HMAC_SHA256 = "AWS4-HMAC-SHA256\n";
    private static final String AWS4_REQUEST = "/aws4_request";
    private static final String AWS4_HMAC_SHA256_CREDENTIAL = "AWS4-HMAC-SHA256 Credential=";
    private static final String SIGNED_HEADERS = ", SignedHeaders=";
    private static final String SIGNATURE = ", Signature=";
    private static final String SHA_256 = "SHA-256";
    private static final String AWS4 = "AWS4";
    private static final String AWS_4_REQUEST = "aws4_request";
    private static final Joiner JOINER = Joiner.on((char)';');
    private static final String CONNECTION = "connection";
    private static final String CLOSE = ":close";
    private static final DateTimeFormatter BASIC_TIME_FORMAT = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.YEAR, 4).appendValue(ChronoField.MONTH_OF_YEAR, 2).appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendLiteral('Z').toFormatter();
    private static final String EMPTY = "";
    private static final String ZERO = "0";
    private static final Joiner AMPERSAND_JOINER = Joiner.on((char)'&');
    private static final String CONTENT_LENGTH = "Content-Length";
    private static final String AUTHORIZATION = "Authorization";
    private static final String SESSION_TOKEN = "x-amz-security-token";
    private static final String DATE = "date";
    private static final Escaper ESCAPER = UrlEscapers.urlPathSegmentEscaper();
    private final AWSCredentialsProvider credentialsProvider;
    private final String region;
    private final String service;
    private final Supplier<LocalDateTime> clock;

    public AWSSigner(AWSCredentialsProvider credentialsProvider, String region, String service, Supplier<LocalDateTime> clock) {
        this.credentialsProvider = credentialsProvider;
        this.region = region;
        this.service = service;
        this.clock = clock;
    }

    public Map<String, Object> getSignedHeaders(String uri, String method, Multimap<String, String> queryParams, Map<String, Object> headers, Optional<byte[]> payload) {
        LocalDateTime now = (LocalDateTime)this.clock.get();
        AWSCredentials credentials = this.credentialsProvider.getCredentials();
        TreeMap<String, Object> result = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        result.putAll(headers);
        if (!result.containsKey(DATE)) {
            result.put(X_AMZ_DATE, now.format(BASIC_TIME_FORMAT));
        }
        if (AWSSessionCredentials.class.isAssignableFrom(credentials.getClass())) {
            result.put(SESSION_TOKEN, ((AWSSessionCredentials)credentials).getSessionToken());
        }
        StringBuilder headersString = new StringBuilder();
        ImmutableList.Builder signedHeaders = ImmutableList.builder();
        for (Map.Entry<String, Object> entry : result.entrySet()) {
            headersString.append(this.headerAsString(entry)).append(RETURN);
            signedHeaders.add((Object)entry.getKey().toLowerCase());
        }
        String signedHeaderKeys = JOINER.join((Iterable)signedHeaders.build());
        String string = method + RETURN + uri + RETURN + this.queryParamsString(queryParams) + RETURN + headersString.toString() + RETURN + signedHeaderKeys + RETURN + this.toBase16(this.hash((byte[])payload.or((Object)EMPTY.getBytes(Charsets.UTF_8))));
        String stringToSign = this.createStringToSign(string, now);
        String signature = this.sign(stringToSign, now, credentials);
        String autorizationHeader = AWS4_HMAC_SHA256_CREDENTIAL + credentials.getAWSAccessKeyId() + SLASH + this.getCredentialScope(now) + SIGNED_HEADERS + signedHeaderKeys + SIGNATURE + signature;
        result.put(AUTHORIZATION, autorizationHeader);
        return ImmutableMap.copyOf(result);
    }

    private String queryParamsString(Multimap<String, String> queryParams) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (Map.Entry param : new TreeMap(queryParams.asMap()).entrySet()) {
            for (String value : (Collection)param.getValue()) {
                result.add((Object)(ESCAPER.escape((String)param.getKey()) + '=' + ESCAPER.escape(value)));
            }
        }
        return AMPERSAND_JOINER.join((Iterable)result.build());
    }

    private String headerAsString(Map.Entry<String, Object> header) {
        if (header.getKey().equalsIgnoreCase(CONNECTION)) {
            return "connection:close";
        }
        if (header.getKey().equalsIgnoreCase(CONTENT_LENGTH) && header.getValue().equals(ZERO)) {
            return header.getKey().toLowerCase() + ':';
        }
        return header.getKey().toLowerCase() + ':' + header.getValue();
    }

    private String sign(String stringToSign, LocalDateTime now, AWSCredentials credentials) {
        return Hex.encodeHexString((byte[])this.hmacSHA256(stringToSign, this.getSignatureKey(now, credentials)));
    }

    private String createStringToSign(String canonicalRequest, LocalDateTime now) {
        return AWS4_HMAC_SHA256 + now.format(BASIC_TIME_FORMAT) + RETURN + this.getCredentialScope(now) + RETURN + this.toBase16(this.hash(canonicalRequest.getBytes(Charsets.UTF_8)));
    }

    private String getCredentialScope(LocalDateTime now) {
        return now.format(DateTimeFormatter.BASIC_ISO_DATE) + SLASH + this.region + SLASH + this.service + AWS4_REQUEST;
    }

    private byte[] hash(byte[] payload) {
        try {
            MessageDigest md = MessageDigest.getInstance(SHA_256);
            md.update(payload);
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private String toBase16(byte[] data) {
        StringBuilder hexBuffer = new StringBuilder(data.length * 2);
        for (byte aData : data) {
            hexBuffer.append(BASE16MAP[aData >> 4 & 0xF]);
            hexBuffer.append(BASE16MAP[aData & 0xF]);
        }
        return hexBuffer.toString();
    }

    private byte[] getSignatureKey(LocalDateTime now, AWSCredentials credentials) {
        byte[] kSecret = (AWS4 + credentials.getAWSSecretKey()).getBytes(Charsets.UTF_8);
        byte[] kDate = this.hmacSHA256(now.format(DateTimeFormatter.BASIC_ISO_DATE), kSecret);
        byte[] kRegion = this.hmacSHA256(this.region, kDate);
        byte[] kService = this.hmacSHA256(this.service, kRegion);
        return this.hmacSHA256(AWS_4_REQUEST, kService);
    }

    private byte[] hmacSHA256(String data, byte[] key) {
        try {
            Mac mac = Mac.getInstance(HMAC_SHA256);
            mac.init(new SecretKeySpec(key, HMAC_SHA256));
            return mac.doFinal(data.getBytes(Charsets.UTF_8));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

