/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.dstl.baleen.uima.utils;

import com.googlecode.concurrenttrees.radix.node.NodeFactory;
import com.googlecode.concurrenttrees.radix.node.concrete.DefaultByteArrayNodeFactory;
import com.googlecode.concurrenttrees.suffix.ConcurrentSuffixTree;
import com.googlecode.concurrenttrees.suffix.SuffixTree;
import java.util.Iterator;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.AnnotationBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.dstl.baleen.exceptions.BaleenException;
import uk.gov.dstl.baleen.types.semantic.Entity;

public class TypeUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(TypeUtils.class);

    private TypeUtils() {
    }

    public static Class<AnnotationBase> getType(String typeName, JCas jCas) {
        return TypeUtils.getType(typeName, jCas.getTypeSystem());
    }

    public static Class<AnnotationBase> getType(String typeName, TypeSystem typeSystem) {
        ConcurrentSuffixTree types = new ConcurrentSuffixTree((NodeFactory)new DefaultByteArrayNodeFactory());
        Iterator itTypes = typeSystem.getTypeIterator();
        while (itTypes.hasNext()) {
            Type t = (Type)itTypes.next();
            try {
                Class<?> unchecked;
                String clazz = t.getName();
                if (clazz.startsWith("uima.")) continue;
                if (clazz.endsWith("[]")) {
                    clazz = clazz.substring(0, clazz.length() - 2);
                }
                if (AnnotationBase.class.isAssignableFrom(unchecked = Class.forName(clazz))) {
                    Class<?> c = unchecked;
                    types.put((CharSequence)t.getName(), c);
                    continue;
                }
                LOGGER.debug("Skipping class {} that doesn't inherit from AnnotationBase");
            }
            catch (ClassNotFoundException e) {
                LOGGER.warn("Unable to load class {} from type system", (Object)t.getName(), (Object)e);
            }
        }
        Class<AnnotationBase> ret = TypeUtils.getClassFromType("." + typeName, (SuffixTree<Class<AnnotationBase>>)types);
        if (ret == null) {
            ret = TypeUtils.getClassFromType(typeName, (SuffixTree<Class<AnnotationBase>>)types);
        }
        if (ret == null) {
            LOGGER.warn("No uniquely matching class found for type {}", (Object)typeName);
        }
        return ret;
    }

    private static Class<AnnotationBase> getClassFromType(String typeName, SuffixTree<Class<AnnotationBase>> types) {
        Iterator itMatchedTypes = types.getKeysEndingWith((CharSequence)typeName).iterator();
        if (!itMatchedTypes.hasNext()) {
            return null;
        }
        Class ret = (Class)types.getValueForExactKey((CharSequence)itMatchedTypes.next());
        if (itMatchedTypes.hasNext()) {
            return null;
        }
        return ret;
    }

    public static Class<? extends Entity> getEntityClass(String typeName, JCas jCas) throws BaleenException {
        Class<AnnotationBase> at = TypeUtils.getType(typeName, jCas);
        if (at == null) {
            throw new BaleenException("Couldn't find type '" + typeName + "'");
        }
        if (!Entity.class.isAssignableFrom(at)) {
            throw new BaleenException("Entity type '" + typeName + "' does not inherit from Entity");
        }
        return at;
    }
}

