/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.dstl.baleen.uima;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.jcas.tcas.DocumentAnnotation;
import uk.gov.dstl.baleen.core.history.BaleenHistory;
import uk.gov.dstl.baleen.core.history.DocumentHistory;
import uk.gov.dstl.baleen.core.history.HistoryEvent;
import uk.gov.dstl.baleen.core.history.HistoryEvents;
import uk.gov.dstl.baleen.core.history.Recordable;
import uk.gov.dstl.baleen.core.history.noop.NoopBaleenHistory;
import uk.gov.dstl.baleen.types.Base;
import uk.gov.dstl.baleen.types.semantic.Entity;
import uk.gov.dstl.baleen.types.semantic.ReferenceTarget;
import uk.gov.dstl.baleen.uima.UimaMonitor;
import uk.gov.dstl.baleen.uima.utils.UimaUtils;

public class UimaSupport {
    private final UimaMonitor monitor;
    private final String referrer;
    private final boolean mergeDistinctEntities;
    private final BaleenHistory history;
    private final String pipelineName;

    public UimaSupport(String pipelineName, Class<?> clazz, BaleenHistory history, UimaMonitor monitor, boolean mergeDistinctEntities) {
        this.pipelineName = pipelineName;
        this.history = history != null ? history : NoopBaleenHistory.getInstance();
        this.referrer = UimaUtils.makePipelineSpecificName(pipelineName, clazz);
        this.monitor = monitor;
        this.mergeDistinctEntities = mergeDistinctEntities;
    }

    public String getPipelineName() {
        return this.pipelineName;
    }

    public void add(Annotation ... annotations) {
        this.add(Arrays.asList(annotations));
    }

    public void add(Collection<? extends Annotation> annotations) {
        for (Annotation annotation : annotations) {
            annotation.addToIndexes();
            this.monitor.entityAdded(annotation.getType().getName());
            if (!(annotation instanceof Entity)) continue;
            Entity entity = (Entity)annotation;
            if (Strings.isNullOrEmpty((String)entity.getValue())) {
                entity.setValue(annotation.getCoveredText());
            }
            if (!(annotation instanceof Recordable)) continue;
            this.addToHistory(annotation.getCAS(), HistoryEvents.createAdded((Recordable)((Recordable)annotation), (String)this.referrer));
        }
    }

    public void remove(Collection<? extends Annotation> annotations) {
        for (Annotation annotation : annotations) {
            if (annotation instanceof Recordable) {
                try {
                    this.addToHistory(annotation.getCAS().getJCas(), HistoryEvents.createAdded((Recordable)((Recordable)annotation), (String)this.referrer));
                }
                catch (CASException e) {
                    this.monitor.error("Unable to add to history on remove", e);
                }
            }
            this.monitor.entityRemoved(annotation.getType().getName());
            annotation.removeFromIndexes();
        }
    }

    public void remove(Annotation ... annotations) {
        this.remove(Arrays.asList(annotations));
    }

    public void mergeWithNew(Annotation newAnnotation, Annotation ... annotations) {
        this.mergeWithNew(newAnnotation, Arrays.asList(annotations));
    }

    public void mergeWithNew(Annotation newAnnotation, Collection<? extends Annotation> annotations) {
        this.add(newAnnotation);
        this.mergeWithExisting(newAnnotation, annotations);
    }

    public void mergeWithExisting(Annotation existingAnnotation, Annotation ... annotations) {
        this.mergeWithExisting(existingAnnotation, Arrays.asList(annotations));
    }

    public void mergeWithExisting(Annotation existingAnnotation, Collection<? extends Annotation> annotations) {
        if (annotations != null && annotations.isEmpty()) {
            return;
        }
        if (!(existingAnnotation instanceof Entity)) {
            this.mergeWithExistingNoCoref(existingAnnotation, annotations);
            return;
        }
        Entity existingEntity = (Entity)existingAnnotation;
        for (Annotation annotation : annotations) {
            if (annotation instanceof Entity) {
                Entity entity = (Entity)annotation;
                ReferenceTarget existingRef = existingEntity.getReferent();
                ReferenceTarget entityRef = entity.getReferent();
                if (this.mergeDistinctEntities || this.isSameTarget(existingRef, entityRef)) {
                    this.addMergeToHistory(existingAnnotation, entity);
                    this.remove(entity);
                    continue;
                }
                this.monitor.info("Not merging objects {} and {} as they have different referents", existingEntity.getInternalId(), entity.getInternalId());
                continue;
            }
            this.mergeWithExistingNoCoref(existingAnnotation, Lists.newArrayList((Object[])new Annotation[]{annotation}));
        }
    }

    public void mergeWithExistingNoCoref(Annotation existingAnnotation, Collection<? extends Annotation> annotations) {
        for (Annotation annotation : annotations) {
            this.addMergeToHistory(existingAnnotation, annotation);
        }
        this.remove(annotations);
    }

    private boolean isSameTarget(ReferenceTarget rt1, ReferenceTarget rt2) {
        return rt1 == rt2 || rt1 != null && rt1.equals((Object)rt2);
    }

    private void addMergeToHistory(Annotation keep, Annotation removed) {
        if (keep instanceof Recordable && removed instanceof Base) {
            Recordable r = (Recordable)keep;
            Base b = (Base)removed;
            try {
                this.addToHistory(keep.getCAS().getJCas(), HistoryEvents.createMerged((Recordable)r, (String)this.referrer, (long)b.getInternalId()));
            }
            catch (CASException e) {
                this.monitor.error("Unable to add merge to history", e);
            }
        }
    }

    public void addToHistory(CAS cas, HistoryEvent event) {
        try {
            this.getDocumentHistory(cas.getJCas()).add(event);
        }
        catch (CASException e) {
            this.monitor.error("Unable to add to history on add", e);
        }
    }

    public void addToHistory(JCas jCas, HistoryEvent event) {
        this.getDocumentHistory(jCas).add(event);
    }

    public DocumentHistory getDocumentHistory(JCas jCas) {
        String documentId = String.valueOf(this.pipelineName) + ":" + this.getDocumentAnnotation(jCas).getHash();
        return this.history.getHistory(documentId);
    }

    public DocumentAnnotation getDocumentAnnotation(JCas jCas) {
        return (DocumentAnnotation)jCas.getDocumentAnnotationFs();
    }
}

