/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.dstl.baleen.uima;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.dstl.baleen.core.metrics.Metrics;
import uk.gov.dstl.baleen.core.metrics.MetricsFactory;
import uk.gov.dstl.baleen.uima.utils.UimaUtils;

public class UimaMonitor {
    private final Logger logger;
    private final Metrics metrics;
    private final Map<String, Timer.Context> timers = new HashMap<String, Timer.Context>();
    private final Map<String, Long> entityAddedCounts = new HashMap<String, Long>();
    private final Map<String, Long> entityRemovedCounts = new HashMap<String, Long>();
    private final String pipelineName;

    public UimaMonitor(String pipelineName, Class<?> clazz) {
        this.pipelineName = pipelineName;
        this.logger = LoggerFactory.getLogger((String)UimaUtils.makePipelineSpecificName(pipelineName, clazz));
        this.metrics = MetricsFactory.getMetrics((String)pipelineName, clazz);
    }

    public String getPipelineName() {
        return this.pipelineName;
    }

    public void startFunction(String functionName) {
        this.logger.debug("Starting function {}", (Object)functionName);
        this.timers.put(functionName, this.metrics.getTimer(functionName).time());
    }

    public void finishFunction(String functionName) {
        this.stopTimer(functionName);
        this.logger.debug("Finishing function {}", (Object)functionName);
    }

    public void startFunctionTrace(String functionName) {
        this.logger.trace("Starting function {}", (Object)functionName);
        this.timers.put(functionName, this.metrics.getTimer(functionName).time());
    }

    public void finishFunctionTrace(String functionName) {
        this.stopTimer(functionName);
        this.logger.trace("Finishing function {}", (Object)functionName);
    }

    public void entityAdded(String type) {
        Long count = this.entityAddedCounts.get(type);
        if (count == null) {
            count = 0L;
        }
        count = count + 1L;
        this.entityAddedCounts.put(type, count);
        this.logger.trace("Entity of type {} added", (Object)type);
    }

    public void entityRemoved(String type) {
        Long count = this.entityRemovedCounts.get(type);
        if (count == null) {
            count = 0L;
        }
        count = count + 1L;
        this.entityRemovedCounts.put(type, count);
        this.logger.trace("Entity of type {} removed", (Object)type);
    }

    public void persistCounts() {
        for (String type : this.entityAddedCounts.keySet()) {
            this.metrics.getCounter(String.valueOf(type) + "-added").inc(this.entityAddedCounts.get(type).longValue());
        }
        this.entityAddedCounts.clear();
        for (String type : this.entityRemovedCounts.keySet()) {
            this.metrics.getCounter(String.valueOf(type) + "-removed").inc(this.entityRemovedCounts.get(type).longValue());
        }
        this.entityRemovedCounts.clear();
    }

    public void trace(String message, Object ... args) {
        this.logger.trace(message, args);
    }

    public void debug(String message, Object ... args) {
        this.logger.debug(message, args);
    }

    public void info(String message, Object ... args) {
        this.logger.info(message, args);
    }

    public void warn(String message, Object ... args) {
        this.logger.warn(message, args);
    }

    public void warn(String message, Throwable e) {
        this.logger.error(message, e);
    }

    public void error(String message, Object ... args) {
        this.logger.error(message, args);
    }

    public void error(String message, Throwable e) {
        this.logger.error(message, e);
    }

    public Counter counter(String name) {
        return this.metrics.getCounter(name);
    }

    public Timer timer(String name) {
        return this.metrics.getTimer(name);
    }

    public Counter histogram(String name) {
        return this.metrics.getCounter(name);
    }

    public Meter meter(String name) {
        return this.metrics.getMeter(name);
    }

    private void stopTimer(String name) {
        if (this.timers.containsKey(name)) {
            this.timers.remove(name).stop();
        }
    }
}

