/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.dstl.baleen.uima;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ComparableSpan
implements Comparable<ComparableSpan> {
    private final int start;
    private final int end;
    private final String value;

    public ComparableSpan(int start, int end) {
        this(start, end, null);
    }

    public ComparableSpan(int start, int end, String value) {
        this.start = start;
        this.end = end;
        this.value = value;
    }

    @Override
    public int compareTo(ComparableSpan s) {
        if (s.start > this.start) {
            return -1;
        }
        if (s.start < this.start) {
            return 1;
        }
        if (s.end > this.end) {
            return -1;
        }
        if (s.end < this.end) {
            return 1;
        }
        if (this.value == null && s.value == null) {
            return 0;
        }
        if (this.value != null && s.value == null) {
            return 1;
        }
        if (this.value == null && s.value != null) {
            return -1;
        }
        return this.value.compareTo(s.value);
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public String getValue() {
        return this.value;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.end;
        result = 31 * result + this.start;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComparableSpan other = (ComparableSpan)obj;
        if (this.end != other.end) {
            return false;
        }
        if (this.start != other.start) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return String.format("%d:%d[%s]", this.start, this.end, this.value);
    }

    public static List<ComparableSpan> buildSpans(String text, Pattern pattern) {
        Matcher m = pattern.matcher(text);
        LinkedList<ComparableSpan> spans = new LinkedList<ComparableSpan>();
        while (m.find()) {
            ComparableSpan cs = new ComparableSpan(m.start(), m.end(), m.group());
            spans.add(cs);
        }
        return spans;
    }
}

