/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.dstl.baleen.uima;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import org.apache.uima.UimaContext;
import org.apache.uima.fit.descriptor.ExternalResource;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.jcas.tcas.DocumentAnnotation;
import org.apache.uima.resource.ResourceInitializationException;
import uk.gov.dstl.baleen.core.history.BaleenHistory;
import uk.gov.dstl.baleen.types.metadata.Metadata;
import uk.gov.dstl.baleen.uima.IContentExtractor;
import uk.gov.dstl.baleen.uima.UimaMonitor;
import uk.gov.dstl.baleen.uima.UimaSupport;
import uk.gov.dstl.baleen.uima.utils.UimaUtils;

public abstract class BaleenContentExtractor
implements IContentExtractor {
    private UimaMonitor monitor;
    private UimaSupport support;
    public static final String KEY_HISTORY = "__baleenHistory";
    @ExternalResource(key="__baleenHistory", mandatory=false)
    BaleenHistory history;

    @Override
    public final void initialize(UimaContext context, Map<String, Object> params) throws ResourceInitializationException {
        String pipelineName = UimaUtils.getPipelineName(context);
        this.monitor = this.createMonitor(pipelineName);
        this.support = this.createSupport(pipelineName, context);
        this.monitor.startFunction("initialize");
        this.doInitialize(context, params);
        this.monitor.finishFunction("initialize");
    }

    protected UimaSupport createSupport(String pipelineName, UimaContext context) {
        return new UimaSupport(pipelineName, this.getClass(), this.history, this.monitor, UimaUtils.isMergeDistinctEntities(context));
    }

    protected UimaMonitor createMonitor(String pipelineName) {
        return new UimaMonitor(pipelineName, this.getClass());
    }

    public abstract void doInitialize(UimaContext var1, Map<String, Object> var2) throws ResourceInitializationException;

    @Override
    public final void processStream(InputStream stream, String source, JCas jCas) throws IOException {
        this.monitor.startFunction("process");
        this.doProcessStream(stream, source, jCas);
        this.monitor.finishFunction("process");
        this.monitor.persistCounts();
    }

    protected abstract void doProcessStream(InputStream var1, String var2, JCas var3) throws IOException;

    @Override
    public final void destroy() {
        this.monitor.startFunction("destroy");
        this.doDestroy();
        this.monitor.finishFunction("destroy");
    }

    protected abstract void doDestroy();

    protected UimaMonitor getMonitor() {
        return this.monitor;
    }

    protected UimaSupport getSupport() {
        return this.support;
    }

    protected DocumentAnnotation getDocumentAnnotation(JCas jCas) {
        return this.getSupport().getDocumentAnnotation(jCas);
    }

    protected void addToJCasIndex(Annotation ... annotations) {
        this.getSupport().add(annotations);
    }

    protected void addToJCasIndex(Collection<? extends Annotation> annotations) {
        this.getSupport().add(annotations);
    }

    protected Metadata addMetadata(JCas jCas, String name, String value) {
        if (!Strings.isNullOrEmpty((String)name) && !Strings.isNullOrEmpty((String)value)) {
            Metadata md = new Metadata(jCas);
            md.setKey(name);
            md.setValue(value);
            this.addToJCasIndex(md);
            return md;
        }
        return null;
    }
}

