/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.dstl.baleen.uima;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.uima.UimaContext;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.fit.component.JCasCollectionReader_ImplBase;
import org.apache.uima.fit.descriptor.ExternalResource;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Progress;
import uk.gov.dstl.baleen.core.history.BaleenHistory;
import uk.gov.dstl.baleen.core.metrics.MetricsFactory;
import uk.gov.dstl.baleen.exceptions.InvalidParameterException;
import uk.gov.dstl.baleen.uima.IContentExtractor;
import uk.gov.dstl.baleen.uima.UimaMonitor;
import uk.gov.dstl.baleen.uima.UimaSupport;
import uk.gov.dstl.baleen.uima.utils.UimaUtils;

public abstract class BaleenCollectionReader
extends JCasCollectionReader_ImplBase {
    private UimaMonitor monitor;
    private boolean shuttingDown = false;
    private int sleepDelay = 1000;
    private UimaSupport support;
    public static final String KEY_HISTORY = "__baleenHistory";
    @ExternalResource(key="__baleenHistory", mandatory=false)
    BaleenHistory history;

    public final void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        String pipelineName = UimaUtils.getPipelineName(context);
        this.monitor = new UimaMonitor(pipelineName, ((Object)((Object)this)).getClass());
        this.support = new UimaSupport(pipelineName, ((Object)((Object)this)).getClass(), this.history, this.monitor, UimaUtils.isMergeDistinctEntities(context));
        this.monitor.startFunction("initialize");
        this.doInitialize(context);
        this.monitor.finishFunction("initialize");
    }

    protected abstract void doInitialize(UimaContext var1) throws ResourceInitializationException;

    public final void getNext(JCas jCas) throws IOException, CollectionException {
        this.monitor.startFunction("getNext");
        MetricsFactory.getInstance().getPipelineMetrics(this.monitor.getPipelineName()).startDocumentProcess();
        this.doGetNext(jCas);
        this.monitor.finishFunction("getNext");
        this.monitor.persistCounts();
    }

    protected abstract void doGetNext(JCas var1) throws IOException, CollectionException;

    public final void close() throws IOException {
        this.monitor.startFunction("close");
        this.shutdown();
        this.doClose();
        this.monitor.finishFunction("close");
    }

    protected abstract void doClose() throws IOException;

    public final Progress[] getProgress() {
        this.monitor.startFunction("getProgress");
        Progress[] ret = this.doGetProgress();
        this.monitor.finishFunction("getProgress");
        return ret;
    }

    public void destroy() {
        super.destroy();
        try {
            this.close();
        }
        catch (IOException e) {
            this.getMonitor().warn("Close on destroy", e);
        }
    }

    public Progress[] doGetProgress() {
        return new Progress[0];
    }

    public final boolean hasNext() throws IOException, CollectionException {
        while (!this.shuttingDown) {
            this.monitor.startFunctionTrace("hasNext");
            boolean next = this.doHasNext();
            this.monitor.finishFunctionTrace("hasNext");
            if (next) {
                return true;
            }
            try {
                Thread.sleep(this.sleepDelay);
            }
            catch (InterruptedException e) {
                this.shutdown();
            }
        }
        return false;
    }

    public abstract boolean doHasNext() throws IOException, CollectionException;

    public void shutdown() {
        this.shuttingDown = true;
    }

    public boolean isShuttingDown() {
        return this.shuttingDown;
    }

    public int getSleepDelay() {
        return this.sleepDelay;
    }

    public void setSleepDelay(int sleepDelay) {
        this.sleepDelay = sleepDelay;
    }

    public static IContentExtractor getContentExtractor(String className) throws InvalidParameterException {
        IContentExtractor clazz;
        try {
            clazz = (IContentExtractor)Class.forName("uk.gov.dstl.baleen.contentextractors." + className).newInstance();
        }
        catch (Exception e1) {
            try {
                clazz = (IContentExtractor)Class.forName(className).newInstance();
            }
            catch (Exception e2) {
                throw new InvalidParameterException("Could not find or instantiate content extractor " + className, (Throwable)e2);
            }
        }
        return clazz;
    }

    protected UimaMonitor getMonitor() {
        return this.monitor;
    }

    protected UimaSupport getSupport() {
        return this.support;
    }

    protected static Map<String, Object> getConfigParameters(UimaContext context) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        String[] stringArray = context.getConfigParameterNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            ret.put(name, context.getConfigParameterValue(name));
            ++n2;
        }
        return ret;
    }
}

