/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.dstl.baleen.uima;

import java.util.Collection;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ExternalResource;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.jcas.tcas.DocumentAnnotation;
import org.apache.uima.resource.ResourceInitializationException;
import uk.gov.dstl.baleen.core.history.BaleenHistory;
import uk.gov.dstl.baleen.uima.UimaMonitor;
import uk.gov.dstl.baleen.uima.UimaSupport;
import uk.gov.dstl.baleen.uima.utils.UimaUtils;

public abstract class BaleenAnnotator
extends JCasAnnotator_ImplBase {
    private UimaMonitor monitor;
    private UimaSupport support;
    public static final String KEY_HISTORY = "__baleenHistory";
    @ExternalResource(key="__baleenHistory", mandatory=false)
    private BaleenHistory history;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        String pipelineName = UimaUtils.getPipelineName(context);
        this.monitor = this.createMonitor(pipelineName);
        this.support = this.createSupport(pipelineName, context);
        this.monitor.startFunction("initialize");
        this.doInitialize(context);
        this.monitor.finishFunction("initialize");
    }

    protected UimaSupport createSupport(String pipelineName, UimaContext context) {
        return new UimaSupport(pipelineName, ((Object)((Object)this)).getClass(), this.history, this.monitor, UimaUtils.isMergeDistinctEntities(context));
    }

    protected UimaMonitor createMonitor(String pipelineName) {
        return new UimaMonitor(pipelineName, ((Object)((Object)this)).getClass());
    }

    public void doInitialize(UimaContext aContext) throws ResourceInitializationException {
    }

    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        this.monitor.startFunction("process");
        this.doProcess(aJCas);
        this.monitor.finishFunction("process");
        this.monitor.persistCounts();
    }

    protected abstract void doProcess(JCas var1) throws AnalysisEngineProcessException;

    public void destroy() {
        this.monitor.startFunction("destroy");
        this.doDestroy();
        this.monitor.finishFunction("destroy");
    }

    protected void doDestroy() {
    }

    protected UimaMonitor getMonitor() {
        return this.monitor;
    }

    protected UimaSupport getSupport() {
        return this.support;
    }

    protected void addToJCasIndex(Annotation ... annotations) {
        this.getSupport().add(annotations);
    }

    protected void addToJCasIndex(Collection<? extends Annotation> annotations) {
        this.getSupport().add(annotations);
    }

    protected void removeFromJCasIndex(Collection<? extends Annotation> annotations) {
        this.getSupport().remove(annotations);
    }

    protected void removeFromJCasIndex(Annotation ... annotations) {
        this.getSupport().remove(annotations);
    }

    protected void mergeWithNew(Annotation newAnnotation, Annotation ... annotations) {
        this.getSupport().mergeWithNew(newAnnotation, annotations);
    }

    protected void mergeWithNew(Annotation newAnnotation, Collection<? extends Annotation> annotations) {
        this.getSupport().mergeWithNew(newAnnotation, annotations);
    }

    protected void mergeWithExisting(Annotation existingAnnotation, Annotation ... annotations) {
        this.getSupport().mergeWithExisting(existingAnnotation, annotations);
    }

    protected void mergeWithExisting(Annotation existingAnnotation, Collection<? extends Annotation> annotations) {
        this.getSupport().mergeWithExisting(existingAnnotation, annotations);
    }

    protected DocumentAnnotation getDocumentAnnotation(JCas jCas) {
        return this.getSupport().getDocumentAnnotation(jCas);
    }
}

