/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.dstl.baleen.types.language;

import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JCasRegistry;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.cas.TOP_Type;
import uk.gov.dstl.baleen.types.Base;
import uk.gov.dstl.baleen.types.language.WordLemma;
import uk.gov.dstl.baleen.types.language.WordToken_Type;

public class WordToken
extends Base {
    public static final int typeIndexID;
    public static final int type;

    static {
        type = typeIndexID = JCasRegistry.register(WordToken.class);
    }

    @Override
    public int getTypeIndexID() {
        return typeIndexID;
    }

    protected WordToken() {
    }

    public WordToken(int addr, TOP_Type type) {
        super(addr, type);
        this.readObject();
    }

    public WordToken(JCas jcas) {
        super(jcas);
        this.readObject();
    }

    public WordToken(JCas jcas, int begin, int end) {
        super(jcas);
        this.setBegin(begin);
        this.setEnd(end);
        this.readObject();
    }

    private void readObject() {
    }

    public String getPartOfSpeech() {
        if (WordToken_Type.featOkTst && ((WordToken_Type)this.jcasType).casFeat_partOfSpeech == null) {
            this.jcasType.jcas.throwFeatMissing("partOfSpeech", "uk.gov.dstl.baleen.types.language.WordToken");
        }
        return this.jcasType.ll_cas.ll_getStringValue(this.addr, ((WordToken_Type)this.jcasType).casFeatCode_partOfSpeech);
    }

    public void setPartOfSpeech(String v) {
        if (WordToken_Type.featOkTst && ((WordToken_Type)this.jcasType).casFeat_partOfSpeech == null) {
            this.jcasType.jcas.throwFeatMissing("partOfSpeech", "uk.gov.dstl.baleen.types.language.WordToken");
        }
        this.jcasType.ll_cas.ll_setStringValue(this.addr, ((WordToken_Type)this.jcasType).casFeatCode_partOfSpeech, v);
    }

    public int getSentenceOrder() {
        if (WordToken_Type.featOkTst && ((WordToken_Type)this.jcasType).casFeat_sentenceOrder == null) {
            this.jcasType.jcas.throwFeatMissing("sentenceOrder", "uk.gov.dstl.baleen.types.language.WordToken");
        }
        return this.jcasType.ll_cas.ll_getIntValue(this.addr, ((WordToken_Type)this.jcasType).casFeatCode_sentenceOrder);
    }

    public void setSentenceOrder(int v) {
        if (WordToken_Type.featOkTst && ((WordToken_Type)this.jcasType).casFeat_sentenceOrder == null) {
            this.jcasType.jcas.throwFeatMissing("sentenceOrder", "uk.gov.dstl.baleen.types.language.WordToken");
        }
        this.jcasType.ll_cas.ll_setIntValue(this.addr, ((WordToken_Type)this.jcasType).casFeatCode_sentenceOrder, v);
    }

    public FSArray getLemmas() {
        if (WordToken_Type.featOkTst && ((WordToken_Type)this.jcasType).casFeat_lemmas == null) {
            this.jcasType.jcas.throwFeatMissing("lemmas", "uk.gov.dstl.baleen.types.language.WordToken");
        }
        return (FSArray)this.jcasType.ll_cas.ll_getFSForRef(this.jcasType.ll_cas.ll_getRefValue(this.addr, ((WordToken_Type)this.jcasType).casFeatCode_lemmas));
    }

    public void setLemmas(FSArray v) {
        if (WordToken_Type.featOkTst && ((WordToken_Type)this.jcasType).casFeat_lemmas == null) {
            this.jcasType.jcas.throwFeatMissing("lemmas", "uk.gov.dstl.baleen.types.language.WordToken");
        }
        this.jcasType.ll_cas.ll_setRefValue(this.addr, ((WordToken_Type)this.jcasType).casFeatCode_lemmas, this.jcasType.ll_cas.ll_getFSRef((FeatureStructure)v));
    }

    public WordLemma getLemmas(int i) {
        if (WordToken_Type.featOkTst && ((WordToken_Type)this.jcasType).casFeat_lemmas == null) {
            this.jcasType.jcas.throwFeatMissing("lemmas", "uk.gov.dstl.baleen.types.language.WordToken");
        }
        this.jcasType.jcas.checkArrayBounds(this.jcasType.ll_cas.ll_getRefValue(this.addr, ((WordToken_Type)this.jcasType).casFeatCode_lemmas), i);
        return (WordLemma)this.jcasType.ll_cas.ll_getFSForRef(this.jcasType.ll_cas.ll_getRefArrayValue(this.jcasType.ll_cas.ll_getRefValue(this.addr, ((WordToken_Type)this.jcasType).casFeatCode_lemmas), i));
    }

    public void setLemmas(int i, WordLemma v) {
        if (WordToken_Type.featOkTst && ((WordToken_Type)this.jcasType).casFeat_lemmas == null) {
            this.jcasType.jcas.throwFeatMissing("lemmas", "uk.gov.dstl.baleen.types.language.WordToken");
        }
        this.jcasType.jcas.checkArrayBounds(this.jcasType.ll_cas.ll_getRefValue(this.addr, ((WordToken_Type)this.jcasType).casFeatCode_lemmas), i);
        this.jcasType.ll_cas.ll_setRefArrayValue(this.jcasType.ll_cas.ll_getRefValue(this.addr, ((WordToken_Type)this.jcasType).casFeatCode_lemmas), i, this.jcasType.ll_cas.ll_getFSRef((FeatureStructure)v));
    }
}

