/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.dstl.baleen.types;

import com.google.common.base.Strings;
import java.util.ArrayList;
import org.apache.uima.cas.Feature;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JCasRegistry;
import org.apache.uima.jcas.cas.TOP_Type;
import org.apache.uima.jcas.tcas.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.dstl.baleen.core.utils.IdentityUtils;
import uk.gov.dstl.baleen.exceptions.BaleenException;
import uk.gov.dstl.baleen.types.BaleenAnnotation_Type;

public class BaleenAnnotation
extends Annotation {
    public static final int typeIndexID;
    public static final int type;
    private static final Logger LOGGER;

    static {
        type = typeIndexID = JCasRegistry.register(BaleenAnnotation.class);
        LOGGER = LoggerFactory.getLogger(BaleenAnnotation.class);
    }

    public int getTypeIndexID() {
        return typeIndexID;
    }

    protected BaleenAnnotation() {
    }

    public BaleenAnnotation(int addr, TOP_Type type) {
        super(addr, type);
        this.readObject();
    }

    public BaleenAnnotation(JCas jcas) {
        super(jcas);
        this.readObject();
    }

    public BaleenAnnotation(JCas jcas, int begin, int end) {
        super(jcas);
        this.setBegin(begin);
        this.setEnd(end);
        this.readObject();
    }

    private void readObject() {
        if (this.getInternalId() == 0L) {
            IdentityUtils iu = IdentityUtils.getInstance();
            this.setInternalId(iu.getNewId());
        }
    }

    public long getInternalId() {
        if (BaleenAnnotation_Type.featOkTst && ((BaleenAnnotation_Type)this.jcasType).casFeat_internalId == null) {
            this.jcasType.jcas.throwFeatMissing("internalId", "uk.gov.dstl.baleen.types.BaleenAnnotation");
        }
        return this.jcasType.ll_cas.ll_getLongValue(this.addr, ((BaleenAnnotation_Type)this.jcasType).casFeatCode_internalId);
    }

    public void setInternalId(long v) {
        if (this.getInternalId() != 0L) {
            LOGGER.warn("Changing the internal ID is not recommended as it may break some aspects of Baleen. Internal ID has been changed from {} to {}.", (Object)this.getInternalId(), (Object)v);
        }
        if (BaleenAnnotation_Type.featOkTst && ((BaleenAnnotation_Type)this.jcasType).casFeat_internalId == null) {
            this.jcasType.jcas.throwFeatMissing("internalId", "uk.gov.dstl.baleen.types.BaleenAnnotation");
        }
        this.jcasType.ll_cas.ll_setLongValue(this.addr, ((BaleenAnnotation_Type)this.jcasType).casFeatCode_internalId, v);
    }

    public String getExternalId() {
        ArrayList<String> properties = new ArrayList<String>();
        properties.add(this.getType().getName());
        properties.add(this.getCoveredText());
        for (Feature f : this.getType().getFeatures()) {
            if (!f.getRange().isPrimitive() || "uk.gov.dstl.baleen.types.BaleenAnnotation:internalId".equals(f.getName())) continue;
            try {
                String s = this.getFeatureValueAsString(f);
                if (Strings.isNullOrEmpty((String)s)) continue;
                properties.add(s);
            }
            catch (Exception e) {
                LOGGER.debug("Couldn't read feature value for feature {} - property will be ignored in hash generation", (Object)f.getName(), (Object)e);
            }
        }
        try {
            return IdentityUtils.hashStrings((String[])properties.toArray(new String[0]));
        }
        catch (BaleenException e) {
            LOGGER.error("Unable to generate external ID for entity with internal ID {}", (Object)this.getInternalId(), (Object)e);
            return null;
        }
    }
}

