/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.common.ftp.one;

import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.jfunc.common.ftp.ConnectBean;
import top.jfunc.common.ftp.DownloadBean;
import top.jfunc.common.ftp.UploadBean;
import top.jfunc.common.utils.IoUtil;

public class FtpUtil {
    private static final Logger logger = LoggerFactory.getLogger(FtpUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createDir(ConnectBean connectBean, String remotePath) throws IOException {
        FTPClient ftpClient = FtpUtil.connect(connectBean);
        try {
            String directory;
            String string = directory = remotePath.endsWith("/") ? remotePath : remotePath + "/";
            if ("/".equalsIgnoreCase(directory) || FtpUtil.changeWorkingDirToRemotePath(ftpClient, directory)) {
                boolean bl = true;
                return bl;
            }
            int start = directory.startsWith("/") ? 1 : 0;
            int end = directory.indexOf("/", start);
            String path = "";
            do {
                String subDirectory = new String(remotePath.substring(start, end).getBytes("GBK"), "iso-8859-1");
                if (!FtpUtil.existDir(ftpClient, path = path + "/" + subDirectory)) {
                    if (ftpClient.makeDirectory(subDirectory)) {
                        FtpUtil.changeWorkingDirToRemotePath(ftpClient, subDirectory);
                        continue;
                    }
                    logger.error("\u521b\u5efa\u76ee\u5f55[" + subDirectory + "]\u5931\u8d25");
                    FtpUtil.changeWorkingDirToRemotePath(ftpClient, subDirectory);
                    continue;
                }
                FtpUtil.changeWorkingDirToRemotePath(ftpClient, subDirectory);
            } while ((end = directory.indexOf("/", start = end + 1)) > start);
        }
        finally {
            FtpUtil.close(ftpClient);
        }
        return true;
    }

    public static void upload(ConnectBean connectBean, UploadBean uploadBean) throws IOException {
        FtpUtil.upload(connectBean, uploadBean.getRemotePath(), uploadBean.getDestFileName(), uploadBean.getInputSteam());
    }

    public static void upload(ConnectBean connectBean, String remotePath, String destFileName, InputStream inputSteam) throws IOException {
        FtpUtil.upload(connectBean.getHost(), connectBean.getPort(), connectBean.getEncoding(), connectBean.getUsername(), connectBean.getPassword(), remotePath, destFileName, inputSteam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void upload(String host, int port, String encoding, String username, String password, String remotePath, String destFileName, InputStream inputSteam) throws IOException {
        FTPClient ftpClient = FtpUtil.connect(host, port, encoding, username, password);
        try {
            FtpUtil.checkStatus(ftpClient);
            FtpUtil.changeWorkingDirToRemotePath(ftpClient, remotePath);
            ftpClient.setFileType(2);
            ftpClient.storeFile(destFileName, inputSteam);
            FtpUtil.printReplay(ftpClient);
        }
        finally {
            IoUtil.close((Closeable)inputSteam);
            FtpUtil.close(ftpClient);
        }
    }

    public static void download(ConnectBean connectBean, DownloadBean downloadBean) throws IOException {
        FtpUtil.download(connectBean.getHost(), connectBean.getPort(), connectBean.getEncoding(), connectBean.getUsername(), connectBean.getPassword(), downloadBean.getRemotePath(), downloadBean.getRemoteFileName(), downloadBean.getLocalFileName());
    }

    public static void download(ConnectBean connectBean, String remotePath, String remoteFileName, String localFileName) throws IOException {
        FtpUtil.download(connectBean.getHost(), connectBean.getPort(), connectBean.getEncoding(), connectBean.getUsername(), connectBean.getPassword(), remotePath, remoteFileName, localFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void download(String host, int port, String encoding, String username, String password, String remotePath, String remoteFileName, String localFileName) throws IOException {
        FTPClient ftpClient = FtpUtil.connect(host, port, encoding, username, password);
        try {
            FtpUtil.isExist(ftpClient, remotePath, remoteFileName);
            FtpUtil.checkStatus(ftpClient);
            FtpUtil.changeWorkingDirToRemotePath(ftpClient, remotePath);
            FtpUtil.downloadRemoteFile2LocalFile(ftpClient, remoteFileName, localFileName);
        }
        finally {
            FtpUtil.close(ftpClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void downloadRemoteFile2LocalFile(FTPClient ftpClient, String remoteFileName, String localFileName) throws IOException {
        InputStream is = null;
        FileOutputStream os = null;
        try {
            is = ftpClient.retrieveFileStream(remoteFileName);
            os = new FileOutputStream(localFileName);
            byte[] buffer = new byte[4096];
            int read = 0;
            long downloadSize = 0L;
            while ((read = is.read(buffer)) != -1) {
                ((OutputStream)os).write(buffer, 0, read);
                FtpUtil.printDownloadSize(downloadSize += (long)read);
            }
            os.flush();
            logger.info("downloadSize:" + downloadSize);
        }
        catch (Throwable throwable) {
            IoUtil.close((Closeable)is);
            IoUtil.close(os);
            try {
                ftpClient.completePendingCommand();
                FtpUtil.printReplay(ftpClient);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            throw throwable;
        }
        IoUtil.close((Closeable)is);
        IoUtil.close((Closeable)os);
        try {
            ftpClient.completePendingCommand();
            FtpUtil.printReplay(ftpClient);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private static void printDownloadSize(long downloadSize) {
        String suffix = "KB";
        float downloaded = (float)downloadSize / 1024.0f;
        if (downloaded > 1024.0f) {
            downloaded /= 1024.0f;
            suffix = "MB";
        }
        logger.debug(String.format("download size:%.2f %s", Float.valueOf(downloaded), suffix));
    }

    private static boolean changeWorkingDirToRemotePath(FTPClient ftpClient, String remotePath) throws IOException {
        boolean flag = ftpClient.changeWorkingDirectory(remotePath);
        FtpUtil.printReplay(ftpClient);
        return flag;
    }

    private static void printReplay(FTPClient ftpClient) {
        logger.debug("Code: " + ftpClient.getReplyCode() + ":replyString: " + ftpClient.getReplyString());
    }

    private static boolean existDir(FTPClient ftpClient, String path) throws IOException {
        boolean flag = false;
        FTPFile[] ftpFileArr = ftpClient.listFiles(path);
        if (ftpFileArr.length > 0) {
            flag = true;
        }
        return flag;
    }

    private static boolean isExist(FTPClient ftpClient, String remotePath, String fileName) throws IOException {
        FtpUtil.checkStatus(ftpClient);
        FtpUtil.changeWorkingDirToRemotePath(ftpClient, remotePath);
        FtpUtil.printReplay(ftpClient);
        FTPFile[] ftpFiles = ftpClient.listFiles(remotePath);
        FtpUtil.printReplay(ftpClient);
        if (ftpFiles.length == 0) {
            throw new IOException("Error, no file in remote directory.");
        }
        for (FTPFile file : ftpFiles) {
            if (file.isDirectory() || !file.getName().equals(fileName)) continue;
            return true;
        }
        return false;
    }

    private static FTPClient loginFtp(String host, int port, String encoding, String username, String password) throws IOException {
        FTPClient ftpClient = new FTPClient();
        ftpClient.setDefaultPort(port);
        ftpClient.setControlEncoding(encoding);
        ftpClient.connect(host);
        ftpClient.enterLocalPassiveMode();
        if (ftpClient.login(username, password)) {
            FtpUtil.printReplay(ftpClient);
            logger.info(" login success !");
            if (FTPReply.isPositiveCompletion((int)ftpClient.getReplyCode())) {
                logger.info(" connect success !");
                return ftpClient;
            }
        }
        throw new IOException("login FTP server error, please check it!");
    }

    public static FTPClient loginFtp(ConnectBean bean) throws IOException {
        return FtpUtil.loginFtp(bean.getHost(), bean.getPort(), bean.getEncoding(), bean.getUsername(), bean.getPassword());
    }

    private static FTPClient connect(String host, int port, String encoding, String username, String password) throws IOException {
        FTPClient ftpClient = FtpUtil.loginFtp(host, port, encoding, username, password);
        return ftpClient;
    }

    private static FTPClient connect(ConnectBean bean) throws IOException {
        FTPClient ftpClient = FtpUtil.loginFtp(bean.getHost(), bean.getPort(), bean.getEncoding(), bean.getUsername(), bean.getPassword());
        return ftpClient;
    }

    private static void close(FTPClient ftpClient) {
        if (null != ftpClient && ftpClient.isConnected()) {
            try {
                logger.info("ftpClient logout");
                ftpClient.logout();
                ftpClient = null;
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static void checkStatus(FTPClient ftpClient) throws IOException {
        if (ftpClient == null || !ftpClient.isConnected()) {
            throw new IOException("FTP\u672a\u8fde\u63a5\uff0c\u8bf7\u8fde\u63a5\u540e\u518d\u6267\u884c\u64cd\u4f5c");
        }
    }
}

