/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.common.ftp.another;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.jfunc.common.ftp.ConnectBean;
import top.jfunc.common.ftp.another.DownloadStatus;
import top.jfunc.common.ftp.another.UploadStatus;

class FtpCore {
    private FTPClient ftpClient;
    private static final Logger log = LoggerFactory.getLogger(FtpCore.class);

    FtpCore() {
    }

    public boolean connectServer(ConnectBean ftpConfig) throws IOException {
        String server = ftpConfig.getHost();
        int port = ftpConfig.getPort();
        String username = ftpConfig.getUsername();
        String password = ftpConfig.getPassword();
        String path = ftpConfig.getPath();
        return this.connectServer(server, port, ftpConfig.getEncoding(), username, password, path);
    }

    boolean connectServer(String server, int port, String encoding, String username, String password, String path) throws IOException {
        this.ftpClient = new FTPClient();
        this.ftpClient.connect(server, port);
        this.ftpClient.setControlEncoding(encoding);
        log.info("Connected to " + server + ".");
        log.info("FTP server reply code:" + this.ftpClient.getReplyCode());
        if (FTPReply.isPositiveCompletion((int)this.ftpClient.getReplyCode()) && this.ftpClient.login(username, password)) {
            if (null != path && path.length() != 0) {
                this.ftpClient.changeWorkingDirectory(path);
            }
            return true;
        }
        this.disconnect();
        return false;
    }

    void disconnect() throws IOException {
        if (this.ftpClient.isConnected()) {
            this.ftpClient.disconnect();
        }
    }

    DownloadStatus download(String remote, String local) throws IOException {
        DownloadStatus result;
        this.ftpClient.enterLocalPassiveMode();
        this.ftpClient.setFileType(2);
        FTPFile[] files = this.ftpClient.listFiles(new String(remote.getBytes("UTF-8"), "iso-8859-1"));
        if (files.length != 1) {
            log.error("\u8fdc\u7a0b\u6587\u4ef6\u4e0d\u5b58\u5728");
            return DownloadStatus.RemoteFileNotExist;
        }
        long lRemoteSize = files[0].getSize();
        File f = new File(local);
        if (f.exists()) {
            int c;
            long localSize = f.length();
            if (localSize >= lRemoteSize) {
                log.error("\u672c\u5730\u6587\u4ef6\u5927\u4e8e\u8fdc\u7a0b\u6587\u4ef6\uff0c\u4e0b\u8f7d\u4e2d\u6b62");
                return DownloadStatus.LocalFileBiggerThanRemoteFile;
            }
            FileOutputStream out = new FileOutputStream(f, true);
            this.ftpClient.setRestartOffset(localSize);
            InputStream in = this.ftpClient.retrieveFileStream(new String(remote.getBytes("UTF-8"), "iso-8859-1"));
            byte[] bytes = new byte[1024];
            long step = lRemoteSize / 100L;
            step = step == 0L ? 1L : step;
            long process = localSize / step;
            while ((c = in.read(bytes)) != -1) {
                out.write(bytes, 0, c);
                long nowProcess = (localSize += (long)c) / step;
                if (nowProcess <= process || (process = nowProcess) % 10L != 0L) continue;
                log.debug("\u4e0b\u8f7d\u8fdb\u5ea6\uff1a" + process);
            }
            in.close();
            out.close();
            boolean isDo = this.ftpClient.completePendingCommand();
            result = isDo ? DownloadStatus.DownloadFromBreakSuccess : DownloadStatus.DownloadFromBreakFailed;
        } else {
            int c;
            FileOutputStream out = new FileOutputStream(f);
            InputStream in = this.ftpClient.retrieveFileStream(new String(remote.getBytes("UTF-8"), "iso-8859-1"));
            byte[] bytes = new byte[1024];
            long step = lRemoteSize / 100L;
            step = step == 0L ? 1L : step;
            long process = 0L;
            long localSize = 0L;
            while ((c = in.read(bytes)) != -1) {
                ((OutputStream)out).write(bytes, 0, c);
                long nowProcess = (localSize += (long)c) / step;
                if (nowProcess <= process || (process = nowProcess) % 10L != 0L) continue;
                log.debug("\u4e0b\u8f7d\u8fdb\u5ea6\uff1a" + process);
            }
            in.close();
            ((OutputStream)out).close();
            boolean upNewStatus = this.ftpClient.completePendingCommand();
            result = upNewStatus ? DownloadStatus.DownloadNewSuccess : DownloadStatus.DownloadNewFailed;
        }
        return result;
    }

    boolean changeDirectory(String path) throws IOException {
        return this.ftpClient.changeWorkingDirectory(path);
    }

    boolean removeDirectory(String path) throws IOException {
        return this.ftpClient.removeDirectory(path);
    }

    boolean removeDirectory(String path, boolean isAll) throws IOException {
        if (!isAll) {
            return this.removeDirectory(path);
        }
        FTPFile[] ftpFileArr = this.ftpClient.listFiles(path);
        if (ftpFileArr == null || ftpFileArr.length == 0) {
            return this.removeDirectory(path);
        }
        for (FTPFile ftpFile : ftpFileArr) {
            String name = ftpFile.getName();
            if (ftpFile.isDirectory()) {
                log.debug("* [sD]Delete subPath [" + path + "/" + name + "]");
                if (".".equals(ftpFile.getName()) || "..".equals(ftpFile.getName())) continue;
                this.removeDirectory(path + "/" + name, true);
                continue;
            }
            if (ftpFile.isFile()) {
                log.debug("* [sF]Delete file [" + path + "/" + name + "]");
                this.deleteFile(path + "/" + name);
                continue;
            }
            if (!ftpFile.isSymbolicLink() && !ftpFile.isUnknown()) continue;
        }
        return this.ftpClient.removeDirectory(path);
    }

    boolean isDirectoryExists(String path) throws IOException {
        FTPFile[] ftpFileArr;
        boolean flag = false;
        for (FTPFile ftpFile : ftpFileArr = this.ftpClient.listFiles(path)) {
            if (!ftpFile.isDirectory() || !ftpFile.getName().equalsIgnoreCase(path)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    List<String> getFileList(String path) throws IOException {
        FTPFile[] ftpFiles = this.ftpClient.listFiles(path);
        ArrayList<String> retList = new ArrayList<String>();
        if (ftpFiles == null || ftpFiles.length == 0) {
            return retList;
        }
        for (FTPFile ftpFile : ftpFiles) {
            if (!ftpFile.isFile()) continue;
            retList.add(ftpFile.getName());
        }
        return retList;
    }

    boolean deleteFile(String pathName) throws IOException {
        return this.ftpClient.deleteFile(pathName);
    }

    UploadStatus upload(String local, String remote) throws IOException {
        UploadStatus result;
        FTPFile[] files;
        this.ftpClient.enterLocalPassiveMode();
        this.ftpClient.setFileType(2);
        this.ftpClient.setControlEncoding("GBK");
        String remoteFileName = remote;
        if (remote.contains("/")) {
            remoteFileName = remote.substring(remote.lastIndexOf("/") + 1);
            if (this.createDirectory(remote) == UploadStatus.CreateDirectoryFail) {
                return UploadStatus.CreateDirectoryFail;
            }
        }
        if ((files = this.ftpClient.listFiles(new String(remoteFileName.getBytes("UTF-8"), "iso-8859-1"))).length == 1) {
            File f;
            long localSize;
            long remoteSize = files[0].getSize();
            if (remoteSize == (localSize = (f = new File(local)).length())) {
                return UploadStatus.FileExits;
            }
            if (remoteSize > localSize) {
                return UploadStatus.RemoteFileBiggerThanLocalFile;
            }
            result = this.uploadFile(remoteFileName, f, remoteSize);
            if (result == UploadStatus.UploadFromBreakFailed) {
                if (!this.ftpClient.deleteFile(remoteFileName)) {
                    return UploadStatus.DeleteRemoteFaild;
                }
                result = this.uploadFile(remoteFileName, f, 0L);
            }
        } else {
            result = this.uploadFile(remoteFileName, new File(local), 0L);
        }
        return result;
    }

    UploadStatus createDirectory(String remote) throws IOException {
        UploadStatus status;
        block2: {
            status = UploadStatus.CreateDirectorySuccess;
            String directory = remote.substring(0, remote.lastIndexOf("/") + 1);
            if ("/".equalsIgnoreCase(directory) || this.ftpClient.changeWorkingDirectory(new String(directory.getBytes("UTF-8"), "iso-8859-1"))) break block2;
            int start = 0;
            int end = 0;
            start = directory.startsWith("/") ? 1 : 0;
            end = directory.indexOf("/", start);
            do {
                String subDirectory;
                if (this.ftpClient.changeWorkingDirectory(subDirectory = new String(remote.substring(start, end).getBytes("UTF-8"), "iso-8859-1"))) continue;
                if (this.ftpClient.makeDirectory(subDirectory)) {
                    this.ftpClient.changeWorkingDirectory(subDirectory);
                    continue;
                }
                log.error("\u521b\u5efa\u76ee\u5f55\u5931\u8d25");
                return UploadStatus.CreateDirectoryFail;
            } while ((end = directory.indexOf("/", start = end + 1)) > start);
        }
        return status;
    }

    UploadStatus uploadFile(String remoteFile, File localFile, long remoteSize) throws IOException {
        int c;
        long step = localFile.length() / 100L;
        step = step == 0L ? 1L : step;
        long process = 0L;
        long localreadbytes = 0L;
        RandomAccessFile raf = new RandomAccessFile(localFile, "r");
        OutputStream out = this.ftpClient.appendFileStream(new String(remoteFile.getBytes("UTF-8"), "iso-8859-1"));
        if (remoteSize > 0L) {
            this.ftpClient.setRestartOffset(remoteSize);
            process = remoteSize / step;
            raf.seek(remoteSize);
            localreadbytes = remoteSize;
        }
        byte[] bytes = new byte[1024];
        while ((c = raf.read(bytes)) != -1) {
            out.write(bytes, 0, c);
            if ((localreadbytes += (long)c) / step == process || (process = localreadbytes / step) % 10L != 0L) continue;
            log.debug("\u4e0a\u4f20\u8fdb\u5ea6\uff1a" + process);
        }
        out.flush();
        raf.close();
        out.close();
        boolean result = this.ftpClient.completePendingCommand();
        UploadStatus status = remoteSize > 0L ? (result ? UploadStatus.UploadFromBreakSuccess : UploadStatus.UploadFromBreakFailed) : (result ? UploadStatus.UploadNewFileSuccess : UploadStatus.UploadNewFileFailed);
        return status;
    }

    InputStream downFile(String sourceFileName) throws IOException {
        return this.ftpClient.retrieveFileStream(sourceFileName);
    }

    boolean rename(String sourceFilePath, String targetFilePath) throws IOException {
        return this.ftpClient.rename(sourceFilePath, targetFilePath);
    }
}

