/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.common.utils;

import java.math.BigDecimal;

public class Pi {
    private static final BigDecimal FOUR = BigDecimal.valueOf(4L);
    private static final int ROUNDING_MODE = 6;

    public static BigDecimal compute(int digits) {
        int scale = digits + 5;
        BigDecimal arctan1_5 = Pi.arctan(5, scale);
        BigDecimal arctan1_239 = Pi.arctan(239, scale);
        BigDecimal pi = arctan1_5.multiply(FOUR).subtract(arctan1_239).multiply(FOUR);
        return pi.setScale(digits, 4);
    }

    private static BigDecimal arctan(int inverseX, int scale) {
        BigDecimal term;
        BigDecimal number;
        BigDecimal invX = BigDecimal.valueOf(inverseX);
        BigDecimal invX2 = BigDecimal.valueOf(inverseX * inverseX);
        BigDecimal result = number = BigDecimal.ONE.divide(invX, scale, 6);
        int i = 1;
        do {
            number = number.divide(invX2, scale, 6);
            int denom = 2 * i + 1;
            term = number.divide(BigDecimal.valueOf(denom), scale, 6);
            result = i % 2 != 0 ? result.subtract(term) : result.add(term);
            ++i;
        } while (term.compareTo(BigDecimal.ZERO) != 0);
        return result;
    }
}

