/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.common.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import top.jfunc.common.utils.BeanUtil;
import top.jfunc.common.utils.StrUtil;

public class Map2Bean {
    private Map2Bean() {
    }

    public static <T> T convert(Map<String, Object> map, Class<T> clazz) {
        try {
            T instance = clazz.newInstance();
            ArrayList<Field> fields = new ArrayList<Field>();
            Map2Bean.parseAllFields(clazz, fields);
            for (Field field : fields) {
                String fieldName = field.getName();
                Class<?> type = field.getType();
                if (!BeanUtil.canSetValueDirectly(type)) {
                    BeanUtil.setValue(instance, field, Map2Bean.convert(map, type));
                    continue;
                }
                Object value = map.get(fieldName);
                if (null == value && null == (value = map.get(StrUtil.toUnderlineCase(fieldName)))) continue;
                BeanUtil.setValue(instance, field, value);
            }
            return instance;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private static boolean accepted(Field field) {
        Class<?> type = field.getType();
        if (Map.class.isAssignableFrom(type) || Collection.class.isAssignableFrom(type) || type.isArray()) {
            return false;
        }
        int mod = field.getModifiers();
        return !Modifier.isStatic(mod) && !Modifier.isFinal(mod);
    }

    private static void parseAllFields(Class<?> clazz, List<Field> list) {
        if (clazz != Object.class) {
            Field[] fields = clazz.getDeclaredFields();
            list.addAll(Arrays.stream(fields).filter(Map2Bean::accepted).collect(Collectors.toList()));
            Map2Bean.parseAllFields(clazz.getSuperclass(), list);
        }
    }
}

