/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.common.utils;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.Objects;
import top.jfunc.common.ProgressNotifier;
import top.jfunc.common.utils.CharsetUtil;
import top.jfunc.common.utils.FastByteArrayOutputStream;
import top.jfunc.common.utils.StrUtil;

public class IoUtil {
    public static final int DEFAULT_BUFFER_SIZE = 1024;
    public static final int DEFAULT_LARGE_BUFFER_SIZE = 4096;
    public static final int EOF = -1;

    private IoUtil() {
    }

    public static long copy(Reader reader, Writer writer) throws IOException {
        return IoUtil.copy(reader, writer, 1024, null);
    }

    public static long copy(Reader reader, Writer writer, int bufferSize) throws IOException {
        return IoUtil.copy(reader, writer, bufferSize, null);
    }

    public static long copy(Reader reader, Writer writer, int bufferSize, ProgressNotifier progressNotifier) throws IOException {
        int readSize;
        char[] buffer = new char[bufferSize];
        long size = 0L;
        if (null != progressNotifier) {
            progressNotifier.start();
        }
        while ((readSize = reader.read(buffer, 0, bufferSize)) != -1) {
            writer.write(buffer, 0, readSize);
            size += (long)readSize;
            writer.flush();
            if (null == progressNotifier) continue;
            progressNotifier.progressed(size);
        }
        if (null != progressNotifier) {
            progressNotifier.finish(size);
        }
        return size;
    }

    public static long copy(InputStream in, OutputStream out) throws IOException {
        return IoUtil.copy(in, out, 1024, null);
    }

    public static long copy(InputStream in, OutputStream out, int bufferSize) throws IOException {
        return IoUtil.copy(in, out, bufferSize, null);
    }

    public static long copy(InputStream in, OutputStream out, int bufferSize, ProgressNotifier progressNotifier) throws IOException {
        Objects.requireNonNull(in, "InputStream is null !");
        Objects.requireNonNull(out, "OutputStream is null !");
        if (bufferSize <= 0) {
            bufferSize = 1024;
        }
        byte[] buffer = new byte[bufferSize];
        long size = 0L;
        if (null != progressNotifier) {
            progressNotifier.start();
        }
        int readSize = -1;
        while ((readSize = in.read(buffer)) != -1) {
            out.write(buffer, 0, readSize);
            size += (long)readSize;
            out.flush();
            if (null == progressNotifier) continue;
            progressNotifier.progressed(size);
        }
        if (null != progressNotifier) {
            progressNotifier.finish(size);
        }
        return size;
    }

    public static long copyByNIO(InputStream in, OutputStream out, int bufferSize, ProgressNotifier progressNotifier) throws IOException {
        return IoUtil.copy(Channels.newChannel(in), Channels.newChannel(out), bufferSize, progressNotifier);
    }

    public static long copy(FileInputStream in, FileOutputStream out) throws IOException {
        Objects.requireNonNull(in, "FileInputStream is null!");
        Objects.requireNonNull(out, "FileOutputStream is null!");
        FileChannel inChannel = in.getChannel();
        FileChannel outChannel = out.getChannel();
        return inChannel.transferTo(0L, inChannel.size(), outChannel);
    }

    public static long copy(ReadableByteChannel in, WritableByteChannel out, int bufferSize, ProgressNotifier progressNotifier) throws IOException {
        Objects.requireNonNull(in, "InputStream is null !");
        Objects.requireNonNull(out, "OutputStream is null !");
        ByteBuffer byteBuffer = ByteBuffer.allocate(bufferSize <= 0 ? 1024 : bufferSize);
        long size = 0L;
        if (null != progressNotifier) {
            progressNotifier.start();
        }
        while (in.read(byteBuffer) != -1) {
            byteBuffer.flip();
            size += (long)out.write(byteBuffer);
            byteBuffer.clear();
            if (null == progressNotifier) continue;
            progressNotifier.progressed(size);
        }
        if (null != progressNotifier) {
            progressNotifier.finish(size);
        }
        return size;
    }

    public static BufferedReader getReader(InputStream in, String charsetName) {
        return IoUtil.getReader(in, CharsetUtil.charset(charsetName));
    }

    public static BufferedReader getReader(InputStream in, Charset charset) {
        if (null == in) {
            return null;
        }
        InputStreamReader reader = null;
        reader = null == charset ? new InputStreamReader(in) : new InputStreamReader(in, charset);
        return new BufferedReader(reader);
    }

    public static BufferedReader getReader(Reader reader) {
        if (null == reader) {
            return null;
        }
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public static PushbackReader getPushBackReader(Reader reader, int pushBackSize) {
        return reader instanceof PushbackReader ? (PushbackReader)reader : new PushbackReader(reader, pushBackSize);
    }

    public static OutputStreamWriter getWriter(OutputStream out, String charsetName) {
        return IoUtil.getWriter(out, Charset.forName(charsetName));
    }

    public static OutputStreamWriter getWriter(OutputStream out, Charset charset) {
        if (null == out) {
            return null;
        }
        if (null == charset) {
            return new OutputStreamWriter(out);
        }
        return new OutputStreamWriter(out, charset);
    }

    public static String read(InputStream in, String charsetName) throws IOException {
        FastByteArrayOutputStream out = IoUtil.read(in);
        return StrUtil.isBlank(charsetName) ? out.toString() : out.toString(charsetName);
    }

    public static String read(InputStream in, Charset charset) throws IOException {
        FastByteArrayOutputStream out = IoUtil.read(in);
        return null == charset ? out.toString() : out.toString(charset);
    }

    public static FastByteArrayOutputStream read(InputStream in) throws IOException {
        FastByteArrayOutputStream out = new FastByteArrayOutputStream();
        IoUtil.copy(in, out);
        return out;
    }

    public static String read(Reader reader) throws IOException {
        StringBuilder builder = StrUtil.builder();
        CharBuffer buffer = CharBuffer.allocate(1024);
        while (-1 != reader.read(buffer)) {
            builder.append(buffer.flip().toString());
        }
        return builder.toString();
    }

    public static InputStream getFileInputStream(String fileName) {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return inputStream;
    }

    public static byte[] stream2Bytes(InputStream is) throws IOException {
        FastByteArrayOutputStream stream = new FastByteArrayOutputStream();
        byte[] bytes = new byte[1024];
        int len = is.read(bytes);
        while (len != -1) {
            stream.write(bytes, 0, len);
            len = is.read(bytes);
        }
        return stream.toByteArray();
    }

    public static File copy2File(InputStream inputStream, File file) throws IOException {
        FileOutputStream stream = new FileOutputStream(file);
        IoUtil.copy(inputStream, (OutputStream)stream);
        IoUtil.close(stream);
        return file;
    }

    public static void close(Closeable closeable) {
        if (null != closeable) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

