/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.common.utils;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import top.jfunc.common.utils.StrUtil;

public final class ClassUtil {
    private static final String CLASS_EXT = ".class";
    private static final String JAR_FILE_EXT = ".jar";
    private static final String JAR_PATH_EXT = ".jar!";
    private static final String PATH_FILE_PRE = "file:";
    private static FileFilter fileFilter = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return ClassUtil.isClass(pathname.getName()) || pathname.isDirectory() || ClassUtil.isJarFile(pathname);
        }
    };

    private ClassUtil() {
    }

    public static Set<Class<?>> scanPackageByAnnotation(String packageName, boolean inJar, final Class<? extends Annotation> annotationClass) {
        return ClassUtil.scanPackage(packageName, inJar, new ClassFilter(){

            @Override
            public boolean accept(Class<?> clazz) {
                return clazz.isAnnotationPresent(annotationClass);
            }
        });
    }

    public static Set<Class<?>> scanPackageBySuper(String packageName, boolean inJar, Class<?> superClass) {
        return ClassUtil.scanPackage(packageName, inJar, clazz -> superClass.isAssignableFrom(clazz) && !superClass.equals(clazz));
    }

    public static Set<Class<?>> scanPackage(String packageName, boolean inJar, ClassFilter classFilter) {
        if (StrUtil.isBlank(packageName)) {
            packageName = "";
        }
        packageName = ClassUtil.getWellFormedPackageName(packageName);
        HashSet classes = new HashSet();
        for (String classPath : ClassUtil.getClassPaths(packageName)) {
            classPath = ClassUtil.decodeUrl(classPath);
            ClassUtil.fillClasses(classPath, packageName, classFilter, classes);
        }
        if (inJar) {
            for (String classPath : ClassUtil.getJavaClassPaths()) {
                classPath = ClassUtil.decodeUrl(classPath);
                ClassUtil.fillClasses(classPath, new File(classPath), packageName, classFilter, classes);
            }
        }
        return classes;
    }

    public static Set<String> getClassPaths(String packageName) {
        Enumeration<URL> resources;
        String packagePath = packageName.replace(".", "/");
        try {
            resources = ClassUtil.getClassLoader().getResources(packagePath);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Loading classPath [%s] error!", packageName), e);
        }
        HashSet<String> paths = new HashSet<String>();
        while (resources.hasMoreElements()) {
            paths.add(resources.nextElement().getPath());
        }
        return paths;
    }

    public static String[] getJavaClassPaths() {
        return System.getProperty("java.class.path").split(System.getProperty("path.separator"));
    }

    public static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static ClassLoader getClassLoader() {
        ClassLoader classLoader = ClassUtil.getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassUtil.class.getClassLoader();
        }
        return classLoader;
    }

    public static Class<?> loadClass(String className) throws ClassNotFoundException {
        try {
            return ClassUtil.getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            try {
                return Class.forName(className, false, ClassUtil.getClassLoader());
            }
            catch (ClassNotFoundException ex) {
                return ClassLoader.class.getClassLoader().loadClass(className);
            }
        }
    }

    private static String getWellFormedPackageName(String packageName) {
        return packageName.lastIndexOf(46) != packageName.length() - 1 ? packageName + '.' : packageName;
    }

    private static String removePrefix(String str, String prefix) {
        if (str != null && str.startsWith(prefix)) {
            return str.substring(prefix.length());
        }
        return str;
    }

    private static void fillClasses(String path, String packageName, ClassFilter classFilter, Set<Class<?>> classes) {
        int index = path.lastIndexOf(JAR_PATH_EXT);
        if (index != -1) {
            path = path.substring(0, index + JAR_FILE_EXT.length());
            path = ClassUtil.removePrefix(path, PATH_FILE_PRE);
            ClassUtil.processJarFile(new File(path), packageName, classFilter, classes);
        } else {
            ClassUtil.fillClasses(path, new File(path), packageName, classFilter, classes);
        }
    }

    private static void fillClasses(String classPath, File file, String packageName, ClassFilter classFilter, Set<Class<?>> classes) {
        if (file.isDirectory()) {
            ClassUtil.processDirectory(classPath, file, packageName, classFilter, classes);
        } else if (ClassUtil.isClassFile(file)) {
            ClassUtil.processClassFile(classPath, file, packageName, classFilter, classes);
        } else if (ClassUtil.isJarFile(file)) {
            ClassUtil.processJarFile(file, packageName, classFilter, classes);
        }
    }

    private static void processDirectory(String classPath, File directory, String packageName, ClassFilter classFilter, Set<Class<?>> classes) {
        File[] files = directory.listFiles(fileFilter);
        if (null == files || files.length == 0) {
            return;
        }
        for (File file : files) {
            ClassUtil.fillClasses(classPath, file, packageName, classFilter, classes);
        }
    }

    private static void processClassFile(String classPath, File file, String packageName, ClassFilter classFilter, Set<Class<?>> classes) {
        if (!classPath.endsWith(File.separator)) {
            classPath = classPath + File.separator;
        }
        String path = file.getAbsolutePath();
        if (StrUtil.isBlank(packageName)) {
            path = ClassUtil.removePrefix(path, classPath);
        }
        String filePathWithDot = path.replace(File.separator, ".");
        int subIndex = -1;
        subIndex = filePathWithDot.indexOf(packageName);
        if (subIndex != -1) {
            int endIndex = filePathWithDot.lastIndexOf(CLASS_EXT);
            String className = filePathWithDot.substring(subIndex, endIndex);
            ClassUtil.fillClass(className, packageName, classes, classFilter);
        }
    }

    private static void processJarFile(File file, String packageName, ClassFilter classFilter, Set<Class<?>> classes) {
        try {
            for (JarEntry entry : Collections.list(new JarFile(file).entries())) {
                if (!ClassUtil.isClass(entry.getName())) continue;
                String className = entry.getName().replace("/", ".").replace(CLASS_EXT, "");
                ClassUtil.fillClass(className, packageName, classes, classFilter);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void fillClass(String className, String packageName, Set<Class<?>> classes, ClassFilter classFilter) {
        if (className.startsWith(packageName)) {
            try {
                Class<?> clazz = ClassUtil.loadClass(className);
                if (classFilter == null || classFilter.accept(clazz)) {
                    classes.add(clazz);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static boolean isClassFile(File file) {
        return ClassUtil.isClass(file.getName());
    }

    private static boolean isClass(String fileName) {
        return fileName.endsWith(CLASS_EXT);
    }

    private static boolean isJarFile(File file) {
        return file.getName().endsWith(JAR_FILE_EXT);
    }

    private static String decodeUrl(String url) {
        try {
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static void makeAccessible(Constructor<?> ctor) {
        if (!(Modifier.isPublic(ctor.getModifiers()) && Modifier.isPublic(ctor.getDeclaringClass().getModifiers()) || ctor.isAccessible())) {
            ctor.setAccessible(true);
        }
    }

    public static boolean isPresent(ClassLoader classLoader, String ... classNames) {
        try {
            for (String className : classNames) {
                Class.forName(className, true, classLoader);
            }
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    public static interface ClassFilter {
        public boolean accept(Class<?> var1);
    }
}

