/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.common.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import top.jfunc.common.utils.StrUtil;

public class BeanUtil {
    private BeanUtil() {
    }

    public static <T> T newInstance(Class<?> clazz) {
        try {
            return (T)clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object get(Object o, String propertyName) {
        try {
            Class<?> clazz = o.getClass();
            Method getMethod = clazz.getMethod(StrUtil.genGetter(propertyName), new Class[0]);
            Object ret = getMethod.invoke(o, new Object[0]);
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean canSetValueDirectly(Class<?> clazz) {
        return clazz.isPrimitive() || clazz == String.class || clazz == Character.class || clazz == Boolean.class || Number.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz);
    }

    public static <T> void setValue(T instance, Field field, Object v) {
        field.setAccessible(true);
        try {
            v = BeanUtil.compatibleValue(v, field.getType());
            field.set(instance, v);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static Object compatibleValue(Object value, Class<?> toClazz) {
        if (toClazz == Byte.class || toClazz == Byte.TYPE) {
            if (value instanceof Number) {
                return ((Number)value).byteValue();
            }
            if (value instanceof String) {
                return Byte.valueOf((String)value);
            }
        }
        if (toClazz == Short.class || toClazz == Short.TYPE) {
            if (value instanceof Number) {
                return ((Number)value).shortValue();
            }
            if (value instanceof String) {
                return Short.valueOf((String)value);
            }
        }
        if (toClazz == Integer.class || toClazz == Integer.TYPE) {
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            if (value instanceof String) {
                return Integer.valueOf((String)value);
            }
        }
        if (toClazz == Long.class || toClazz == Long.TYPE) {
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            if (value instanceof String) {
                return Long.valueOf((String)value);
            }
        }
        if (toClazz == Double.class || toClazz == Double.TYPE) {
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            if (value instanceof String) {
                return Double.valueOf((String)value);
            }
        }
        if (toClazz == Float.class || toClazz == Float.TYPE) {
            if (value instanceof Number) {
                return Float.valueOf(((Number)value).floatValue());
            }
            if (value instanceof String) {
                return Float.valueOf((String)value);
            }
        }
        if (toClazz == BigDecimal.class) {
            return new BigDecimal(value.toString());
        }
        if (toClazz == BigInteger.class) {
            return new BigInteger(value.toString());
        }
        if (toClazz == Boolean.class || toClazz == Boolean.TYPE) {
            return Boolean.valueOf(value.toString());
        }
        if (toClazz == Character.class || toClazz == Character.TYPE) {
            return value;
        }
        if (toClazz == String.class) {
            return value.toString();
        }
        return value;
    }
}

