/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.common.utils;

import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import top.jfunc.common.Editor;
import top.jfunc.common.utils.ObjectUtil;
import top.jfunc.common.utils.StrUtil;

public class ArrayUtil {
    public static final int INDEX_NOT_FOUND = -1;

    public static <T> boolean isEmpty(T ... array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(Object array) {
        if (null == array) {
            return true;
        }
        if (ArrayUtil.isArray(array)) {
            return 0 == Array.getLength(array);
        }
        throw new RuntimeException("Object to provide is not a Array !");
    }

    public static boolean isEmpty(long ... array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(int ... array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(short ... array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(char ... array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(byte ... array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(double ... array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(float ... array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(boolean ... array) {
        return array == null || array.length == 0;
    }

    public static <T> boolean isNotEmpty(T ... array) {
        return array != null && array.length != 0;
    }

    public static boolean isNotEmpty(Object array) {
        return false == ArrayUtil.isEmpty(array);
    }

    public static boolean isNotEmpty(long ... array) {
        return array != null && array.length != 0;
    }

    public static boolean isNotEmpty(int ... array) {
        return array != null && array.length != 0;
    }

    public static boolean isNotEmpty(short ... array) {
        return array != null && array.length != 0;
    }

    public static boolean isNotEmpty(char ... array) {
        return array != null && array.length != 0;
    }

    public static boolean isNotEmpty(byte ... array) {
        return array != null && array.length != 0;
    }

    public static boolean isNotEmpty(double ... array) {
        return array != null && array.length != 0;
    }

    public static boolean isNotEmpty(float ... array) {
        return array != null && array.length != 0;
    }

    public static boolean isNotEmpty(boolean ... array) {
        return array != null && array.length != 0;
    }

    public static <T> boolean hasNull(T ... array) {
        if (ArrayUtil.isNotEmpty(array)) {
            for (T element : array) {
                if (null != element) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> T firstNonNull(T ... array) {
        if (ArrayUtil.isNotEmpty(array)) {
            for (T val : array) {
                if (null == val) continue;
                return val;
            }
        }
        return null;
    }

    public static <T> T[] newArray(Class<?> componentType, int newSize) {
        return (Object[])Array.newInstance(componentType, newSize);
    }

    public static Object[] cast(Class<?> type, Object arrayObj) throws NullPointerException, IllegalArgumentException {
        if (null == arrayObj) {
            throw new NullPointerException("Argument [arrayObj] is null !");
        }
        if (!arrayObj.getClass().isArray()) {
            throw new IllegalArgumentException("Argument [arrayObj] is not array !");
        }
        if (null == type) {
            return (Object[])arrayObj;
        }
        Class<?> componentType = type.isArray() ? type.getComponentType() : type;
        Object[] array = (Object[])arrayObj;
        Object[] result = ArrayUtil.newArray(componentType, array.length);
        System.arraycopy(array, 0, result, 0, array.length);
        return result;
    }

    @SafeVarargs
    public static <T> T[] append(T[] buffer, T ... newElements) {
        if (ArrayUtil.isEmpty(newElements)) {
            return buffer;
        }
        T[] t = ArrayUtil.resize(buffer, buffer.length + newElements.length);
        System.arraycopy(newElements, 0, t, buffer.length, newElements.length);
        return t;
    }

    public static <T> T[] resize(T[] buffer, int newSize, Class<?> componentType) {
        T[] newArray = ArrayUtil.newArray(componentType, newSize);
        if (ArrayUtil.isNotEmpty(buffer)) {
            System.arraycopy(buffer, 0, newArray, 0, Math.min(buffer.length, newSize));
        }
        return newArray;
    }

    public static <T> T[] resize(T[] buffer, int newSize) {
        return ArrayUtil.resize(buffer, newSize, buffer.getClass().getComponentType());
    }

    @SafeVarargs
    public static <T> T[] addAll(T[] ... arrays) {
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        for (T[] array : arrays) {
            if (array == null) continue;
            length += array.length;
        }
        T[] result = ArrayUtil.newArray(arrays.getClass().getComponentType().getComponentType(), length);
        length = 0;
        for (T[] array : arrays) {
            if (array == null) continue;
            System.arraycopy(array, 0, result, length, array.length);
            length += array.length;
        }
        return result;
    }

    public static Object copy(Object src, int srcPos, Object dest, int destPos, int length) {
        System.arraycopy(src, srcPos, dest, destPos, length);
        return dest;
    }

    public static Object copy(Object src, Object dest, int length) {
        System.arraycopy(src, 0, dest, 0, length);
        return dest;
    }

    public static <T> T[] clone(T[] array) {
        if (array == null) {
            return null;
        }
        return (Object[])array.clone();
    }

    public static <T> T clone(T obj) {
        if (null == obj) {
            return null;
        }
        if (ArrayUtil.isArray(obj)) {
            Object result;
            Class<?> componentType = obj.getClass().getComponentType();
            if (componentType.isPrimitive()) {
                int length = Array.getLength(obj);
                result = Array.newInstance(componentType, length);
                while (length-- > 0) {
                    Array.set(result, length, Array.get(obj, length));
                }
            } else {
                result = ((Object[])obj).clone();
            }
            return (T)result;
        }
        return null;
    }

    public static int[] range(int excludedEnd) {
        return ArrayUtil.range(0, excludedEnd, 1);
    }

    public static int[] range(int includedStart, int excludedEnd) {
        return ArrayUtil.range(includedStart, excludedEnd, 1);
    }

    public static int[] range(int includedStart, int excludedEnd, int step) {
        if (includedStart > excludedEnd) {
            int tmp = includedStart;
            includedStart = excludedEnd;
            excludedEnd = tmp;
        }
        if (step <= 0) {
            step = 1;
        }
        int deviation = excludedEnd - includedStart;
        int length = deviation / step;
        if (deviation % step != 0) {
            ++length;
        }
        int[] range = new int[length];
        for (int i = 0; i < length; ++i) {
            range[i] = includedStart;
            includedStart += step;
        }
        return range;
    }

    public static byte[][] split(byte[] array, int len) {
        int x = array.length / len;
        int y = array.length % len;
        int z = 0;
        if (y != 0) {
            z = 1;
        }
        byte[][] arrays = new byte[x + z][];
        for (int i = 0; i < x + z; ++i) {
            byte[] arr = new byte[len];
            if (i == x + z - 1 && y != 0) {
                System.arraycopy(array, i * len, arr, 0, y);
            } else {
                System.arraycopy(array, i * len, arr, 0, len);
            }
            arrays[i] = arr;
        }
        return arrays;
    }

    public static <T> T[] filter(T[] array, Editor<T> editor) {
        ArrayList<T> list = new ArrayList<T>();
        for (T t : array) {
            T modified = editor.edit(t);
            if (null == modified) continue;
            list.add(t);
        }
        return list.toArray(Arrays.copyOf(array, list.size()));
    }

    public static <K, V> Map<K, V> zip(K[] keys, V[] values, boolean isOrder) {
        if (ArrayUtil.isEmpty(keys) || ArrayUtil.isEmpty(values)) {
            return null;
        }
        int size = Math.min(keys.length, values.length);
        int initialCapacity = (int)((double)size / 0.75);
        HashMap map = isOrder ? new LinkedHashMap(initialCapacity) : new HashMap(initialCapacity);
        for (int i = 0; i < size; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static <K, V> Map<K, V> zip(K[] keys, V[] values) {
        return ArrayUtil.zip(keys, values, false);
    }

    public static <T> int indexOf(T[] array, Object value) {
        for (int i = 0; i < array.length; ++i) {
            if (!ObjectUtil.equal(value, array[i])) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfIgnoreCase(CharSequence[] array, CharSequence value) {
        for (int i = 0; i < array.length; ++i) {
            if (!StrUtil.equalsIgnoreCase(array[i], value)) continue;
            return i;
        }
        return -1;
    }

    public static <T> int lastIndexOf(T[] array, Object value) {
        for (int i = array.length - 1; i >= 0; --i) {
            if (!ObjectUtil.equal(value, array[i])) continue;
            return i;
        }
        return -1;
    }

    public static <T> boolean contains(T[] array, T value) {
        return ArrayUtil.indexOf(array, value) > -1;
    }

    public static boolean containsIgnoreCase(CharSequence[] array, CharSequence value) {
        return ArrayUtil.indexOfIgnoreCase(array, value) > -1;
    }

    public static int indexOf(long[] array, long value) {
        for (int i = 0; i < array.length; ++i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(long[] array, long value) {
        for (int i = array.length - 1; i >= 0; --i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(long[] array, long value) {
        return ArrayUtil.indexOf(array, value) > -1;
    }

    public static int indexOf(int[] array, int value) {
        for (int i = 0; i < array.length; ++i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(int[] array, int value) {
        for (int i = array.length - 1; i >= 0; --i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(int[] array, int value) {
        return ArrayUtil.indexOf(array, value) > -1;
    }

    public static int indexOf(short[] array, short value) {
        for (int i = 0; i < array.length; ++i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(short[] array, short value) {
        for (int i = array.length - 1; i >= 0; --i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(short[] array, short value) {
        return ArrayUtil.indexOf(array, value) > -1;
    }

    public static int indexOf(char[] array, char value) {
        for (int i = 0; i < array.length; ++i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(char[] array, char value) {
        for (int i = array.length - 1; i >= 0; --i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(char[] array, char value) {
        return ArrayUtil.indexOf(array, value) > -1;
    }

    public static int indexOf(byte[] array, byte value) {
        for (int i = 0; i < array.length; ++i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(byte[] array, byte value) {
        for (int i = array.length - 1; i >= 0; --i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(byte[] array, byte value) {
        return ArrayUtil.indexOf(array, value) > -1;
    }

    public static int indexOf(double[] array, double value) {
        for (int i = 0; i < array.length; ++i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(double[] array, double value) {
        for (int i = array.length - 1; i >= 0; --i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(double[] array, double value) {
        return ArrayUtil.indexOf(array, value) > -1;
    }

    public static int indexOf(float[] array, float value) {
        for (int i = 0; i < array.length; ++i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(float[] array, float value) {
        for (int i = array.length - 1; i >= 0; --i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(float[] array, float value) {
        return ArrayUtil.indexOf(array, value) > -1;
    }

    public static int indexOf(boolean[] array, boolean value) {
        for (int i = 0; i < array.length; ++i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(boolean[] array, boolean value) {
        for (int i = array.length - 1; i >= 0; --i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(boolean[] array, boolean value) {
        return ArrayUtil.indexOf(array, value) > -1;
    }

    public static Integer[] wrap(int ... values) {
        int length = values.length;
        Integer[] array = new Integer[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static int[] unWrap(Integer ... values) {
        int length = values.length;
        int[] array = new int[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static Long[] wrap(long ... values) {
        int length = values.length;
        Long[] array = new Long[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static long[] unWrap(Long ... values) {
        int length = values.length;
        long[] array = new long[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static Character[] wrap(char ... values) {
        int length = values.length;
        Character[] array = new Character[length];
        for (int i = 0; i < length; ++i) {
            array[i] = Character.valueOf(values[i]);
        }
        return array;
    }

    public static char[] unWrap(Character ... values) {
        int length = values.length;
        char[] array = new char[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i].charValue();
        }
        return array;
    }

    public static Byte[] wrap(byte ... values) {
        int length = values.length;
        Byte[] array = new Byte[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static byte[] unWrap(Byte ... values) {
        int length = values.length;
        byte[] array = new byte[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static Short[] wrap(short ... values) {
        int length = values.length;
        Short[] array = new Short[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static short[] unWrap(Short ... values) {
        int length = values.length;
        short[] array = new short[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static Float[] wrap(float ... values) {
        int length = values.length;
        Float[] array = new Float[length];
        for (int i = 0; i < length; ++i) {
            array[i] = Float.valueOf(values[i]);
        }
        return array;
    }

    public static float[] unWrap(Float ... values) {
        int length = values.length;
        float[] array = new float[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i].floatValue();
        }
        return array;
    }

    public static Double[] wrap(double ... values) {
        int length = values.length;
        Double[] array = new Double[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static double[] unWrap(Double ... values) {
        int length = values.length;
        double[] array = new double[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static Boolean[] wrap(boolean ... values) {
        int length = values.length;
        Boolean[] array = new Boolean[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static boolean[] unWrap(Boolean ... values) {
        int length = values.length;
        boolean[] array = new boolean[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static Object[] wrap(Object obj) {
        if (ArrayUtil.isArray(obj)) {
            try {
                return (Object[])obj;
            }
            catch (Exception e) {
                String className;
                switch (className = obj.getClass().getComponentType().getName()) {
                    case "long": {
                        return ArrayUtil.wrap((long[])obj);
                    }
                    case "int": {
                        return ArrayUtil.wrap((int[])obj);
                    }
                    case "short": {
                        return ArrayUtil.wrap((short[])obj);
                    }
                    case "char": {
                        return ArrayUtil.wrap((char[])obj);
                    }
                    case "byte": {
                        return ArrayUtil.wrap((byte[])obj);
                    }
                    case "boolean": {
                        return ArrayUtil.wrap((boolean[])obj);
                    }
                    case "float": {
                        return ArrayUtil.wrap((float[])obj);
                    }
                    case "double": {
                        return ArrayUtil.wrap((double[])obj);
                    }
                }
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException(StrUtil.format((CharSequence)"[{}] is not Array!", obj.getClass()));
    }

    public static boolean isArray(Object obj) {
        if (null == obj) {
            return false;
        }
        return obj.getClass().isArray();
    }

    public static String toString(Object obj) {
        if (null == obj) {
            return null;
        }
        if (ArrayUtil.isArray(obj)) {
            try {
                return Arrays.deepToString((Object[])obj);
            }
            catch (Exception e) {
                String className;
                switch (className = obj.getClass().getComponentType().getName()) {
                    case "long": {
                        return Arrays.toString((long[])obj);
                    }
                    case "int": {
                        return Arrays.toString((int[])obj);
                    }
                    case "short": {
                        return Arrays.toString((short[])obj);
                    }
                    case "char": {
                        return Arrays.toString((char[])obj);
                    }
                    case "byte": {
                        return Arrays.toString((byte[])obj);
                    }
                    case "boolean": {
                        return Arrays.toString((boolean[])obj);
                    }
                    case "float": {
                        return Arrays.toString((float[])obj);
                    }
                    case "double": {
                        return Arrays.toString((double[])obj);
                    }
                }
                throw new RuntimeException(e);
            }
        }
        return obj.toString();
    }

    public static int length(Object array) throws IllegalArgumentException {
        if (null == array) {
            return 0;
        }
        return Array.getLength(array);
    }

    public static <T> String join(T[] array, CharSequence conjunction) {
        if (null == array) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (T item : array) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(conjunction);
            }
            if (ArrayUtil.isArray(item)) {
                sb.append(ArrayUtil.join(ArrayUtil.wrap(item), conjunction));
                continue;
            }
            if (item instanceof Iterable) {
                sb.append(ArrayUtil.join((Iterable)item, conjunction));
                continue;
            }
            if (item instanceof Iterator) {
                sb.append(ArrayUtil.join((Iterator)item, conjunction));
                continue;
            }
            sb.append(item);
        }
        return sb.toString();
    }

    public static <T> String join(Iterator<T> iterator, CharSequence conjunction) {
        if (null == iterator) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        while (iterator.hasNext()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(conjunction);
            }
            T item = iterator.next();
            if (ArrayUtil.isArray(item)) {
                sb.append(ArrayUtil.join(ArrayUtil.wrap(item), conjunction));
                continue;
            }
            if (item instanceof Iterable) {
                sb.append(ArrayUtil.join((Iterable)item, conjunction));
                continue;
            }
            if (item instanceof Iterator) {
                sb.append(ArrayUtil.join((Iterator)item, conjunction));
                continue;
            }
            sb.append(item);
        }
        return sb.toString();
    }

    public static String join(long[] array, String conjunction) {
        if (null == array) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (long item : array) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(conjunction);
            }
            sb.append(item);
        }
        return sb.toString();
    }

    public static String join(int[] array, String conjunction) {
        if (null == array) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (int item : array) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(conjunction);
            }
            sb.append(item);
        }
        return sb.toString();
    }

    public static String join(short[] array, String conjunction) {
        if (null == array) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (short item : array) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(conjunction);
            }
            sb.append(item);
        }
        return sb.toString();
    }

    public static String join(char[] array, String conjunction) {
        if (null == array) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (char item : array) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(conjunction);
            }
            sb.append(item);
        }
        return sb.toString();
    }

    public static String join(byte[] array, String conjunction) {
        if (null == array) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (byte item : array) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(conjunction);
            }
            sb.append(item);
        }
        return sb.toString();
    }

    public static String join(boolean[] array, String conjunction) {
        if (null == array) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (boolean item : array) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(conjunction);
            }
            sb.append(item);
        }
        return sb.toString();
    }

    public static String join(float[] array, String conjunction) {
        if (null == array) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (float item : array) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(conjunction);
            }
            sb.append(item);
        }
        return sb.toString();
    }

    public static String join(double[] array, String conjunction) {
        if (null == array) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (double item : array) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(conjunction);
            }
            sb.append(item);
        }
        return sb.toString();
    }

    public static String join(Object array, CharSequence conjunction) {
        if (ArrayUtil.isArray(array)) {
            Class<?> componentType = array.getClass().getComponentType();
            if (componentType.isPrimitive()) {
                String componentTypeName;
                switch (componentTypeName = componentType.getName()) {
                    case "long": {
                        return ArrayUtil.join((Object)((long[])array), conjunction);
                    }
                    case "int": {
                        return ArrayUtil.join((Object)((int[])array), conjunction);
                    }
                    case "short": {
                        return ArrayUtil.join((Object)((short[])array), conjunction);
                    }
                    case "char": {
                        return ArrayUtil.join((Object)((char[])array), conjunction);
                    }
                    case "byte": {
                        return ArrayUtil.join((Object)((byte[])array), conjunction);
                    }
                    case "boolean": {
                        return ArrayUtil.join((Object)((boolean[])array), conjunction);
                    }
                    case "float": {
                        return ArrayUtil.join((Object)((float[])array), conjunction);
                    }
                    case "double": {
                        return ArrayUtil.join((Object)((double[])array), conjunction);
                    }
                }
                throw new RuntimeException(StrUtil.format((CharSequence)"Unknown primitive type: [{}]", componentTypeName));
            }
            return ArrayUtil.join((Object[])array, conjunction);
        }
        throw new RuntimeException(StrUtil.format((CharSequence)"[{}] is not a Array!", array.getClass()));
    }

    public static byte[] toArray(ByteBuffer bytebuffer) {
        if (!bytebuffer.hasArray()) {
            int oldPosition = bytebuffer.position();
            bytebuffer.position(0);
            int size = bytebuffer.limit();
            byte[] buffers = new byte[size];
            bytebuffer.get(buffers);
            bytebuffer.position(oldPosition);
            return buffers;
        }
        return Arrays.copyOfRange(bytebuffer.array(), bytebuffer.position(), bytebuffer.limit());
    }

    public static <T> T[] toArray(Iterator<T> iterator, Class<T> componentType) {
        return ArrayUtil.toArray(ArrayUtil.newArrayList(iterator), componentType);
    }

    public static <T> T[] toArray(Iterable<T> iterable, Class<T> componentType) {
        return ArrayUtil.toArray(ArrayUtil.toCollection(iterable), componentType);
    }

    public static <T> T[] toArray(Collection<T> collection, Class<T> componentType) {
        T[] array = ArrayUtil.newArray(componentType, collection.size());
        return collection.toArray(array);
    }

    public static <T> ArrayList<T> newArrayList(Iterator<T> iter) {
        ArrayList<T> list = new ArrayList<T>();
        if (null == iter) {
            return list;
        }
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    public static <E> Collection<E> toCollection(Iterable<E> iterable) {
        return iterable instanceof Collection ? (ArrayList<E>)iterable : ArrayUtil.newArrayList(iterable.iterator());
    }

    public static <T> T[] remove(T[] array, int index) throws IllegalArgumentException {
        return (Object[])ArrayUtil.remove(array, index);
    }

    public static long[] remove(long[] array, int index) throws IllegalArgumentException {
        return (long[])ArrayUtil.remove((Object)array, index);
    }

    public static int[] remove(int[] array, int index) throws IllegalArgumentException {
        return (int[])ArrayUtil.remove((Object)array, index);
    }

    public static short[] remove(short[] array, int index) throws IllegalArgumentException {
        return (short[])ArrayUtil.remove((Object)array, index);
    }

    public static char[] remove(char[] array, int index) throws IllegalArgumentException {
        return (char[])ArrayUtil.remove((Object)array, index);
    }

    public static byte[] remove(byte[] array, int index) throws IllegalArgumentException {
        return (byte[])ArrayUtil.remove((Object)array, index);
    }

    public static double[] remove(double[] array, int index) throws IllegalArgumentException {
        return (double[])ArrayUtil.remove((Object)array, index);
    }

    public static float[] remove(float[] array, int index) throws IllegalArgumentException {
        return (float[])ArrayUtil.remove((Object)array, index);
    }

    public static boolean[] remove(boolean[] array, int index) throws IllegalArgumentException {
        return (boolean[])ArrayUtil.remove((Object)array, index);
    }

    public static Object remove(Object array, int index) throws IllegalArgumentException {
        if (null == array) {
            return array;
        }
        int length = ArrayUtil.length(array);
        if (index < 0 || index >= length) {
            return array;
        }
        Object result = Array.newInstance(array.getClass().getComponentType(), length - 1);
        System.arraycopy(array, 0, result, 0, index);
        if (index < length - 1) {
            System.arraycopy(array, index + 1, result, index, length - index - 1);
        }
        return result;
    }

    public static <T> T[] removeEle(T[] array, T element) throws IllegalArgumentException {
        return ArrayUtil.remove(array, ArrayUtil.indexOf(array, element));
    }

    public static long[] removeEle(long[] array, long element) throws IllegalArgumentException {
        return ArrayUtil.remove(array, ArrayUtil.indexOf(array, element));
    }

    public static int[] removeEle(int[] array, int element) throws IllegalArgumentException {
        return ArrayUtil.remove(array, ArrayUtil.indexOf(array, element));
    }

    public static short[] removeEle(short[] array, short element) throws IllegalArgumentException {
        return ArrayUtil.remove(array, ArrayUtil.indexOf(array, element));
    }

    public static char[] removeEle(char[] array, char element) throws IllegalArgumentException {
        return ArrayUtil.remove(array, ArrayUtil.indexOf(array, element));
    }

    public static byte[] removeEle(byte[] array, byte element) throws IllegalArgumentException {
        return ArrayUtil.remove(array, ArrayUtil.indexOf(array, element));
    }

    public static double[] removeEle(double[] array, double element) throws IllegalArgumentException {
        return ArrayUtil.remove(array, ArrayUtil.indexOf(array, element));
    }

    public static float[] removeEle(float[] array, float element) throws IllegalArgumentException {
        return ArrayUtil.remove(array, ArrayUtil.indexOf(array, element));
    }

    public static boolean[] removeEle(boolean[] array, boolean element) throws IllegalArgumentException {
        return ArrayUtil.remove(array, ArrayUtil.indexOf(array, element));
    }

    public static <T> T[] reverse(T[] array, int startIndexInclusive, int endIndexExclusive) {
        if (ArrayUtil.isEmpty(array)) {
            return array;
        }
        int i = startIndexInclusive < 0 ? 0 : startIndexInclusive;
        for (int j = Math.min(array.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            T tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
        return array;
    }

    public static <T> T[] reverse(T[] array) {
        return ArrayUtil.reverse(array, 0, array.length);
    }

    public static long[] reverse(long[] array, int startIndexInclusive, int endIndexExclusive) {
        if (ArrayUtil.isEmpty(array)) {
            return array;
        }
        int i = startIndexInclusive < 0 ? 0 : startIndexInclusive;
        for (int j = Math.min(array.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            long tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
        return array;
    }

    public static long[] reverse(long[] array) {
        return ArrayUtil.reverse(array, 0, array.length);
    }

    public static int[] reverse(int[] array, int startIndexInclusive, int endIndexExclusive) {
        if (ArrayUtil.isEmpty(array)) {
            return array;
        }
        int i = startIndexInclusive < 0 ? 0 : startIndexInclusive;
        for (int j = Math.min(array.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            int tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
        return array;
    }

    public static int[] reverse(int[] array) {
        return ArrayUtil.reverse(array, 0, array.length);
    }

    public static short[] reverse(short[] array, int startIndexInclusive, int endIndexExclusive) {
        if (ArrayUtil.isEmpty(array)) {
            return array;
        }
        int i = startIndexInclusive < 0 ? 0 : startIndexInclusive;
        for (int j = Math.min(array.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            short tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
        return array;
    }

    public static short[] reverse(short[] array) {
        return ArrayUtil.reverse(array, 0, array.length);
    }

    public static char[] reverse(char[] array, int startIndexInclusive, int endIndexExclusive) {
        if (ArrayUtil.isEmpty(array)) {
            return array;
        }
        int i = startIndexInclusive < 0 ? 0 : startIndexInclusive;
        for (int j = Math.min(array.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            char tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
        return array;
    }

    public static char[] reverse(char[] array) {
        return ArrayUtil.reverse(array, 0, array.length);
    }

    public static byte[] reverse(byte[] array, int startIndexInclusive, int endIndexExclusive) {
        if (ArrayUtil.isEmpty(array)) {
            return array;
        }
        int i = startIndexInclusive < 0 ? 0 : startIndexInclusive;
        for (int j = Math.min(array.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            byte tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
        return array;
    }

    public static byte[] reverse(byte[] array) {
        return ArrayUtil.reverse(array, 0, array.length);
    }

    public static double[] reverse(double[] array, int startIndexInclusive, int endIndexExclusive) {
        if (ArrayUtil.isEmpty(array)) {
            return array;
        }
        int i = startIndexInclusive < 0 ? 0 : startIndexInclusive;
        for (int j = Math.min(array.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            double tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
        return array;
    }

    public static double[] reverse(double[] array) {
        return ArrayUtil.reverse(array, 0, array.length);
    }

    public static float[] reverse(float[] array, int startIndexInclusive, int endIndexExclusive) {
        if (ArrayUtil.isEmpty(array)) {
            return array;
        }
        int i = startIndexInclusive < 0 ? 0 : startIndexInclusive;
        for (int j = Math.min(array.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            float tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
        return array;
    }

    public static float[] reverse(float[] array) {
        return ArrayUtil.reverse(array, 0, array.length);
    }

    public static boolean[] reverse(boolean[] array, int startIndexInclusive, int endIndexExclusive) {
        if (ArrayUtil.isEmpty(array)) {
            return array;
        }
        int i = startIndexInclusive < 0 ? 0 : startIndexInclusive;
        for (int j = Math.min(array.length, endIndexExclusive) - 1; j > i; --j, ++i) {
            boolean tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
        return array;
    }

    public static boolean[] reverse(boolean[] array) {
        return ArrayUtil.reverse(array, 0, array.length);
    }

    public static <T extends Comparable<? super T>> T min(T[] numberArray) {
        T min = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (ObjectUtil.compare(min, numberArray[i]) <= 0) continue;
            min = numberArray[i];
        }
        return min;
    }

    public static long min(long[] numberArray) {
        long min = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (min <= numberArray[i]) continue;
            min = numberArray[i];
        }
        return min;
    }

    public static int min(int[] numberArray) {
        int min = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (min <= numberArray[i]) continue;
            min = numberArray[i];
        }
        return min;
    }

    public static short min(short[] numberArray) {
        short min = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (min <= numberArray[i]) continue;
            min = numberArray[i];
        }
        return min;
    }

    public static char min(char[] numberArray) {
        char min = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (min <= numberArray[i]) continue;
            min = numberArray[i];
        }
        return min;
    }

    public static byte min(byte[] numberArray) {
        byte min = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (min <= numberArray[i]) continue;
            min = numberArray[i];
        }
        return min;
    }

    public static double min(double[] numberArray) {
        double min = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (!(min > numberArray[i])) continue;
            min = numberArray[i];
        }
        return min;
    }

    public static float min(float[] numberArray) {
        float min = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (!(min > numberArray[i])) continue;
            min = numberArray[i];
        }
        return min;
    }

    public static <T extends Comparable<? super T>> T max(T[] numberArray) {
        T max = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (ObjectUtil.compare(max, numberArray[i]) >= 0) continue;
            max = numberArray[i];
        }
        return max;
    }

    public static long max(long[] numberArray) {
        long max = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (max >= numberArray[i]) continue;
            max = numberArray[i];
        }
        return max;
    }

    public static int max(int[] numberArray) {
        int max = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (max >= numberArray[i]) continue;
            max = numberArray[i];
        }
        return max;
    }

    public static short max(short[] numberArray) {
        short max = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (max >= numberArray[i]) continue;
            max = numberArray[i];
        }
        return max;
    }

    public static char max(char[] numberArray) {
        char max = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (max >= numberArray[i]) continue;
            max = numberArray[i];
        }
        return max;
    }

    public static byte max(byte[] numberArray) {
        byte max = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (max >= numberArray[i]) continue;
            max = numberArray[i];
        }
        return max;
    }

    public static double max(double[] numberArray) {
        double max = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (!(max < numberArray[i])) continue;
            max = numberArray[i];
        }
        return max;
    }

    public static float max(float[] numberArray) {
        float max = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (!(max < numberArray[i])) continue;
            max = numberArray[i];
        }
        return max;
    }
}

