/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.common.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ArrayListMultimap<K, V> {
    private final transient Map<K, List<V>> map;

    public ArrayListMultimap() {
        this.map = new HashMap<K, List<V>>();
    }

    public ArrayListMultimap(int capacity) {
        this.map = new HashMap<K, List<V>>(capacity);
    }

    private static <V1> List<V1> createList() {
        return new ArrayList();
    }

    public boolean put(K key, V value) {
        List<Object> list = this.map.get(key);
        if (list == null) {
            list = ArrayListMultimap.createList();
            if (list.add(value)) {
                this.map.put(key, list);
                return true;
            }
            throw new AssertionError((Object)"New list violated the list spec");
        }
        return list.add(value);
    }

    public Map<K, List<V>> getMap() {
        return this.map;
    }

    public List<V> get(K key) {
        List<Object> list = this.map.get(key);
        if (list == null) {
            list = ArrayListMultimap.createList();
        }
        return list;
    }

    public V getFirst(K key) {
        List<V> list = this.map.get(key);
        return null == list || list.size() == 0 ? null : (V)list.get(0);
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public void clear() {
        this.map.clear();
    }

    public static <K1, V1> ArrayListMultimap<K1, V1> fromMap(Map<K1, V1> map) {
        if (null == map) {
            return null;
        }
        ArrayListMultimap mapList = new ArrayListMultimap(map.size());
        map.forEach(mapList::put);
        return mapList;
    }
}

