/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.common.sensitiveword.impl.stop;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import top.jfunc.common.sensitiveword.AbstractSensitiveWordFilter;
import top.jfunc.common.sensitiveword.SensitiveWordFilter;
import top.jfunc.common.sensitiveword.impl.stop.BCConvert;
import top.jfunc.common.sensitiveword.impl.stop.FilterSet;
import top.jfunc.common.sensitiveword.impl.stop.WordNode;

public class WithStopFilter
extends AbstractSensitiveWordFilter
implements SensitiveWordFilter {
    private final FilterSet set = new FilterSet();
    private final Map<Integer, WordNode> nodes = new HashMap<Integer, WordNode>(1024, 1.0f);
    private final Set<Integer> stopwdSet = new HashSet<Integer>();
    private char replaceChar = (char)42;
    private static final Set<String> STOP_WORDS = new HashSet<String>();

    public WithStopFilter() {
    }

    public WithStopFilter(char replaceChar) {
        this.replaceChar = replaceChar;
    }

    @Override
    public void init(Set<String> sensitiveWords) {
        this.addSensitiveWord(sensitiveWords);
        this.addStopWord(STOP_WORDS);
        this.isInit = true;
    }

    @Override
    public final String doFilter(String src) {
        this.checkInit();
        if (null == src || "".equals(src)) {
            return src;
        }
        char[] chs = src.toCharArray();
        int length = chs.length;
        for (int i = 0; i < length; ++i) {
            WordNode node;
            int currc = WithStopFilter.charConvert(chs[i]);
            if (!this.set.contains(currc) || (node = this.nodes.get(currc)) == null) continue;
            boolean couldMark = false;
            int markNum = -1;
            if (node.isLast()) {
                couldMark = true;
                markNum = 0;
            }
            int k = i;
            while (++k < length) {
                int temp = WithStopFilter.charConvert(chs[k]);
                if (this.stopwdSet.contains(temp)) continue;
                if ((node = node.querySub(temp)) == null) break;
                if (!node.isLast()) continue;
                couldMark = true;
                markNum = k - i;
            }
            if (!couldMark) continue;
            for (k = 0; k <= markNum; ++k) {
                chs[k + i] = this.replaceChar;
            }
            i += markNum;
        }
        return new String(chs);
    }

    @Override
    public Set<String> doGetSensitiveWords(String src) {
        HashSet<String> words = new HashSet<String>();
        this.checkInit();
        if (null == src || "".equals(src)) {
            return words;
        }
        char[] chs = src.toCharArray();
        int length = chs.length;
        for (int i = 0; i < length; ++i) {
            WordNode node;
            int currc = WithStopFilter.charConvert(chs[i]);
            if (!this.set.contains(currc) || (node = this.nodes.get(currc)) == null) continue;
            boolean couldMark = false;
            int markNum = -1;
            if (node.isLast()) {
                couldMark = true;
                markNum = 0;
            }
            int k = i;
            while (++k < length) {
                int temp = WithStopFilter.charConvert(chs[k]);
                if (this.stopwdSet.contains(temp)) continue;
                if ((node = node.querySub(temp)) == null) break;
                if (!node.isLast()) continue;
                couldMark = true;
                markNum = k - i;
            }
            if (!couldMark) continue;
            String sensitive = new String(chs, i, markNum + 1);
            words.add(sensitive);
            i += markNum;
        }
        return words;
    }

    @Override
    public final boolean isContains(String src) {
        this.checkInit();
        if (null == src || "".equals(src)) {
            return false;
        }
        char[] chs = src.toCharArray();
        int length = chs.length;
        for (int i = 0; i < length; ++i) {
            WordNode node;
            int currc = WithStopFilter.charConvert(chs[i]);
            if (!this.set.contains(currc) || (node = this.nodes.get(currc)) == null) continue;
            boolean couldMark = false;
            if (node.isLast()) {
                couldMark = true;
            }
            int k = i;
            while (++k < length) {
                int temp = WithStopFilter.charConvert(chs[k]);
                if (this.stopwdSet.contains(temp)) continue;
                if ((node = node.querySub(temp)) == null) break;
                if (!node.isLast()) continue;
                couldMark = true;
            }
            if (!couldMark) continue;
            return true;
        }
        return false;
    }

    private void addStopWord(Set<String> words) {
        if (words != null && words.size() > 0) {
            for (String curr : words) {
                char[] chs;
                for (char c : chs = curr.toCharArray()) {
                    this.stopwdSet.add(WithStopFilter.charConvert(c));
                }
            }
        }
    }

    private void addSensitiveWord(Set<String> words) {
        if (words != null && words.size() > 0) {
            for (String curr : words) {
                WordNode fnode;
                char[] chs = curr.toCharArray();
                int fchar = WithStopFilter.charConvert(chs[0]);
                if (!this.set.contains(fchar)) {
                    this.set.add(fchar);
                    fnode = new WordNode(fchar, chs.length == 1);
                    this.nodes.put(fchar, fnode);
                } else {
                    fnode = this.nodes.get(fchar);
                    if (!fnode.isLast() && chs.length == 1) {
                        fnode.setLast(true);
                    }
                }
                int lastIndex = chs.length - 1;
                for (int i = 1; i < chs.length; ++i) {
                    fnode = fnode.addIfNoExist(WithStopFilter.charConvert(chs[i]), i == lastIndex);
                }
            }
        }
    }

    private static int charConvert(char src) {
        int r = BCConvert.qj2bj(src);
        return r >= 65 && r <= 90 ? r + 32 : r;
    }

    static {
        STOP_WORDS.add("!");
        STOP_WORDS.add(".");
        STOP_WORDS.add(",");
        STOP_WORDS.add("#");
        STOP_WORDS.add("$");
        STOP_WORDS.add("%");
        STOP_WORDS.add("&");
        STOP_WORDS.add("*");
        STOP_WORDS.add("(");
        STOP_WORDS.add(")");
        STOP_WORDS.add("|");
        STOP_WORDS.add("?");
        STOP_WORDS.add("/");
        STOP_WORDS.add("@");
        STOP_WORDS.add("\"");
        STOP_WORDS.add("'");
        STOP_WORDS.add(";");
        STOP_WORDS.add("[");
        STOP_WORDS.add("]");
        STOP_WORDS.add("{");
        STOP_WORDS.add("}");
        STOP_WORDS.add("+");
        STOP_WORDS.add("~");
        STOP_WORDS.add("-");
        STOP_WORDS.add("_");
        STOP_WORDS.add("=");
        STOP_WORDS.add("^");
        STOP_WORDS.add("<");
        STOP_WORDS.add(">");
        STOP_WORDS.add("");
        STOP_WORDS.add("\uff01");
        STOP_WORDS.add("\u3002");
        STOP_WORDS.add("\uff0c");
        STOP_WORDS.add("\uffe5");
        STOP_WORDS.add("\uff08");
        STOP_WORDS.add("\uff09");
        STOP_WORDS.add("\uff1f");
        STOP_WORDS.add("\u3001");
        STOP_WORDS.add("\u201c");
        STOP_WORDS.add("\u2018");
        STOP_WORDS.add("\uff1b");
        STOP_WORDS.add("\u3010");
        STOP_WORDS.add("\u3011");
        STOP_WORDS.add("\u2014\u2014");
        STOP_WORDS.add("\u2026\u2026");
        STOP_WORDS.add("\u300a");
        STOP_WORDS.add("\u300b");
    }
}

