/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.common.sensitiveword.impl.simple;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import top.jfunc.common.sensitiveword.AbstractSensitiveWordFilter;
import top.jfunc.common.sensitiveword.SensitiveWordFilter;
import top.jfunc.common.sensitiveword.impl.simple.SensitiveWordInit;

public class SimpleWordFilter
extends AbstractSensitiveWordFilter
implements SensitiveWordFilter {
    private Map sensitiveWordMap = null;
    public static final int MIN_MATCH_TYPE = 1;
    public static final int MAX_MATCH_TYPE = 2;
    private int matchType = 1;
    private String replaceChar = "*";

    public SimpleWordFilter() {
    }

    public SimpleWordFilter(String replaceChar) {
        this.replaceChar = replaceChar;
    }

    public SimpleWordFilter(int matchType, String replaceChar) {
        this.matchType = matchType;
        this.replaceChar = replaceChar;
    }

    @Override
    public void init(Set<String> sensitiveWords) {
        this.sensitiveWordMap = new SensitiveWordInit().initKeyWord(sensitiveWords);
        this.isInit = true;
    }

    @Override
    public String doFilter(String src) {
        this.checkInit();
        if (null == src || "".equals(src)) {
            return src;
        }
        String resultTxt = src;
        Set<String> set = this.doGetSensitiveWords(src);
        Iterator<String> iterator = set.iterator();
        String word = null;
        String replaceString = null;
        while (iterator.hasNext()) {
            word = iterator.next();
            replaceString = this.getReplaceChars(this.replaceChar, word.length());
            resultTxt = resultTxt.replaceAll(word, replaceString);
        }
        return resultTxt;
    }

    @Override
    public boolean isContains(String src) {
        this.checkInit();
        if (null == src || "".equals(src)) {
            return false;
        }
        boolean flag = false;
        for (int i = 0; i < src.length(); ++i) {
            int matchFlag = this.checkSensitiveWord(src, i, this.matchType);
            if (matchFlag <= 0) continue;
            flag = true;
        }
        return flag;
    }

    @Override
    public Set<String> doGetSensitiveWords(String src) {
        HashSet<String> sensitiveWordSet = new HashSet<String>();
        this.checkInit();
        if (null == src || "".equals(src)) {
            return sensitiveWordSet;
        }
        for (int i = 0; i < src.length(); ++i) {
            int length = this.checkSensitiveWord(src, i, this.matchType);
            if (length <= 0) continue;
            sensitiveWordSet.add(src.substring(i, i + length));
            i = i + length - 1;
        }
        return sensitiveWordSet;
    }

    private String getReplaceChars(String replaceChar, int length) {
        String resultReplace = replaceChar;
        for (int i = 1; i < length; ++i) {
            resultReplace = resultReplace + replaceChar;
        }
        return resultReplace;
    }

    private int checkSensitiveWord(String txt, int beginIndex, int matchType) {
        boolean flag = false;
        int matchFlag = 0;
        char word = '\u0000';
        Map nowMap = this.sensitiveWordMap;
        for (int i = beginIndex; i < txt.length() && (nowMap = (Map)nowMap.get(Character.valueOf(word = txt.charAt(i)))) != null; ++i) {
            ++matchFlag;
            if (!"1".equals(nowMap.get("IS_END"))) continue;
            flag = true;
            if (1 == matchType) break;
        }
        if (matchFlag < 2 || !flag) {
            matchFlag = 0;
        }
        return matchFlag;
    }
}

