/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.common.event;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.jfunc.common.event.EventKit;
import top.jfunc.common.event.core.ApplicationListener;
import top.jfunc.common.event.core.EventType;
import top.jfunc.common.event.core.Listener;
import top.jfunc.common.event.core.ListenerAttr;
import top.jfunc.common.event.core.ListenerHelper;
import top.jfunc.common.utils.ArrayListMultimap;
import top.jfunc.common.utils.BeanUtil;
import top.jfunc.common.utils.ClassUtil;
import top.jfunc.common.utils.ThreadFactoryBuilder;

public class EventInitializer {
    private static final Logger log = LoggerFactory.getLogger(EventInitializer.class);
    private static ExecutorService pool = null;
    private static ArrayListMultimap<EventType, ListenerHelper> map = null;
    private boolean scanJar = false;
    private String scanPackage = "";
    private List<ApplicationListener> listeners = new ArrayList<ApplicationListener>();

    public EventInitializer() {
    }

    public EventInitializer(boolean scanJar, String scanPackage, int ... asyncThreads) {
        this.scanJar = scanJar;
        this.scanPackage = scanPackage;
        if (asyncThreads.length > 0 && asyncThreads[0] > 0) {
            this.async(asyncThreads);
        }
    }

    public EventInitializer async(int ... nThreads) {
        ThreadFactory factory = ThreadFactoryBuilder.create().setNameFormat("event-pool-%d").setDaemon(true).build();
        pool = new ThreadPoolExecutor(nThreads.length == 0 || nThreads[0] < 1 ? 5 : nThreads[0], 100, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(512), factory, new ThreadPoolExecutor.CallerRunsPolicy());
        return this;
    }

    public EventInitializer scanJar() {
        this.scanJar = true;
        return this;
    }

    public EventInitializer addListener(ApplicationListener listener) {
        this.listeners.add(listener);
        return this;
    }

    public EventInitializer scanPackage(String scanPackage) {
        this.scanPackage = scanPackage;
        return this;
    }

    public boolean start() {
        this.create();
        EventKit.init(map, pool);
        return true;
    }

    private void create() {
        if (null != map) {
            return;
        }
        Set<Class<?>> clazzSet = ClassUtil.scanPackageBySuper(this.scanPackage, this.scanJar, ApplicationListener.class);
        if (clazzSet.isEmpty()) {
            log.info("annotation Listener is empty");
        }
        Class<ApplicationListener> superClass = ApplicationListener.class;
        for (Class<?> clazz : clazzSet) {
            if (!superClass.isAssignableFrom(clazz) || superClass.equals(clazz)) continue;
            ApplicationListener listener2 = (ApplicationListener)BeanUtil.newInstance(clazz);
            this.listeners.add(listener2);
        }
        if (this.listeners.isEmpty()) {
            log.error("Listener is empty! Please check @Listener is right? or invoke addListener()");
            return;
        }
        this.sortListeners(this.listeners);
        map = new ArrayListMultimap();
        for (ApplicationListener listener3 : this.listeners) {
            Class<?> clazz = listener3.getClass();
            boolean enableAsync = false;
            String tag = "default_tag";
            if (clazz.isAnnotationPresent(Listener.class)) {
                enableAsync = clazz.getAnnotation(Listener.class).enableAsync();
                tag = clazz.getAnnotation(Listener.class).tag();
            } else if (listener3 instanceof ListenerAttr) {
                enableAsync = ((ListenerAttr)((Object)listener3)).getEnableAsync();
                tag = ((ListenerAttr)((Object)listener3)).getTag();
            }
            Type type = ((ParameterizedType)clazz.getGenericInterfaces()[0]).getActualTypeArguments()[0];
            EventType eventType = new EventType(tag, type);
            map.put(eventType, new ListenerHelper(listener3, enableAsync));
        }
        StringBuilder builder = new StringBuilder("\u4e00\u5171\u6709 ").append(this.listeners.size()).append(" \u4e2a\u76d1\u542c\u5668:\r\n");
        this.listeners.forEach(listener -> builder.append(listener).append("\r\n"));
        log.info(builder.toString());
    }

    private void sortListeners(List<ApplicationListener> listeners) {
        Collections.sort(listeners, (l1, l2) -> {
            Class<?> l1Class = l1.getClass();
            Class<?> l2Class = l2.getClass();
            int x = Integer.MAX_VALUE;
            int y = Integer.MAX_VALUE;
            if (l1Class.isAnnotationPresent(Listener.class)) {
                x = l1Class.getAnnotation(Listener.class).order();
            } else if (l1 instanceof ListenerAttr) {
                x = ((ListenerAttr)((Object)l1)).getOrder();
            }
            if (l2Class.isAnnotationPresent(Listener.class)) {
                y = l2Class.getAnnotation(Listener.class).order();
            } else if (l2 instanceof ListenerAttr) {
                y = ((ListenerAttr)((Object)l2)).getOrder();
            }
            return Integer.compare(x, y);
        });
    }

    public boolean stop() {
        if (null != pool) {
            pool.shutdown();
            pool = null;
        }
        if (null != map) {
            map.clear();
            map = null;
        }
        if (this.listeners != null) {
            this.listeners.clear();
            this.listeners = null;
        }
        return true;
    }
}

