/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.node;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.node.NumericIntNode;

public class LongNode
extends NumericIntNode {
    private static final long serialVersionUID = 3L;
    protected final long _value;

    public LongNode(long v) {
        this._value = v;
    }

    public static LongNode valueOf(long l) {
        return new LongNode(l);
    }

    @Override
    public JsonParser.NumberType numberType() {
        return JsonParser.NumberType.LONG;
    }

    @Override
    public boolean isLong() {
        return true;
    }

    @Override
    protected Boolean _asBoolean() {
        return this._value != 0L;
    }

    @Override
    protected String _asString() {
        return String.valueOf(this._value);
    }

    @Override
    public Number numberValue() {
        return this._value;
    }

    @Override
    public short shortValue() {
        if (this._inShortRange()) {
            return (short)this._value;
        }
        return this._reportShortCoercionRangeFail("shortValue()");
    }

    @Override
    public short shortValue(short defaultValue) {
        return this._inShortRange() ? (short)this._value : defaultValue;
    }

    @Override
    public Optional<Short> shortValueOpt() {
        return this._inShortRange() ? Optional.of((short)this._value) : Optional.empty();
    }

    @Override
    public short asShort() {
        if (this._inShortRange()) {
            return (short)this._value;
        }
        return this._reportShortCoercionRangeFail("asShort()");
    }

    @Override
    public short asShort(short defaultValue) {
        return this._inShortRange() ? (short)this._value : defaultValue;
    }

    @Override
    public Optional<Short> asShortOpt() {
        return this._inShortRange() ? Optional.of((short)this._value) : Optional.empty();
    }

    @Override
    public int intValue() {
        if (this._inIntRange()) {
            return (int)this._value;
        }
        return this._reportIntCoercionRangeFail("intValue()");
    }

    @Override
    public int intValue(int defaultValue) {
        return this._inIntRange() ? (int)this._value : defaultValue;
    }

    @Override
    public OptionalInt intValueOpt() {
        return this._inIntRange() ? OptionalInt.of((int)this._value) : OptionalInt.empty();
    }

    @Override
    public int asInt() {
        if (this._inIntRange()) {
            return (int)this._value;
        }
        return this._reportIntCoercionRangeFail("asInt()");
    }

    @Override
    public int asInt(int defaultValue) {
        return this._inIntRange() ? (int)this._value : defaultValue;
    }

    @Override
    public OptionalInt asIntOpt() {
        return this._inIntRange() ? OptionalInt.of((int)this._value) : OptionalInt.empty();
    }

    @Override
    public long longValue() {
        return this._value;
    }

    @Override
    public long longValue(long defaultValue) {
        return this._value;
    }

    @Override
    public OptionalLong longValueOpt() {
        return OptionalLong.of(this._value);
    }

    @Override
    public long asLong() {
        return this._value;
    }

    @Override
    public long asLong(long defaultValue) {
        return this._value;
    }

    @Override
    public OptionalLong asLongOpt() {
        return OptionalLong.of(this._value);
    }

    @Override
    public BigInteger bigIntegerValue() {
        return BigInteger.valueOf(this._value);
    }

    @Override
    public BigInteger bigIntegerValue(BigInteger defaultValue) {
        return BigInteger.valueOf(this._value);
    }

    @Override
    public Optional<BigInteger> bigIntegerValueOpt() {
        return Optional.of(BigInteger.valueOf(this._value));
    }

    @Override
    public BigDecimal decimalValue() {
        return BigDecimal.valueOf(this._value);
    }

    @Override
    public BigDecimal decimalValue(BigDecimal defaultValue) {
        return this.decimalValue();
    }

    @Override
    public Optional<BigDecimal> decimalValueOpt() {
        return Optional.of(this.decimalValue());
    }

    @Override
    protected int _asIntValueUnchecked() {
        return (int)this._value;
    }

    @Override
    protected float _asFloatValueUnchecked() {
        return this._value;
    }

    @Override
    protected double _asDoubleValueUnchecked() {
        return this._value;
    }

    @Override
    protected boolean _inShortRange() {
        return this._value >= -32768L && this._value <= 32767L;
    }

    @Override
    protected boolean _inIntRange() {
        return this._value >= Integer.MIN_VALUE && this._value <= Integer.MAX_VALUE;
    }

    @Override
    protected boolean _inLongRange() {
        return true;
    }

    @Override
    public final void serialize(JsonGenerator jg, SerializationContext provider) throws JacksonException {
        jg.writeNumber(this._value);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof LongNode) {
            return ((LongNode)o)._value == this._value;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return (int)this._value ^ (int)(this._value >> 32);
    }
}

