/*
 * Decompiled with CFR 0.152.
 */
package technology.semi.weaviate.client.v1.graphql.query.builder;

import java.util.LinkedHashSet;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import technology.semi.weaviate.client.v1.filters.WhereFilter;
import technology.semi.weaviate.client.v1.filters.WhereFilterUtil;
import technology.semi.weaviate.client.v1.graphql.query.argument.AskArgument;
import technology.semi.weaviate.client.v1.graphql.query.argument.GroupArgument;
import technology.semi.weaviate.client.v1.graphql.query.argument.NearImageArgument;
import technology.semi.weaviate.client.v1.graphql.query.argument.NearObjectArgument;
import technology.semi.weaviate.client.v1.graphql.query.argument.NearTextArgument;
import technology.semi.weaviate.client.v1.graphql.query.argument.NearVectorArgument;
import technology.semi.weaviate.client.v1.graphql.query.argument.SortArguments;
import technology.semi.weaviate.client.v1.graphql.query.builder.Query;
import technology.semi.weaviate.client.v1.graphql.query.fields.Fields;

public class GetBuilder
implements Query {
    private final String className;
    private final Fields fields;
    private final Integer offset;
    private final Integer limit;
    private final WhereFilter withWhereFilter;
    private final NearTextArgument withNearTextFilter;
    private final NearObjectArgument withNearObjectFilter;
    private final AskArgument withAskArgument;
    private final NearImageArgument withNearImageFilter;
    private final NearVectorArgument withNearVectorFilter;
    private final GroupArgument withGroupArgument;
    private final SortArguments withSortArguments;

    private boolean includesFilterClause() {
        return ObjectUtils.anyNotNull((Object[])new Object[]{this.withWhereFilter, this.withNearTextFilter, this.withNearObjectFilter, this.withNearVectorFilter, this.withNearImageFilter, this.withGroupArgument, this.withAskArgument, this.limit, this.offset, this.withSortArguments});
    }

    private String createFilterClause() {
        if (this.includesFilterClause()) {
            LinkedHashSet<String> filters = new LinkedHashSet<String>();
            if (this.withWhereFilter != null) {
                filters.add(WhereFilterUtil.toGraphQLString(this.withWhereFilter));
            }
            if (this.withNearTextFilter != null) {
                filters.add(this.withNearTextFilter.build());
            }
            if (this.withNearObjectFilter != null) {
                filters.add(this.withNearObjectFilter.build());
            }
            if (this.withNearVectorFilter != null) {
                filters.add(this.withNearVectorFilter.build());
            }
            if (this.withGroupArgument != null) {
                filters.add(this.withGroupArgument.build());
            }
            if (this.withAskArgument != null) {
                filters.add(this.withAskArgument.build());
            }
            if (this.withNearImageFilter != null) {
                filters.add(this.withNearImageFilter.build());
            }
            if (this.limit != null) {
                filters.add(String.format("limit: %s", this.limit));
            }
            if (this.offset != null) {
                filters.add(String.format("offset: %s", this.offset));
            }
            if (this.withSortArguments != null) {
                filters.add(this.withSortArguments.build());
            }
            return String.format("(%s)", StringUtils.joinWith((String)", ", (Object[])filters.toArray()));
        }
        return "";
    }

    private String createFields() {
        return this.fields != null ? this.fields.build() : "";
    }

    @Override
    public String buildQuery() {
        return String.format("{Get{%s%s{%s}}}", this.className, this.createFilterClause(), this.createFields());
    }

    GetBuilder(String className, Fields fields, Integer offset, Integer limit, WhereFilter withWhereFilter, NearTextArgument withNearTextFilter, NearObjectArgument withNearObjectFilter, AskArgument withAskArgument, NearImageArgument withNearImageFilter, NearVectorArgument withNearVectorFilter, GroupArgument withGroupArgument, SortArguments withSortArguments) {
        this.className = className;
        this.fields = fields;
        this.offset = offset;
        this.limit = limit;
        this.withWhereFilter = withWhereFilter;
        this.withNearTextFilter = withNearTextFilter;
        this.withNearObjectFilter = withNearObjectFilter;
        this.withAskArgument = withAskArgument;
        this.withNearImageFilter = withNearImageFilter;
        this.withNearVectorFilter = withNearVectorFilter;
        this.withGroupArgument = withGroupArgument;
        this.withSortArguments = withSortArguments;
    }

    public static GetBuilderBuilder builder() {
        return new GetBuilderBuilder();
    }

    public String getClassName() {
        return this.className;
    }

    public Fields getFields() {
        return this.fields;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public WhereFilter getWithWhereFilter() {
        return this.withWhereFilter;
    }

    public NearTextArgument getWithNearTextFilter() {
        return this.withNearTextFilter;
    }

    public NearObjectArgument getWithNearObjectFilter() {
        return this.withNearObjectFilter;
    }

    public AskArgument getWithAskArgument() {
        return this.withAskArgument;
    }

    public NearImageArgument getWithNearImageFilter() {
        return this.withNearImageFilter;
    }

    public NearVectorArgument getWithNearVectorFilter() {
        return this.withNearVectorFilter;
    }

    public GroupArgument getWithGroupArgument() {
        return this.withGroupArgument;
    }

    public SortArguments getWithSortArguments() {
        return this.withSortArguments;
    }

    public static class GetBuilderBuilder {
        private String className;
        private Fields fields;
        private Integer offset;
        private Integer limit;
        private WhereFilter withWhereFilter;
        private NearTextArgument withNearTextFilter;
        private NearObjectArgument withNearObjectFilter;
        private AskArgument withAskArgument;
        private NearImageArgument withNearImageFilter;
        private NearVectorArgument withNearVectorFilter;
        private GroupArgument withGroupArgument;
        private SortArguments withSortArguments;

        GetBuilderBuilder() {
        }

        public GetBuilderBuilder className(String className) {
            this.className = className;
            return this;
        }

        public GetBuilderBuilder fields(Fields fields) {
            this.fields = fields;
            return this;
        }

        public GetBuilderBuilder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public GetBuilderBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public GetBuilderBuilder withWhereFilter(WhereFilter withWhereFilter) {
            this.withWhereFilter = withWhereFilter;
            return this;
        }

        public GetBuilderBuilder withNearTextFilter(NearTextArgument withNearTextFilter) {
            this.withNearTextFilter = withNearTextFilter;
            return this;
        }

        public GetBuilderBuilder withNearObjectFilter(NearObjectArgument withNearObjectFilter) {
            this.withNearObjectFilter = withNearObjectFilter;
            return this;
        }

        public GetBuilderBuilder withAskArgument(AskArgument withAskArgument) {
            this.withAskArgument = withAskArgument;
            return this;
        }

        public GetBuilderBuilder withNearImageFilter(NearImageArgument withNearImageFilter) {
            this.withNearImageFilter = withNearImageFilter;
            return this;
        }

        public GetBuilderBuilder withNearVectorFilter(NearVectorArgument withNearVectorFilter) {
            this.withNearVectorFilter = withNearVectorFilter;
            return this;
        }

        public GetBuilderBuilder withGroupArgument(GroupArgument withGroupArgument) {
            this.withGroupArgument = withGroupArgument;
            return this;
        }

        public GetBuilderBuilder withSortArguments(SortArguments withSortArguments) {
            this.withSortArguments = withSortArguments;
            return this;
        }

        public GetBuilder build() {
            return new GetBuilder(this.className, this.fields, this.offset, this.limit, this.withWhereFilter, this.withNearTextFilter, this.withNearObjectFilter, this.withAskArgument, this.withNearImageFilter, this.withNearVectorFilter, this.withGroupArgument, this.withSortArguments);
        }

        public String toString() {
            return "GetBuilder.GetBuilderBuilder(className=" + this.className + ", fields=" + this.fields + ", offset=" + this.offset + ", limit=" + this.limit + ", withWhereFilter=" + this.withWhereFilter + ", withNearTextFilter=" + this.withNearTextFilter + ", withNearObjectFilter=" + this.withNearObjectFilter + ", withAskArgument=" + this.withAskArgument + ", withNearImageFilter=" + this.withNearImageFilter + ", withNearVectorFilter=" + this.withNearVectorFilter + ", withGroupArgument=" + this.withGroupArgument + ", withSortArguments=" + this.withSortArguments + ")";
        }
    }
}

