/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.worker.common.utils;

import akka.actor.ActorSelection;
import akka.pattern.Patterns;
import java.time.Duration;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import tech.powerjob.common.exception.PowerJobException;
import tech.powerjob.common.response.AskResponse;

public class AkkaUtils {
    private static final Logger log = LoggerFactory.getLogger(AkkaUtils.class);
    private static final String AKKA_NODE_PATH = "akka://%s@%s/user/%s";

    public static String getAkkaWorkerPath(String address, String actorName) {
        return String.format(AKKA_NODE_PATH, "oms", address, actorName);
    }

    public static String getServerActorPath(String serverAddress) {
        if (StringUtils.isEmpty((Object)serverAddress)) {
            return null;
        }
        return String.format(AKKA_NODE_PATH, "oms-server", serverAddress, "server_actor");
    }

    public static boolean reliableTransmit(ActorSelection remote, Object msg) {
        try {
            return AkkaUtils.easyAsk(remote, msg).isSuccess();
        }
        catch (Exception e) {
            log.warn("[PowerTransmitter] transmit {} failed", msg, (Object)e);
            return false;
        }
    }

    public static AskResponse easyAsk(ActorSelection remote, Object msg) {
        try {
            CompletionStage ask = Patterns.ask((ActorSelection)remote, (Object)msg, (Duration)Duration.ofMillis(5000L));
            return (AskResponse)ask.toCompletableFuture().get(5000L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw new PowerJobException((Throwable)e);
        }
    }
}

