/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.tests.markup;

import java.awt.Color;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import tech.grasshopper.pdf.structure.cell.TextLabelCell;
import tech.grasshopper.reporter.optimizer.TextSanitizer;
import tech.grasshopper.reporter.tests.markup.MarkupDisplay;

public class LabelMarkup
extends MarkupDisplay {
    private static final Logger logger = Logger.getLogger(LabelMarkup.class.getName());

    @Override
    public AbstractCell displayDetails() {
        String text = "";
        try {
            text = this.element.text();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unable to retrieve text for label text.");
            return this.errorDisplay("Label text not available.");
        }
        Color textColor = null;
        TextSanitizer textSanitizer = TextSanitizer.builder().font(this.logFont).build();
        try {
            textColor = this.textColor();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Unable to retrieve text color for label text, using default BLACK.");
            return ((TextLabelCell.TextLabelCellBuilder)((TextLabelCell.TextLabelCellBuilder)((TextLabelCell.TextLabelCellBuilder)((TextLabelCell.TextLabelCellBuilder)TextLabelCell.builder().text(textSanitizer.sanitizeText(this.element.text()))).labelColor(Color.BLACK).fontSize(Integer.valueOf(11))).font(this.logFont)).lineSpacing(1.0f)).build();
        }
        return ((TextLabelCell.TextLabelCellBuilder)((TextLabelCell.TextLabelCellBuilder)((TextLabelCell.TextLabelCellBuilder)((TextLabelCell.TextLabelCellBuilder)TextLabelCell.builder().text(textSanitizer.sanitizeText(text))).labelColor(textColor).fontSize(Integer.valueOf(11))).font(this.logFont)).lineSpacing(1.0f)).build();
    }

    private Color textColor() {
        Color color = Color.BLACK;
        String colorName = "";
        if (this.element.className() != null && !this.element.className().isEmpty()) {
            String[] spanClasses = this.element.className().split("\\s+");
            colorName = spanClasses[spanClasses.length - 1].trim();
            if (colorName == null || colorName.equals("")) {
                logger.log(Level.WARNING, "No label color available, using default BLACK.");
                return color;
            }
        } else {
            logger.log(Level.WARNING, "No label color available, using default BLACK.");
            return color;
        }
        try {
            color = (Color)Color.class.getField(colorName.toLowerCase()).get(null);
            if (color == Color.WHITE) {
                color = Color.BLACK;
                logger.log(Level.INFO, "Label color WHITE cannot be displayed properly, using default BLACK.");
            }
        }
        catch (Exception e) {
            color = Color.BLACK;
            logger.log(Level.WARNING, "No matching color name found for label in class java.awt.Color for " + colorName.toUpperCase() + ", using default BLACK.");
        }
        return color;
    }

    protected LabelMarkup(LabelMarkupBuilder<?, ?> b) {
        super(b);
    }

    public static LabelMarkupBuilder<?, ?> builder() {
        return new LabelMarkupBuilderImpl();
    }

    @Override
    public String toString() {
        return "LabelMarkup()";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LabelMarkup)) {
            return false;
        }
        LabelMarkup other = (LabelMarkup)o;
        return other.canEqual(this);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof LabelMarkup;
    }

    @Override
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    private static final class LabelMarkupBuilderImpl
    extends LabelMarkupBuilder<LabelMarkup, LabelMarkupBuilderImpl> {
        private LabelMarkupBuilderImpl() {
        }

        @Override
        protected LabelMarkupBuilderImpl self() {
            return this;
        }

        @Override
        public LabelMarkup build() {
            return new LabelMarkup(this);
        }
    }

    public static abstract class LabelMarkupBuilder<C extends LabelMarkup, B extends LabelMarkupBuilder<C, B>>
    extends MarkupDisplay.MarkupDisplayBuilder<C, B> {
        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "LabelMarkup.LabelMarkupBuilder(super=" + super.toString() + ")";
        }
    }
}

