/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.tests;

import com.aventstack.extentreports.model.Media;
import com.aventstack.extentreports.model.Test;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.settings.VerticalAlignment;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.ImageCell;
import org.vandeseer.easytable.structure.cell.TextCell;
import tech.grasshopper.pdf.annotation.Annotation;
import tech.grasshopper.pdf.annotation.FileAnnotation;
import tech.grasshopper.pdf.structure.cell.TextFileLinkCell;
import tech.grasshopper.pdf.structure.cell.TextLinkCell;
import tech.grasshopper.reporter.annotation.AnnotationStore;
import tech.grasshopper.reporter.medias.Medias;
import tech.grasshopper.reporter.structure.Display;
import tech.grasshopper.reporter.structure.TableCreator;
import tech.grasshopper.reporter.tests.TestIndent;
import tech.grasshopper.reporter.tests.TestMedia;

public class TestMediaDisplay
extends Display
implements TestIndent {
    private static final float MEDIA_WIDTH = 65.0f;
    private static final float MEDIA_HEIGHT = 65.0f;
    private static final float PADDING = 2.0f;
    private static final float GAP_HEIGHT = 10.0f;
    private static final float MEDIA_MAX_MSG_WIDTH = 55.0f;
    protected Test test;
    private Table.TableBuilder tableBuilder;
    private AnnotationStore annotations;

    @Override
    public void display() {
        if (this.test.hasScreenCapture()) {
            this.xlocation += (float)(this.calculateIndent(this.test.getLevel(), this.config.getTestMaxIndentLevel()) * 20);
            this.createTableBuilder();
            this.createMediaRow();
            this.drawTable();
        }
    }

    private void createTableBuilder() {
        this.tableBuilder = Table.builder().horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.MIDDLE);
    }

    private void createMediaRow() {
        boolean maxMedia = false;
        Row.RowBuilder rowBuilder = Row.builder();
        List medias = this.test.getMedia();
        int mediaCount = 6 - this.calculateIndent(this.test.getLevel(), this.config.getTestMaxIndentLevel());
        float plusWidth = 15.0f;
        if (medias.size() > mediaCount) {
            medias = medias.subList(0, mediaCount);
            maxMedia = true;
        }
        if (this.config.isDisplayExpandedMedia()) {
            this.tableBuilder.addColumnsOfWidth(new float[]{plusWidth});
            Annotation annotation = Annotation.builder().id(this.test.getId()).build();
            this.annotations.addTestMediaAnnotation(annotation);
            rowBuilder.add((AbstractCell)((TextLinkCell.TextLinkCellBuilder)((TextLinkCell.TextLinkCellBuilder)((TextLinkCell.TextLinkCellBuilder)((TextLinkCell.TextLinkCellBuilder)((TextLinkCell.TextLinkCellBuilder)((TextLinkCell.TextLinkCellBuilder)((TextLinkCell.TextLinkCellBuilder)((TextLinkCell.TextLinkCellBuilder)TextLinkCell.builder().text("+")).annotation(annotation).font(this.reportFont.getRegularFont())).fontSize(Integer.valueOf(15))).textColor(Color.RED)).showLine(false).padding(2.0f)).borderWidth(0.0f)).verticalAlignment(VerticalAlignment.TOP)).horizontalAlignment(HorizontalAlignment.CENTER)).build());
            for (Media media : medias) {
                this.tableBuilder.addColumnsOfWidth(new float[]{65.0f});
                rowBuilder.add((AbstractCell)((TestMedia)((TestMedia.TestMediaBuilder)((TestMedia.TestMediaBuilder)((Medias.MediasBuilder)((TestMedia.TestMediaBuilder)((TestMedia.TestMediaBuilder)((TestMedia.TestMediaBuilder)TestMedia.builder().media(media)).document(this.document)).width(65.0f)).height(65.0f)).padding(2.0f)).locations(this.config.getMediaFolders())).build()).createImageCell());
            }
        } else {
            for (Media media : medias) {
                this.tableBuilder.addColumnsOfWidth(new float[]{plusWidth, 65.0f});
                Medias testMedia = ((TestMedia.TestMediaBuilder)((Medias.MediasBuilder)((TestMedia.TestMediaBuilder)((TestMedia.TestMediaBuilder)((TestMedia.TestMediaBuilder)((TestMedia.TestMediaBuilder)TestMedia.builder().media(media)).document(this.document)).padding(2.0f)).width(65.0f)).height(65.0f)).locations(this.config.getMediaFolders())).build();
                ImageCell image = ((TestMedia)testMedia).createImageCell();
                boolean imageAbsent = testMedia.isImageNotAvailable();
                if (imageAbsent) {
                    rowBuilder.add((AbstractCell)TextCell.builder().text(" ").build()).add((AbstractCell)image).build();
                    continue;
                }
                ArrayList<FileAnnotation> fileAnnotations = new ArrayList<FileAnnotation>();
                fileAnnotations.add(FileAnnotation.builder().text(" ").link(media.getResolvedPath()).build());
                rowBuilder.add((AbstractCell)((TextFileLinkCell.TextFileLinkCellBuilder)((TextFileLinkCell.TextFileLinkCellBuilder)((TextFileLinkCell.TextFileLinkCellBuilder)TextFileLinkCell.builder().text(" ")).annotations(fileAnnotations).verticalAlignment(VerticalAlignment.TOP)).horizontalAlignment(HorizontalAlignment.CENTER)).build()).add((AbstractCell)image).build();
                this.annotations.addTestMediaFileAnnotation((FileAnnotation)fileAnnotations.get(0));
            }
        }
        if (maxMedia) {
            this.tableBuilder.addColumnsOfWidth(new float[]{55.0f});
            rowBuilder.add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().text("Only first " + mediaCount + " medias are shown.").font(this.reportFont.getRegularFont())).fontSize(Integer.valueOf(10))).textColor(Color.RED)).verticalAlignment(VerticalAlignment.TOP)).wordBreak(Boolean.valueOf(true))).build());
        }
        this.tableBuilder.addRow(rowBuilder.build());
    }

    private void drawTable() {
        TableCreator table = TableCreator.builder().tableBuilder(this.tableBuilder).document(this.document).startX(this.xlocation).startY(this.ylocation).repeatRows(0).build();
        table.displayTable();
        this.ylocation = table.getFinalY() - 10.0f;
    }

    protected TestMediaDisplay(TestMediaDisplayBuilder<?, ?> b) {
        super(b);
        this.test = ((TestMediaDisplayBuilder)b).test;
        this.tableBuilder = ((TestMediaDisplayBuilder)b).tableBuilder;
        this.annotations = ((TestMediaDisplayBuilder)b).annotations;
    }

    public static TestMediaDisplayBuilder<?, ?> builder() {
        return new TestMediaDisplayBuilderImpl();
    }

    public Test getTest() {
        return this.test;
    }

    public Table.TableBuilder getTableBuilder() {
        return this.tableBuilder;
    }

    public AnnotationStore getAnnotations() {
        return this.annotations;
    }

    public void setTest(Test test) {
        this.test = test;
    }

    public void setTableBuilder(Table.TableBuilder tableBuilder) {
        this.tableBuilder = tableBuilder;
    }

    public void setAnnotations(AnnotationStore annotations) {
        this.annotations = annotations;
    }

    @Override
    public String toString() {
        return "TestMediaDisplay(test=" + this.getTest() + ", tableBuilder=" + this.getTableBuilder() + ", annotations=" + this.getAnnotations() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestMediaDisplay)) {
            return false;
        }
        TestMediaDisplay other = (TestMediaDisplay)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Test this$test = this.getTest();
        Test other$test = other.getTest();
        if (this$test == null ? other$test != null : !this$test.equals(other$test)) {
            return false;
        }
        Table.TableBuilder this$tableBuilder = this.getTableBuilder();
        Table.TableBuilder other$tableBuilder = other.getTableBuilder();
        if (this$tableBuilder == null ? other$tableBuilder != null : !this$tableBuilder.equals(other$tableBuilder)) {
            return false;
        }
        AnnotationStore this$annotations = this.getAnnotations();
        AnnotationStore other$annotations = other.getAnnotations();
        return !(this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TestMediaDisplay;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Test $test = this.getTest();
        result = result * 59 + ($test == null ? 43 : $test.hashCode());
        Table.TableBuilder $tableBuilder = this.getTableBuilder();
        result = result * 59 + ($tableBuilder == null ? 43 : $tableBuilder.hashCode());
        AnnotationStore $annotations = this.getAnnotations();
        result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
        return result;
    }

    private static final class TestMediaDisplayBuilderImpl
    extends TestMediaDisplayBuilder<TestMediaDisplay, TestMediaDisplayBuilderImpl> {
        private TestMediaDisplayBuilderImpl() {
        }

        @Override
        protected TestMediaDisplayBuilderImpl self() {
            return this;
        }

        @Override
        public TestMediaDisplay build() {
            return new TestMediaDisplay(this);
        }
    }

    public static abstract class TestMediaDisplayBuilder<C extends TestMediaDisplay, B extends TestMediaDisplayBuilder<C, B>>
    extends Display.DisplayBuilder<C, B> {
        private Test test;
        private Table.TableBuilder tableBuilder;
        private AnnotationStore annotations;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B test(Test test) {
            this.test = test;
            return (B)this.self();
        }

        public B tableBuilder(Table.TableBuilder tableBuilder) {
            this.tableBuilder = tableBuilder;
            return (B)this.self();
        }

        public B annotations(AnnotationStore annotations) {
            this.annotations = annotations;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "TestMediaDisplay.TestMediaDisplayBuilder(super=" + super.toString() + ", test=" + this.test + ", tableBuilder=" + this.tableBuilder + ", annotations=" + this.annotations + ")";
        }
    }
}

