/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.optimizer;

import org.apache.pdfbox.pdmodel.font.PDFont;

public class TextSanitizer {
    private PDFont font;
    private String replaceBy;

    public String sanitizeText(String text) {
        StringBuffer strBuf = new StringBuffer();
        try {
            this.font.encode(text);
            return text;
        }
        catch (Exception e) {
            char[] chars;
            char[] cArray = chars = text.toCharArray();
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                Character character = Character.valueOf(cArray[i]);
                try {
                    if (character.equals(Character.valueOf('\t'))) continue;
                    if (character.equals(Character.valueOf('\r')) || character.equals(Character.valueOf('\n'))) {
                        strBuf.append(character);
                        continue;
                    }
                    this.font.encode(character.toString());
                    strBuf.append(character);
                    continue;
                }
                catch (Exception ex) {
                    strBuf.append(this.replaceBy);
                }
            }
            return strBuf.toString();
        }
    }

    private static String $default$replaceBy() {
        return "?";
    }

    TextSanitizer(PDFont font, String replaceBy) {
        this.font = font;
        this.replaceBy = replaceBy;
    }

    public static TextSanitizerBuilder builder() {
        return new TextSanitizerBuilder();
    }

    public PDFont getFont() {
        return this.font;
    }

    public String getReplaceBy() {
        return this.replaceBy;
    }

    public void setFont(PDFont font) {
        this.font = font;
    }

    public void setReplaceBy(String replaceBy) {
        this.replaceBy = replaceBy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextSanitizer)) {
            return false;
        }
        TextSanitizer other = (TextSanitizer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PDFont this$font = this.getFont();
        PDFont other$font = other.getFont();
        if (this$font == null ? other$font != null : !this$font.equals(other$font)) {
            return false;
        }
        String this$replaceBy = this.getReplaceBy();
        String other$replaceBy = other.getReplaceBy();
        return !(this$replaceBy == null ? other$replaceBy != null : !this$replaceBy.equals(other$replaceBy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TextSanitizer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PDFont $font = this.getFont();
        result = result * 59 + ($font == null ? 43 : $font.hashCode());
        String $replaceBy = this.getReplaceBy();
        result = result * 59 + ($replaceBy == null ? 43 : $replaceBy.hashCode());
        return result;
    }

    public String toString() {
        return "TextSanitizer(font=" + this.getFont() + ", replaceBy=" + this.getReplaceBy() + ")";
    }

    public static class TextSanitizerBuilder {
        private PDFont font;
        private boolean replaceBy$set;
        private String replaceBy$value;

        TextSanitizerBuilder() {
        }

        public TextSanitizerBuilder font(PDFont font) {
            this.font = font;
            return this;
        }

        public TextSanitizerBuilder replaceBy(String replaceBy) {
            this.replaceBy$value = replaceBy;
            this.replaceBy$set = true;
            return this;
        }

        public TextSanitizer build() {
            String replaceBy$value = this.replaceBy$value;
            if (!this.replaceBy$set) {
                replaceBy$value = TextSanitizer.$default$replaceBy();
            }
            return new TextSanitizer(this.font, replaceBy$value);
        }

        public String toString() {
            return "TextSanitizer.TextSanitizerBuilder(font=" + this.font + ", replaceBy$value=" + this.replaceBy$value + ")";
        }
    }
}

