/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.header;

import java.awt.Color;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import tech.grasshopper.reporter.component.Component;
import tech.grasshopper.reporter.component.text.Text;
import tech.grasshopper.reporter.component.text.TextComponent;
import tech.grasshopper.reporter.font.ReportFont;

public class PageHeader {
    private static final Logger logger = Logger.getLogger(PageHeader.class.getName());
    public static final String ATTRIBUTE_SUMMARY_SECTION = "ATTRIBUTE SUMMARY";
    public static final String TEST_DETAILS_SECTION = "TEST DETAILS";
    public static final String ATTRIBUTE_DETAILS_SECTION = "ATTRIBUTE DETAILS";
    public static final String EXPANDED_MEDIA_SECTION = "EXPANDED MEDIA";
    private final Map<String, Integer> sectionPageNumberMap = new LinkedHashMap<String, Integer>();

    public void addSectionPageData(String pageTitle, int pageNo) {
        this.sectionPageNumberMap.put(pageTitle, pageNo);
    }

    public void processHeader(PDDocument document, ReportFont reportFont) {
        if (this.sectionPageNumberMap.isEmpty()) {
            return;
        }
        String sectionName = "";
        int startPageNum = -1;
        for (Map.Entry<String, Integer> entry : this.sectionPageNumberMap.entrySet()) {
            if (startPageNum == -1) {
                sectionName = entry.getKey();
                startPageNum = entry.getValue();
                continue;
            }
            this.createTitleAndNumber(document, reportFont, startPageNum, entry.getValue(), sectionName);
            sectionName = entry.getKey();
            startPageNum = entry.getValue();
        }
        this.createTitleAndNumber(document, reportFont, startPageNum, document.getNumberOfPages(), sectionName);
    }

    private void createTitleAndNumber(PDDocument document, ReportFont reportFont, int startPageNum, int endPageNum, String sectionName) {
        for (int i = startPageNum; i < endPageNum; ++i) {
            PDPage page = document.getPage(i);
            try (PDPageContentStream content = new PDPageContentStream(document, page, PDPageContentStream.AppendMode.APPEND, true);){
                Text pageTitle = Text.builder().textColor(Color.LIGHT_GRAY).xlocation(60.0f).font(reportFont.getItalicFont()).ylocation(page.getMediaBox().getHeight() - 40.0f).text(sectionName).build();
                ((TextComponent)((TextComponent.TextComponentBuilder)((Component.ComponentBuilder)TextComponent.builder().text(pageTitle)).content(content)).build()).display();
                Text pageNumber = Text.builder().textColor(Color.LIGHT_GRAY).xlocation(page.getMediaBox().getWidth() - 90.0f).font(reportFont.getItalicFont()).ylocation(page.getMediaBox().getHeight() - 40.0f).text("-- " + (i + 1) + " --").build();
                ((TextComponent)((TextComponent.TextComponentBuilder)((Component.ComponentBuilder)TextComponent.builder().text(pageNumber)).content(content)).build()).display();
                continue;
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Unable to add page title and\\or number", e);
            }
        }
    }
}

