/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.expanded;

import com.aventstack.extentreports.model.Log;
import com.aventstack.extentreports.model.Test;
import java.util.ArrayList;
import java.util.List;
import tech.grasshopper.reporter.expanded.ExpandedMediaDisplay;
import tech.grasshopper.reporter.header.PageHeaderAware;
import tech.grasshopper.reporter.structure.Display;
import tech.grasshopper.reporter.structure.Section;

public class MediaSummary
extends Section
implements PageHeaderAware {
    protected float yLocation;

    @Override
    public void createSection() {
        List<Test> allTests = this.collectRelevantTests();
        if (!this.checkDataValidity(allTests)) {
            return;
        }
        this.pageHeaderDetails();
        this.createPage();
        for (Test test : allTests) {
            boolean containsMedia = this.doesTestContainMedia(test);
            if (!containsMedia) continue;
            Display expandedMediaDisplay = ((ExpandedMediaDisplay.ExpandedMediaDisplayBuilder)((Display.DisplayBuilder)((ExpandedMediaDisplay.ExpandedMediaDisplayBuilder)((ExpandedMediaDisplay.ExpandedMediaDisplayBuilder)((ExpandedMediaDisplay.ExpandedMediaDisplayBuilder)((ExpandedMediaDisplay.ExpandedMediaDisplayBuilder)ExpandedMediaDisplay.builder().document(this.document)).reportFont(this.reportFont)).config(this.config)).test(test)).annotations(this.annotations)).ylocation(this.yLocation)).build();
            ((ExpandedMediaDisplay)expandedMediaDisplay).display();
            this.createMediaDestination((ExpandedMediaDisplay)expandedMediaDisplay);
            this.yLocation = expandedMediaDisplay.getYlocation();
        }
    }

    protected void createMediaDestination(ExpandedMediaDisplay expandedMediaDisplay) {
        this.destinations.addTestMediaDestination(expandedMediaDisplay.createDestination());
    }

    @Override
    public String getSectionTitle() {
        return "EXPANDED MEDIA";
    }

    protected List<Test> collectRelevantTests() {
        ArrayList<Test> tests = new ArrayList<Test>();
        this.report.getTestList().forEach(t -> {
            tests.add((Test)t);
            this.collectTestNodes((Test)t, (List<Test>)tests);
        });
        return tests;
    }

    protected boolean doesTestContainMedia(Test test) {
        if (!test.getMedia().isEmpty()) {
            return true;
        }
        for (Log log : test.getLogs()) {
            if (!log.hasMedia()) continue;
            return true;
        }
        return false;
    }

    protected boolean checkDataValidity(List<Test> allTests) {
        for (Test test : allTests) {
            if (!this.doesTestContainMedia(test)) continue;
            return true;
        }
        return false;
    }

    protected void collectTestNodes(Test test, List<Test> tests) {
        test.getChildren().forEach(t -> {
            tests.add((Test)t);
            this.collectTestNodes((Test)t, tests);
        });
    }

    private static float $default$yLocation() {
        return 790.0f;
    }

    protected MediaSummary(MediaSummaryBuilder<?, ?> b) {
        super(b);
        this.yLocation = ((MediaSummaryBuilder)b).yLocation$set ? ((MediaSummaryBuilder)b).yLocation$value : MediaSummary.$default$yLocation();
    }

    public static MediaSummaryBuilder<?, ?> builder() {
        return new MediaSummaryBuilderImpl();
    }

    public float getYLocation() {
        return this.yLocation;
    }

    public void setYLocation(float yLocation) {
        this.yLocation = yLocation;
    }

    @Override
    public String toString() {
        return "MediaSummary(yLocation=" + this.getYLocation() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MediaSummary)) {
            return false;
        }
        MediaSummary other = (MediaSummary)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Float.compare(this.getYLocation(), other.getYLocation()) == 0;
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MediaSummary;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getYLocation());
        return result;
    }

    private static final class MediaSummaryBuilderImpl
    extends MediaSummaryBuilder<MediaSummary, MediaSummaryBuilderImpl> {
        private MediaSummaryBuilderImpl() {
        }

        @Override
        protected MediaSummaryBuilderImpl self() {
            return this;
        }

        @Override
        public MediaSummary build() {
            return new MediaSummary(this);
        }
    }

    public static abstract class MediaSummaryBuilder<C extends MediaSummary, B extends MediaSummaryBuilder<C, B>>
    extends Section.SectionBuilder<C, B> {
        private boolean yLocation$set;
        private float yLocation$value;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B yLocation(float yLocation) {
            this.yLocation$value = yLocation;
            this.yLocation$set = true;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "MediaSummary.MediaSummaryBuilder(super=" + super.toString() + ", yLocation$value=" + this.yLocation$value + ")";
        }
    }
}

