/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.expanded;

import com.aventstack.extentreports.gherkin.model.ScenarioOutline;
import com.aventstack.extentreports.model.Log;
import com.aventstack.extentreports.model.Test;
import java.util.ArrayList;
import java.util.List;
import tech.grasshopper.reporter.expanded.ExpandedMediaDisplay;
import tech.grasshopper.reporter.expanded.MediaSummary;
import tech.grasshopper.reporter.structure.Display;

public class BDDMediaSummary
extends MediaSummary {
    @Override
    public void createSection() {
        List<Test> allTests = this.collectRelevantTests();
        if (!this.checkDataValidity(allTests)) {
            return;
        }
        this.pageHeaderDetails();
        this.createPage();
        for (Test test : allTests) {
            boolean containsMedia = this.doesTestContainMedia(test);
            if (!containsMedia) continue;
            Display expandedMediaDisplay = ((ExpandedMediaDisplay.ExpandedMediaDisplayBuilder)((Display.DisplayBuilder)((ExpandedMediaDisplay.ExpandedMediaDisplayBuilder)((ExpandedMediaDisplay.ExpandedMediaDisplayBuilder)((ExpandedMediaDisplay.ExpandedMediaDisplayBuilder)((ExpandedMediaDisplay.ExpandedMediaDisplayBuilder)ExpandedMediaDisplay.builder().document(this.document)).reportFont(this.reportFont)).config(this.config)).test(test)).annotations(this.annotations)).ylocation(this.yLocation)).build();
            ((ExpandedMediaDisplay)expandedMediaDisplay).display();
            this.createMediaDestination((ExpandedMediaDisplay)expandedMediaDisplay);
            this.yLocation = expandedMediaDisplay.getYlocation();
        }
    }

    @Override
    protected List<Test> collectRelevantTests() {
        ArrayList<Test> tests = new ArrayList<Test>();
        this.report.getTestList().forEach(t0 -> t0.getChildren().forEach(t1 -> {
            if (t1.getBddType() == ScenarioOutline.class) {
                t1.getChildren().forEach(t2 -> tests.addAll(t2.getChildren()));
            } else {
                tests.addAll(t1.getChildren());
            }
        }));
        return tests;
    }

    @Override
    protected boolean doesTestContainMedia(Test test) {
        for (Log log : test.getLogs()) {
            if (!log.hasMedia()) continue;
            return true;
        }
        return false;
    }

    protected BDDMediaSummary(BDDMediaSummaryBuilder<?, ?> b) {
        super((MediaSummary.MediaSummaryBuilder<?, ?>)b);
    }

    public static BDDMediaSummaryBuilder<?, ?> builder() {
        return new BDDMediaSummaryBuilderImpl();
    }

    @Override
    public String toString() {
        return "BDDMediaSummary()";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BDDMediaSummary)) {
            return false;
        }
        BDDMediaSummary other = (BDDMediaSummary)o;
        return other.canEqual(this);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BDDMediaSummary;
    }

    @Override
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    private static final class BDDMediaSummaryBuilderImpl
    extends BDDMediaSummaryBuilder<BDDMediaSummary, BDDMediaSummaryBuilderImpl> {
        private BDDMediaSummaryBuilderImpl() {
        }

        @Override
        protected BDDMediaSummaryBuilderImpl self() {
            return this;
        }

        @Override
        public BDDMediaSummary build() {
            return new BDDMediaSummary(this);
        }
    }

    public static abstract class BDDMediaSummaryBuilder<C extends BDDMediaSummary, B extends BDDMediaSummaryBuilder<C, B>>
    extends MediaSummary.MediaSummaryBuilder<C, B> {
        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "BDDMediaSummary.BDDMediaSummaryBuilder(super=" + super.toString() + ")";
        }
    }
}

