/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.dashboard.statistics;

import com.aventstack.extentreports.Status;
import java.awt.Color;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import tech.grasshopper.reporter.component.Component;
import tech.grasshopper.reporter.component.decorator.BackgroundDecorator;
import tech.grasshopper.reporter.component.decorator.BorderDecorator;
import tech.grasshopper.reporter.component.text.MultipleTextComponent;
import tech.grasshopper.reporter.component.text.Text;
import tech.grasshopper.reporter.dashboard.AnalysisStrategyDisplay;
import tech.grasshopper.reporter.optimizer.TextLengthOptimizer;
import tech.grasshopper.reporter.structure.Display;
import tech.grasshopper.reporter.util.DateUtil;

public class DashboardStatisticsDisplay
extends Display {
    private static final int TEST_START_X_LOCATION = 50;
    private static final int TEST_END_X_LOCATION = 210;
    private static final int TEST_DURATION_X_LOCATION = 370;
    private static final int TEST_PASSED_X_LOCATION = 530;
    private static final int TEST_FAILED_X_LOCATION = 665;
    private static final int FIRST_ROW_Y_LOCATION = 465;
    private static final int SECOND_ROW_Y_LOCATION = 440;
    private static final int CONTAINER_PADDING = 10;
    private static final int CONTAINER_WIDTH = 150;
    private static final int CONTAINER_PASS_FAIL_WIDTH = 125;
    private static final int CONTAINER_HEIGHT = 55;
    private static final int CONTAINER_Y_BOTTOM = 430;
    private static final int TITLE_FONT_SIZE = 13;
    private static final int DATE_FONT_SIZE = 17;
    private static final int DATE_MILLIS_FONT_SIZE = 14;
    private static final int DURATION_PASS_FAIL_FONT_SIZE = 20;
    private AnalysisStrategyDisplay strategyDisplay;

    @Override
    public void display() {
        this.strategyDisplay = AnalysisStrategyDisplay.displaySettings(this.report);
        this.createTestStartedTextBox();
        this.createTestFinishedTextBox();
        this.createTestDurationTextBox();
        this.createFirstLevelPassedTextBox();
        this.createFirstLevelFailedTextBox();
    }

    private void createTestStartedTextBox() {
        LocalDateTime start = DateUtil.convertToLocalDateTimeFromDate(this.report.getStartTime());
        List<Text> texts = this.createTestTexts(start, "Started : ", this.config.getStartTimesColor(), 50.0f);
        this.createTestStatisticsTextBox(texts, 50.0f, 150.0f);
    }

    private void createTestFinishedTextBox() {
        LocalDateTime end = DateUtil.convertToLocalDateTimeFromDate(this.report.getEndTime());
        List<Text> texts = this.createTestTexts(end, "Finished : ", this.config.getFinishTimesColor(), 210.0f);
        this.createTestStatisticsTextBox(texts, 210.0f, 150.0f);
    }

    private void createTestDurationTextBox() {
        LocalDateTime start = DateUtil.convertToLocalDateTimeFromDate(this.report.getStartTime());
        LocalDateTime end = DateUtil.convertToLocalDateTimeFromDate(this.report.getEndTime());
        List<Text> texts = this.createDurationPassFailTexts("Duration : ", DateUtil.durationValue(start, end), this.config.getDurationColor(), 370.0f);
        this.createTestStatisticsTextBox(texts, 370.0f, 150.0f);
    }

    private void createFirstLevelPassedTextBox() {
        List<Text> texts = this.createDurationPassFailTexts(this.strategyDisplay.firstLevelText() + " Passed : ", String.valueOf(this.report.getStats().getParent().get(Status.PASS)), this.config.getPassCountColor(), 530.0f);
        this.createTestStatisticsTextBox(texts, 530.0f, 125.0f);
    }

    private void createFirstLevelFailedTextBox() {
        List<Text> texts = this.createDurationPassFailTexts(this.strategyDisplay.firstLevelText() + " Failed : ", String.valueOf(this.report.getStats().getParent().get(Status.FAIL)), this.config.getFailCountColor(), 665.0f);
        this.createTestStatisticsTextBox(texts, 665.0f, 125.0f);
    }

    private List<Text> createDurationPassFailTexts(String title, String value, Color valueColor, float xLocation) {
        ArrayList<Text> texts = new ArrayList<Text>();
        texts.add(Text.builder().fontSize(13.0f).font(this.reportFont.getItalicFont()).textColor(Color.BLACK).xlocation(xLocation + 10.0f).ylocation(465.0f).text(title).build());
        texts.add(Text.builder().fontSize(20.0f).font(this.reportFont.getBoldItalicFont()).textColor(valueColor).xlocation(xLocation + 10.0f).ylocation(440.0f).text(value).build());
        return texts;
    }

    private List<Text> createTestTexts(LocalDateTime datetime, String title, Color dateTimeColor, float xLocation) {
        ArrayList<Text> texts = new ArrayList<Text>();
        texts.add(Text.builder().fontSize(13.0f).font(this.reportFont.getItalicFont()).textColor(Color.BLACK).xlocation(xLocation + 10.0f).ylocation(465.0f).text(title).build());
        int titleWidth = TextLengthOptimizer.builder().font(this.reportFont.getItalicFont()).fontsize(13).build().textWidth(title);
        texts.add(Text.builder().fontSize(17.0f).font(this.reportFont.getBoldItalicFont()).textColor(dateTimeColor).xlocation(xLocation + 10.0f + (float)titleWidth + 2.0f).ylocation(465.0f).text(DateUtil.formatDateWOYear(datetime)).build());
        texts.add(Text.builder().fontSize(17.0f).font(this.reportFont.getBoldItalicFont()).textColor(dateTimeColor).xlocation(xLocation + 10.0f).ylocation(440.0f).text(DateUtil.formatTime(datetime)).build());
        int timeWidth = TextLengthOptimizer.builder().font(this.reportFont.getBoldItalicFont()).fontsize(17).build().textWidth(DateUtil.formatTime(datetime));
        texts.add(Text.builder().fontSize(14.0f).font(this.reportFont.getBoldItalicFont()).textColor(dateTimeColor).xlocation(xLocation + 10.0f + (float)timeWidth + 1.0f).ylocation(440.0f).text("." + DateUtil.formatTimeMillis(datetime)).build());
        int millisWidth = TextLengthOptimizer.builder().font(this.reportFont.getBoldItalicFont()).fontsize(14).build().textWidth("." + DateUtil.formatTimeMillis(datetime));
        texts.add(Text.builder().fontSize(17.0f).font(this.reportFont.getBoldItalicFont()).textColor(dateTimeColor).xlocation(xLocation + 10.0f + (float)timeWidth + 1.0f + (float)millisWidth + 5.0f).ylocation(440.0f).text(DateUtil.formatAMPM(datetime)).build());
        return texts;
    }

    private void createTestStatisticsTextBox(List<Text> texts, float xBoxLocation, float boxWidth) {
        Component component = ((MultipleTextComponent.MultipleTextComponentBuilder)((MultipleTextComponent.MultipleTextComponentBuilder)MultipleTextComponent.builder().content(this.content)).texts(texts)).build();
        component = ((BackgroundDecorator.BackgroundDecoratorBuilder)((BackgroundDecorator.BackgroundDecoratorBuilder)((BackgroundDecorator.BackgroundDecoratorBuilder)((BackgroundDecorator.BackgroundDecoratorBuilder)((BackgroundDecorator.BackgroundDecoratorBuilder)((BackgroundDecorator.BackgroundDecoratorBuilder)((BackgroundDecorator.BackgroundDecoratorBuilder)BackgroundDecorator.builder().component(component)).content(this.content)).containerColor(Color.WHITE)).xContainerBottomLeft(xBoxLocation)).yContainerBottomLeft(430.0f)).containerWidth(boxWidth)).containerHeight(55.0f)).build();
        component = ((BorderDecorator.BorderDecoratorBuilder)((BorderDecorator.BorderDecoratorBuilder)((BorderDecorator.BorderDecoratorBuilder)((BorderDecorator.BorderDecoratorBuilder)((BorderDecorator.BorderDecoratorBuilder)((BorderDecorator.BorderDecoratorBuilder)BorderDecorator.builder().component(component)).content(this.content)).xContainerBottomLeft(xBoxLocation)).yContainerBottomLeft(430.0f)).containerWidth(boxWidth)).containerHeight(55.0f)).build();
        component.display();
    }

    protected DashboardStatisticsDisplay(DashboardStatisticsDisplayBuilder<?, ?> b) {
        super(b);
        this.strategyDisplay = ((DashboardStatisticsDisplayBuilder)b).strategyDisplay;
    }

    public static DashboardStatisticsDisplayBuilder<?, ?> builder() {
        return new DashboardStatisticsDisplayBuilderImpl();
    }

    public AnalysisStrategyDisplay getStrategyDisplay() {
        return this.strategyDisplay;
    }

    public void setStrategyDisplay(AnalysisStrategyDisplay strategyDisplay) {
        this.strategyDisplay = strategyDisplay;
    }

    @Override
    public String toString() {
        return "DashboardStatisticsDisplay(strategyDisplay=" + (Object)((Object)this.getStrategyDisplay()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DashboardStatisticsDisplay)) {
            return false;
        }
        DashboardStatisticsDisplay other = (DashboardStatisticsDisplay)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AnalysisStrategyDisplay this$strategyDisplay = this.getStrategyDisplay();
        AnalysisStrategyDisplay other$strategyDisplay = other.getStrategyDisplay();
        return !(this$strategyDisplay == null ? other$strategyDisplay != null : !((Object)((Object)this$strategyDisplay)).equals((Object)other$strategyDisplay));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DashboardStatisticsDisplay;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AnalysisStrategyDisplay $strategyDisplay = this.getStrategyDisplay();
        result = result * 59 + ($strategyDisplay == null ? 43 : ((Object)((Object)$strategyDisplay)).hashCode());
        return result;
    }

    private static final class DashboardStatisticsDisplayBuilderImpl
    extends DashboardStatisticsDisplayBuilder<DashboardStatisticsDisplay, DashboardStatisticsDisplayBuilderImpl> {
        private DashboardStatisticsDisplayBuilderImpl() {
        }

        @Override
        protected DashboardStatisticsDisplayBuilderImpl self() {
            return this;
        }

        @Override
        public DashboardStatisticsDisplay build() {
            return new DashboardStatisticsDisplay(this);
        }
    }

    public static abstract class DashboardStatisticsDisplayBuilder<C extends DashboardStatisticsDisplay, B extends DashboardStatisticsDisplayBuilder<C, B>>
    extends Display.DisplayBuilder<C, B> {
        private AnalysisStrategyDisplay strategyDisplay;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B strategyDisplay(AnalysisStrategyDisplay strategyDisplay) {
            this.strategyDisplay = strategyDisplay;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "DashboardStatisticsDisplay.DashboardStatisticsDisplayBuilder(super=" + super.toString() + ", strategyDisplay=" + (Object)((Object)this.strategyDisplay) + ")";
        }
    }
}

