/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.dashboard.legend;

import com.aventstack.extentreports.Status;
import java.awt.Color;
import java.util.Map;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import tech.grasshopper.reporter.component.Component;
import tech.grasshopper.reporter.component.decorator.BackgroundDecorator;
import tech.grasshopper.reporter.component.text.Text;
import tech.grasshopper.reporter.component.text.TextComponent;

public class DashboardChartLegend {
    private float xlocation;
    private float ylocation;
    private float legendGap;
    private float legendWidth;
    private float legendHeight;
    private float legendXShift;
    private float legendYShift;
    private Map<Status, Long> statusData;
    private Map<Status, Color> statusColor;
    private float keyFontSize;
    private PDFont keyFont;
    private float valueFontSize;
    private PDFont valueFont;
    private PDPageContentStream content;

    public void display() {
        for (Map.Entry<Status, Color> entry : this.statusColor.entrySet()) {
            long value = this.statusData.getOrDefault(entry.getKey(), 0L);
            if (value <= 0L) continue;
            this.createLegendKey(entry.getKey().toString(), entry.getValue());
            this.createLegendValue(value);
            this.ylocation -= this.legendGap;
        }
    }

    private void createLegendKey(String legendText, Color legendColor) {
        Text text = Text.builder().fontSize(this.keyFontSize).xlocation(this.xlocation).ylocation(this.ylocation).text(legendText).font(this.keyFont).build();
        Component component = ((TextComponent.TextComponentBuilder)((TextComponent.TextComponentBuilder)TextComponent.builder().content(this.content)).text(text)).build();
        component = ((BackgroundDecorator.BackgroundDecoratorBuilder)((BackgroundDecorator.BackgroundDecoratorBuilder)((BackgroundDecorator.BackgroundDecoratorBuilder)((BackgroundDecorator.BackgroundDecoratorBuilder)((BackgroundDecorator.BackgroundDecoratorBuilder)((BackgroundDecorator.BackgroundDecoratorBuilder)((BackgroundDecorator.BackgroundDecoratorBuilder)BackgroundDecorator.builder().component(component)).content(this.content)).containerColor(legendColor)).xContainerBottomLeft(this.xlocation - this.legendXShift)).yContainerBottomLeft(this.ylocation - this.legendYShift)).containerWidth(this.legendWidth)).containerHeight(this.legendHeight)).build();
        component.display();
    }

    private void createLegendValue(Long legendValue) {
        Text text = Text.builder().fontSize(this.valueFontSize).xlocation(this.xlocation + 65.0f).ylocation(this.ylocation).text(String.valueOf(legendValue)).font(this.valueFont).build();
        Component component = ((TextComponent.TextComponentBuilder)((TextComponent.TextComponentBuilder)TextComponent.builder().content(this.content)).text(text)).build();
        component.display();
    }

    private static float $default$legendGap() {
        return 25.0f;
    }

    private static float $default$legendWidth() {
        return 50.0f;
    }

    private static float $default$legendHeight() {
        return 20.0f;
    }

    private static float $default$legendXShift() {
        return 5.0f;
    }

    private static float $default$legendYShift() {
        return 6.0f;
    }

    private static float $default$keyFontSize() {
        return 11.0f;
    }

    private static float $default$valueFontSize() {
        return 14.0f;
    }

    DashboardChartLegend(float xlocation, float ylocation, float legendGap, float legendWidth, float legendHeight, float legendXShift, float legendYShift, Map<Status, Long> statusData, Map<Status, Color> statusColor, float keyFontSize, PDFont keyFont, float valueFontSize, PDFont valueFont, PDPageContentStream content) {
        this.xlocation = xlocation;
        this.ylocation = ylocation;
        this.legendGap = legendGap;
        this.legendWidth = legendWidth;
        this.legendHeight = legendHeight;
        this.legendXShift = legendXShift;
        this.legendYShift = legendYShift;
        this.statusData = statusData;
        this.statusColor = statusColor;
        this.keyFontSize = keyFontSize;
        this.keyFont = keyFont;
        this.valueFontSize = valueFontSize;
        this.valueFont = valueFont;
        this.content = content;
    }

    public static DashboardChartLegendBuilder builder() {
        return new DashboardChartLegendBuilder();
    }

    public void setXlocation(float xlocation) {
        this.xlocation = xlocation;
    }

    public void setYlocation(float ylocation) {
        this.ylocation = ylocation;
    }

    public void setLegendGap(float legendGap) {
        this.legendGap = legendGap;
    }

    public void setLegendWidth(float legendWidth) {
        this.legendWidth = legendWidth;
    }

    public void setLegendHeight(float legendHeight) {
        this.legendHeight = legendHeight;
    }

    public void setLegendXShift(float legendXShift) {
        this.legendXShift = legendXShift;
    }

    public void setLegendYShift(float legendYShift) {
        this.legendYShift = legendYShift;
    }

    public void setStatusData(Map<Status, Long> statusData) {
        this.statusData = statusData;
    }

    public void setStatusColor(Map<Status, Color> statusColor) {
        this.statusColor = statusColor;
    }

    public void setKeyFontSize(float keyFontSize) {
        this.keyFontSize = keyFontSize;
    }

    public void setKeyFont(PDFont keyFont) {
        this.keyFont = keyFont;
    }

    public void setValueFontSize(float valueFontSize) {
        this.valueFontSize = valueFontSize;
    }

    public void setValueFont(PDFont valueFont) {
        this.valueFont = valueFont;
    }

    public void setContent(PDPageContentStream content) {
        this.content = content;
    }

    public static class DashboardChartLegendBuilder {
        private float xlocation;
        private float ylocation;
        private boolean legendGap$set;
        private float legendGap$value;
        private boolean legendWidth$set;
        private float legendWidth$value;
        private boolean legendHeight$set;
        private float legendHeight$value;
        private boolean legendXShift$set;
        private float legendXShift$value;
        private boolean legendYShift$set;
        private float legendYShift$value;
        private Map<Status, Long> statusData;
        private Map<Status, Color> statusColor;
        private boolean keyFontSize$set;
        private float keyFontSize$value;
        private PDFont keyFont;
        private boolean valueFontSize$set;
        private float valueFontSize$value;
        private PDFont valueFont;
        private PDPageContentStream content;

        DashboardChartLegendBuilder() {
        }

        public DashboardChartLegendBuilder xlocation(float xlocation) {
            this.xlocation = xlocation;
            return this;
        }

        public DashboardChartLegendBuilder ylocation(float ylocation) {
            this.ylocation = ylocation;
            return this;
        }

        public DashboardChartLegendBuilder legendGap(float legendGap) {
            this.legendGap$value = legendGap;
            this.legendGap$set = true;
            return this;
        }

        public DashboardChartLegendBuilder legendWidth(float legendWidth) {
            this.legendWidth$value = legendWidth;
            this.legendWidth$set = true;
            return this;
        }

        public DashboardChartLegendBuilder legendHeight(float legendHeight) {
            this.legendHeight$value = legendHeight;
            this.legendHeight$set = true;
            return this;
        }

        public DashboardChartLegendBuilder legendXShift(float legendXShift) {
            this.legendXShift$value = legendXShift;
            this.legendXShift$set = true;
            return this;
        }

        public DashboardChartLegendBuilder legendYShift(float legendYShift) {
            this.legendYShift$value = legendYShift;
            this.legendYShift$set = true;
            return this;
        }

        public DashboardChartLegendBuilder statusData(Map<Status, Long> statusData) {
            this.statusData = statusData;
            return this;
        }

        public DashboardChartLegendBuilder statusColor(Map<Status, Color> statusColor) {
            this.statusColor = statusColor;
            return this;
        }

        public DashboardChartLegendBuilder keyFontSize(float keyFontSize) {
            this.keyFontSize$value = keyFontSize;
            this.keyFontSize$set = true;
            return this;
        }

        public DashboardChartLegendBuilder keyFont(PDFont keyFont) {
            this.keyFont = keyFont;
            return this;
        }

        public DashboardChartLegendBuilder valueFontSize(float valueFontSize) {
            this.valueFontSize$value = valueFontSize;
            this.valueFontSize$set = true;
            return this;
        }

        public DashboardChartLegendBuilder valueFont(PDFont valueFont) {
            this.valueFont = valueFont;
            return this;
        }

        public DashboardChartLegendBuilder content(PDPageContentStream content) {
            this.content = content;
            return this;
        }

        public DashboardChartLegend build() {
            float legendGap$value = this.legendGap$value;
            if (!this.legendGap$set) {
                legendGap$value = DashboardChartLegend.$default$legendGap();
            }
            float legendWidth$value = this.legendWidth$value;
            if (!this.legendWidth$set) {
                legendWidth$value = DashboardChartLegend.$default$legendWidth();
            }
            float legendHeight$value = this.legendHeight$value;
            if (!this.legendHeight$set) {
                legendHeight$value = DashboardChartLegend.$default$legendHeight();
            }
            float legendXShift$value = this.legendXShift$value;
            if (!this.legendXShift$set) {
                legendXShift$value = DashboardChartLegend.$default$legendXShift();
            }
            float legendYShift$value = this.legendYShift$value;
            if (!this.legendYShift$set) {
                legendYShift$value = DashboardChartLegend.$default$legendYShift();
            }
            float keyFontSize$value = this.keyFontSize$value;
            if (!this.keyFontSize$set) {
                keyFontSize$value = DashboardChartLegend.$default$keyFontSize();
            }
            float valueFontSize$value = this.valueFontSize$value;
            if (!this.valueFontSize$set) {
                valueFontSize$value = DashboardChartLegend.$default$valueFontSize();
            }
            return new DashboardChartLegend(this.xlocation, this.ylocation, legendGap$value, legendWidth$value, legendHeight$value, legendXShift$value, legendYShift$value, this.statusData, this.statusColor, keyFontSize$value, this.keyFont, valueFontSize$value, this.valueFont, this.content);
        }

        public String toString() {
            return "DashboardChartLegend.DashboardChartLegendBuilder(xlocation=" + this.xlocation + ", ylocation=" + this.ylocation + ", legendGap$value=" + this.legendGap$value + ", legendWidth$value=" + this.legendWidth$value + ", legendHeight$value=" + this.legendHeight$value + ", legendXShift$value=" + this.legendXShift$value + ", legendYShift$value=" + this.legendYShift$value + ", statusData=" + this.statusData + ", statusColor=" + this.statusColor + ", keyFontSize$value=" + this.keyFontSize$value + ", keyFont=" + this.keyFont + ", valueFontSize$value=" + this.valueFontSize$value + ", valueFont=" + this.valueFont + ", content=" + this.content + ")";
        }
    }
}

