/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.dashboard.chart;

import com.aventstack.extentreports.Status;
import java.util.Map;
import org.knowm.xchart.PieChart;
import tech.grasshopper.reporter.dashboard.AnalysisStrategyDisplay;
import tech.grasshopper.reporter.dashboard.chart.DashboardChartDonut;
import tech.grasshopper.reporter.dashboard.chart.DashboardChartTitle;
import tech.grasshopper.reporter.structure.Display;

public class DashboardDonutChartDisplay
extends Display {
    private PieChart chart;
    private static final int CHART_TITLE_X_PADDING = 10;
    private static final int CHART_TITLE_Y_LOCATION = 390;
    private static final int CHART_TITLE_FONT_SIZE = 16;
    private static final int CHART_DIMENSION = 170;
    private static final int CHART_Y_LOCATION = 210;
    private AnalysisStrategyDisplay strategyDisplay;

    @Override
    public void display() {
        this.strategyDisplay = AnalysisStrategyDisplay.displaySettings(this.report);
        this.createFirstChartTitle();
        this.createSecondChartTitle();
        this.createThirdChartTitle();
        this.createLogsChartTitle();
        this.createFirstDonutChart();
        this.createSecondDonutChart();
        this.createThirdDonutChart();
        this.createLogsDonutChart();
    }

    private void createTitle(String title, float xLocation) {
        DashboardChartTitle.builder().content(this.content).font(this.reportFont.getItalicFont()).fontSize(16.0f).xlocation(xLocation).ylocation(390.0f).title(title).build().display();
    }

    private void createFirstChartTitle() {
        this.createTitle(this.strategyDisplay.firstLevelText(), this.strategyDisplay.firstLevelChartXLocation() + 10);
    }

    private void createSecondChartTitle() {
        this.createTitle(this.strategyDisplay.secondLevelText(), this.strategyDisplay.secondLevelChartXLocation() + 10);
    }

    private void createThirdChartTitle() {
        this.createTitle(this.strategyDisplay.thirdLevelText(), this.strategyDisplay.thirdLevelChartXLocation() + 10);
    }

    private void createLogsChartTitle() {
        if (this.strategyDisplay.displayLogsChart()) {
            this.createTitle(this.strategyDisplay.logsText(), this.strategyDisplay.logsChartXLocation() + 10);
        }
    }

    private void createDonutChart(Map<Status, Long> data, float xLocation) {
        DashboardChartDonut.builder().content(this.content).document(this.document).config(this.config).width(170).height(170).xlocation(xLocation).ylocation(210.0f).data(data).build().display();
    }

    private void createFirstDonutChart() {
        this.createDonutChart(this.report.getStats().getParent(), this.strategyDisplay.firstLevelChartXLocation());
    }

    private void createSecondDonutChart() {
        this.createDonutChart(this.report.getStats().getChild(), this.strategyDisplay.secondLevelChartXLocation());
    }

    private void createThirdDonutChart() {
        this.createDonutChart(this.report.getStats().getGrandchild(), this.strategyDisplay.thirdLevelChartXLocation());
    }

    private void createLogsDonutChart() {
        if (this.strategyDisplay.displayLogsChart()) {
            this.createDonutChart(this.report.getStats().getLog(), this.strategyDisplay.logsChartXLocation());
        }
    }

    protected DashboardDonutChartDisplay(DashboardDonutChartDisplayBuilder<?, ?> b) {
        super(b);
        this.chart = ((DashboardDonutChartDisplayBuilder)b).chart;
        this.strategyDisplay = ((DashboardDonutChartDisplayBuilder)b).strategyDisplay;
    }

    public static DashboardDonutChartDisplayBuilder<?, ?> builder() {
        return new DashboardDonutChartDisplayBuilderImpl();
    }

    public PieChart getChart() {
        return this.chart;
    }

    public AnalysisStrategyDisplay getStrategyDisplay() {
        return this.strategyDisplay;
    }

    public void setChart(PieChart chart) {
        this.chart = chart;
    }

    public void setStrategyDisplay(AnalysisStrategyDisplay strategyDisplay) {
        this.strategyDisplay = strategyDisplay;
    }

    @Override
    public String toString() {
        return "DashboardDonutChartDisplay(chart=" + this.getChart() + ", strategyDisplay=" + (Object)((Object)this.getStrategyDisplay()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DashboardDonutChartDisplay)) {
            return false;
        }
        DashboardDonutChartDisplay other = (DashboardDonutChartDisplay)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PieChart this$chart = this.getChart();
        PieChart other$chart = other.getChart();
        if (this$chart == null ? other$chart != null : !this$chart.equals(other$chart)) {
            return false;
        }
        AnalysisStrategyDisplay this$strategyDisplay = this.getStrategyDisplay();
        AnalysisStrategyDisplay other$strategyDisplay = other.getStrategyDisplay();
        return !(this$strategyDisplay == null ? other$strategyDisplay != null : !((Object)((Object)this$strategyDisplay)).equals((Object)other$strategyDisplay));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DashboardDonutChartDisplay;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PieChart $chart = this.getChart();
        result = result * 59 + ($chart == null ? 43 : $chart.hashCode());
        AnalysisStrategyDisplay $strategyDisplay = this.getStrategyDisplay();
        result = result * 59 + ($strategyDisplay == null ? 43 : ((Object)((Object)$strategyDisplay)).hashCode());
        return result;
    }

    private static final class DashboardDonutChartDisplayBuilderImpl
    extends DashboardDonutChartDisplayBuilder<DashboardDonutChartDisplay, DashboardDonutChartDisplayBuilderImpl> {
        private DashboardDonutChartDisplayBuilderImpl() {
        }

        @Override
        protected DashboardDonutChartDisplayBuilderImpl self() {
            return this;
        }

        @Override
        public DashboardDonutChartDisplay build() {
            return new DashboardDonutChartDisplay(this);
        }
    }

    public static abstract class DashboardDonutChartDisplayBuilder<C extends DashboardDonutChartDisplay, B extends DashboardDonutChartDisplayBuilder<C, B>>
    extends Display.DisplayBuilder<C, B> {
        private PieChart chart;
        private AnalysisStrategyDisplay strategyDisplay;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B chart(PieChart chart) {
            this.chart = chart;
            return (B)this.self();
        }

        public B strategyDisplay(AnalysisStrategyDisplay strategyDisplay) {
            this.strategyDisplay = strategyDisplay;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "DashboardDonutChartDisplay.DashboardDonutChartDisplayBuilder(super=" + super.toString() + ", chart=" + this.chart + ", strategyDisplay=" + (Object)((Object)this.strategyDisplay) + ")";
        }
    }
}

