/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.dashboard.chart;

import com.aventstack.extentreports.Status;
import java.awt.Color;
import java.util.Map;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.knowm.xchart.PieChart;
import org.knowm.xchart.PieSeries;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.PieStyler;
import org.knowm.xchart.style.Styler;
import tech.grasshopper.reporter.component.chart.ChartDisplayer;
import tech.grasshopper.reporter.config.ExtentPDFReporterConfig;

public class DashboardChartDonut {
    private int width;
    private int height;
    private float xlocation;
    private float ylocation;
    private Map<Status, Long> data;
    private ExtentPDFReporterConfig config;
    private PDDocument document;
    private PDPageContentStream content;

    public void display() {
        PieChart chart = new PieChart(this.width, this.height, Styler.ChartTheme.XChart);
        this.updateChartStyler((PieStyler)chart.getStyler());
        this.updateChartData(chart, this.data);
        ((ChartDisplayer)((ChartDisplayer.ChartDisplayerBuilder)((ChartDisplayer.ChartDisplayerBuilder)((ChartDisplayer.ChartDisplayerBuilder)((ChartDisplayer.ChartDisplayerBuilder)((ChartDisplayer.ChartDisplayerBuilder)ChartDisplayer.builder().document(this.document)).content(this.content)).chart((Chart<?, ?>)chart)).xBottomLeft(this.xlocation)).yBottomLeft(this.ylocation)).build()).display();
    }

    private void updateChartStyler(PieStyler styler) {
        styler.setSeriesColors(new Color[]{this.config.getPassColor(), this.config.getFailColor(), this.config.getSkipColor(), this.config.getWarnColor(), this.config.getInfoColor()});
        styler.setLegendVisible(false);
        styler.setPlotContentSize(0.85);
        styler.setPlotBorderVisible(true);
        styler.setPlotBorderColor(Color.BLACK);
        styler.setChartPadding(1);
        styler.setClockwiseDirectionType(PieStyler.ClockwiseDirectionType.CLOCKWISE);
        styler.setHasAnnotations(false);
        styler.setDefaultSeriesRenderStyle(PieSeries.PieSeriesRenderStyle.Donut);
        styler.setDonutThickness(0.4);
        styler.setSumVisible(true);
        styler.setSumFontSize(20.0f);
        styler.setDecimalPattern("#");
        styler.setChartBackgroundColor(Color.WHITE);
    }

    private void updateChartData(PieChart chart, Map<Status, Long> statusData) {
        chart.addSeries(Status.PASS.toString(), (Number)statusData.getOrDefault(Status.PASS, 0L));
        chart.addSeries(Status.FAIL.toString(), (Number)statusData.getOrDefault(Status.FAIL, 0L));
        chart.addSeries(Status.SKIP.toString(), (Number)statusData.getOrDefault(Status.SKIP, 0L));
        chart.addSeries(Status.WARNING.toString(), (Number)statusData.getOrDefault(Status.WARNING, 0L));
        chart.addSeries(Status.INFO.toString(), (Number)statusData.getOrDefault(Status.INFO, 0L));
    }

    DashboardChartDonut(int width, int height, float xlocation, float ylocation, Map<Status, Long> data, ExtentPDFReporterConfig config, PDDocument document, PDPageContentStream content) {
        this.width = width;
        this.height = height;
        this.xlocation = xlocation;
        this.ylocation = ylocation;
        this.data = data;
        this.config = config;
        this.document = document;
        this.content = content;
    }

    public static DashboardChartDonutBuilder builder() {
        return new DashboardChartDonutBuilder();
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setXlocation(float xlocation) {
        this.xlocation = xlocation;
    }

    public void setYlocation(float ylocation) {
        this.ylocation = ylocation;
    }

    public void setData(Map<Status, Long> data) {
        this.data = data;
    }

    public void setConfig(ExtentPDFReporterConfig config) {
        this.config = config;
    }

    public void setDocument(PDDocument document) {
        this.document = document;
    }

    public void setContent(PDPageContentStream content) {
        this.content = content;
    }

    public static class DashboardChartDonutBuilder {
        private int width;
        private int height;
        private float xlocation;
        private float ylocation;
        private Map<Status, Long> data;
        private ExtentPDFReporterConfig config;
        private PDDocument document;
        private PDPageContentStream content;

        DashboardChartDonutBuilder() {
        }

        public DashboardChartDonutBuilder width(int width) {
            this.width = width;
            return this;
        }

        public DashboardChartDonutBuilder height(int height) {
            this.height = height;
            return this;
        }

        public DashboardChartDonutBuilder xlocation(float xlocation) {
            this.xlocation = xlocation;
            return this;
        }

        public DashboardChartDonutBuilder ylocation(float ylocation) {
            this.ylocation = ylocation;
            return this;
        }

        public DashboardChartDonutBuilder data(Map<Status, Long> data) {
            this.data = data;
            return this;
        }

        public DashboardChartDonutBuilder config(ExtentPDFReporterConfig config) {
            this.config = config;
            return this;
        }

        public DashboardChartDonutBuilder document(PDDocument document) {
            this.document = document;
            return this;
        }

        public DashboardChartDonutBuilder content(PDPageContentStream content) {
            this.content = content;
            return this;
        }

        public DashboardChartDonut build() {
            return new DashboardChartDonut(this.width, this.height, this.xlocation, this.ylocation, this.data, this.config, this.document, this.content);
        }

        public String toString() {
            return "DashboardChartDonut.DashboardChartDonutBuilder(width=" + this.width + ", height=" + this.height + ", xlocation=" + this.xlocation + ", ylocation=" + this.ylocation + ", data=" + this.data + ", config=" + (Object)((Object)this.config) + ", document=" + this.document + ", content=" + this.content + ")";
        }
    }
}

