/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.reporter.dashboard;

import com.aventstack.extentreports.model.Report;

public enum AnalysisStrategyDisplay {
    BDD{

        @Override
        public String firstLevelText() {
            return "Features";
        }

        @Override
        public String secondLevelText() {
            return "Scenarios";
        }

        @Override
        public String thirdLevelText() {
            return "Steps";
        }

        @Override
        public String logsText() {
            return "";
        }

        @Override
        public boolean displayLogsChart() {
            return false;
        }

        @Override
        public int firstLevelChartXLocation() {
            return 50;
        }

        @Override
        public int secondLevelChartXLocation() {
            return 300;
        }

        @Override
        public int thirdLevelChartXLocation() {
            return 550;
        }

        @Override
        public int logsChartXLocation() {
            return 0;
        }

        @Override
        public int chartWidth() {
            return 235;
        }
    }
    ,
    TEST{

        @Override
        public String firstLevelText() {
            return "Tests";
        }

        @Override
        public String secondLevelText() {
            return "Steps";
        }
    }
    ,
    CLASS{

        @Override
        public String firstLevelText() {
            return "Class";
        }

        @Override
        public String secondLevelText() {
            return "Methods";
        }
    }
    ,
    SUITE{

        @Override
        public String firstLevelText() {
            return "Suites";
        }

        @Override
        public String secondLevelText() {
            return "Class";
        }

        @Override
        public String thirdLevelText() {
            return "Tests";
        }
    };


    public abstract String firstLevelText();

    public abstract String secondLevelText();

    public String thirdLevelText() {
        return "";
    }

    public boolean displayLogsChart() {
        return true;
    }

    public String logsText() {
        return "Log Events";
    }

    public int firstLevelChartXLocation() {
        return 50;
    }

    public int secondLevelChartXLocation() {
        return 240;
    }

    public int thirdLevelChartXLocation() {
        return 430;
    }

    public int logsChartXLocation() {
        return 620;
    }

    public int chartWidth() {
        return 170;
    }

    public static AnalysisStrategyDisplay displaySettings(Report report) {
        if (report.isBDD()) {
            return BDD;
        }
        switch (report.getStats().getAnalysisStrategy()) {
            case BDD: {
                return BDD;
            }
            case SUITE: {
                return SUITE;
            }
            case CLASS: {
                return CLASS;
            }
        }
        return TEST;
    }
}

